/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms.optimized;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import pl.fhframework.BindingResult;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DesignerControl;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.DocumentedComponent;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.OverridenPropertyAnnotations;
import pl.fhframework.annotations.OverridenPropertyAnnotationsList;
import pl.fhframework.annotations.XMLMetadataSubelementParent;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.IRowNumberOffsetSupplier;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.core.FhFormException;
import pl.fhframework.core.forms.IHasBoundableLabel;
import pl.fhframework.core.forms.IterationContext;
import pl.fhframework.core.forms.iterators.IMultipleIteratorComponentFactory;
import pl.fhframework.core.forms.iterators.IMultipleIteratorRepeatable;
import pl.fhframework.core.forms.iterators.IRepeatableIteratorInfo;
import pl.fhframework.forms.ICompilerAwareComponent;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.forms.ColumnPaged;
import pl.fhframework.model.forms.CompactLayout;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.FormElement;
import pl.fhframework.model.forms.GroupingComponent;
import pl.fhframework.model.forms.IGroupingComponent;
import pl.fhframework.model.forms.OutputLabel;
import pl.fhframework.model.forms.TablePaged;
import pl.fhframework.model.forms.designer.BindingExpressionDesignerPreviewProvider;
import pl.fhframework.model.forms.optimized.TableCellOptimized;
import pl.fhframework.model.forms.optimized.TableOptimized;
import pl.fhframework.model.forms.table.AdHocTableColumnOptimizedComponentFactory;
import pl.fhframework.model.forms.table.LowLevelRowMetadata;
import pl.fhframework.model.forms.table.RowIteratorMetadata;

@DesignerControl(defaultWidth=-1)
@Control(parents={TableOptimized.class, ColumnOptimized.class}, invalidParents={TablePaged.class, ColumnPaged.class})
@OverridenPropertyAnnotationsList(value={@OverridenPropertyAnnotations(designerXmlProperty={@DesignerXMLProperty(readOnlyInDesigner=false, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.LOOK_AND_STYLE, priority=100)}, property="width"), @OverridenPropertyAnnotations(designerXmlProperty={@DesignerXMLProperty(skip=true)}, property="height")})
@DocumentedComponent(documentationExample=true, value="It is used to construct columns of TableOptimized components.", icon="fa fa-columns")
public class ColumnOptimized
extends GroupingComponent<FormElement>
implements CompactLayout,
IMultipleIteratorRepeatable<TableOptimized>,
ICompilerAwareComponent,
IHasBoundableLabel {
    public static final String ATTR_LABEL = "label";
    public static final String ATTR_VALUE = "value";
    public static final String AUTOMATIC_LABEL_ID_SUFFIX = "_value_based_label";
    @JsonIgnore
    @XMLMetadataSubelementParent
    protected TableOptimized table;
    private String label;
    @JsonIgnore
    @XMLProperty(value="label")
    @DesignerXMLProperty(commonUse=true, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT, priority=30, allowedTypes={String.class}, previewValueProvider=BindingExpressionDesignerPreviewProvider.class)
    @DocumentedComponentAttribute(boundable=true, value="Component label. Supports FHML - FH Markup Language.")
    private ModelBinding labelModelBinding;
    @JsonIgnore
    @XMLProperty
    @DocumentedComponentAttribute(value="Id of formatter which will format object to String. It must be consistend with value of pl.fhframework.formatter.FhFormatter annotation.")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.SPECIFIC, priority=90)
    private String formatter;
    @JsonIgnore
    @XMLProperty(value="value", skipCompiler=true)
    @DesignerXMLProperty(commonUse=true, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT, priority=20, previewValueProvider=BindingExpressionDesignerPreviewProvider.class)
    @DocumentedComponentAttribute(value="Represents text value for created component.")
    private ModelBinding value;
    private Integer rowspan;
    private Boolean fixedHeader;
    @JsonIgnore
    private Integer level;
    private boolean subColumnsExists;
    @XMLProperty
    private String iterationRef;
    @JsonIgnore
    private List<IRepeatableIteratorInfo> iteratorInfos;
    @JsonIgnore
    private TableCellOptimized prototype;
    @JsonIgnore
    protected IMultipleIteratorComponentFactory<TableOptimized> interatorComponentFactory;
    @JsonIgnore
    private OutputLabel implicitOutputLabel;

    public ColumnOptimized(Form form) {
        super(form);
        this.prototype = new TableCellOptimized(form);
        this.prototype.setArtificial(true);
        this.prototype.setGroupingParentComponent((IGroupingComponent)this);
        this.interatorComponentFactory = new AdHocTableColumnOptimizedComponentFactory(this);
    }

    public void init() {
        BindingResult bindingResult;
        if (this.isInitDone()) {
            return;
        }
        if (this.getWidth() != null && this.getWidth().endsWith("%")) {
            this.setWidth(this.getWidth().substring(0, this.getWidth().length() - 1));
        }
        this.subColumnsExists = false;
        if (this.getSubcomponents().stream().anyMatch(c -> c instanceof ColumnOptimized)) {
            this.subColumnsExists = true;
        }
        super.init();
        if (this.getGroupingParentComponent() instanceof ColumnOptimized) {
            this.setLevel(((ColumnOptimized)this.getGroupingParentComponent()).getLevel() + 1);
        } else {
            this.setLevel(1);
        }
        this.refreshImplicitOutputLabel();
        if (this.labelModelBinding != null && (bindingResult = this.labelModelBinding.getBindingResult()) != null) {
            this.label = (String)bindingResult.getValue();
        }
        this.prototype.init();
        this.prototype.doActionForEverySubcomponent(c -> c.init());
        this.fixedHeader = this.table.fixedHeader;
    }

    public void beforeCompilation() {
        this.refreshImplicitOutputLabel();
    }

    private void refreshImplicitOutputLabel() {
        if (this.implicitOutputLabel != null) {
            this.getPrototype().removeSubcomponent((Component)this.implicitOutputLabel);
        }
        if (this.value != null) {
            this.implicitOutputLabel = new OutputLabel(this.getForm());
            this.implicitOutputLabel.setValueBinding(this.value.clone((Component)this.implicitOutputLabel));
            if (this.getId() != null) {
                this.implicitOutputLabel.setId(this.getId() + AUTOMATIC_LABEL_ID_SUFFIX);
            }
            this.implicitOutputLabel.setArtificial(true);
            this.implicitOutputLabel.setWidth("md-12");
            this.getPrototype().getSubcomponents().add(this.implicitOutputLabel);
            this.implicitOutputLabel.setGroupingParentComponent((IGroupingComponent)this.getPrototype());
            this.implicitOutputLabel.setFormatter(this.formatter);
        }
    }

    public void addSubcomponent(FormElement formElement) {
        if (formElement instanceof ColumnOptimized) {
            if (!this.getPrototype().getSubcomponents().isEmpty() || this.getValue() != null) {
                throw new FhFormException("ColumnOptimized cannot have both form elements (or value) and subcolumns");
            }
            super.addSubcomponent((Component)formElement);
        } else {
            if (!this.getSubcolumns().isEmpty()) {
                throw new FhFormException("ColumnOptimized cannot have both form elements and subcolumns");
            }
            this.getPrototype().getSubcomponents().add(formElement);
        }
    }

    protected ElementChanges updateView() {
        String newLabelValue;
        BindingResult bindingResult;
        ElementChanges elementChanges = super.updateView();
        BindingResult bindingResult2 = bindingResult = this.labelModelBinding != null ? this.labelModelBinding.getBindingResult() : null;
        if (bindingResult != null && !this.areValuesTheSame(newLabelValue = this.convertBindingValueToString(bindingResult), this.label)) {
            this.refreshView();
            this.label = newLabelValue;
            elementChanges.addChange(ATTR_LABEL, (Object)this.label);
        }
        return elementChanges;
    }

    public List<IRepeatableIteratorInfo> getIteratorInfos() {
        if (this.iteratorInfos == null || this.getForm().getViewMode() != Form.ViewMode.NORMAL) {
            ArrayList<IRepeatableIteratorInfo> iterators = new ArrayList<IRepeatableIteratorInfo>();
            for (IRepeatableIteratorInfo iRepeatableIteratorInfo : this.getTable().getAllIterators()) {
                iterators.add(iRepeatableIteratorInfo);
                if (this.iterationRef != null && !iRepeatableIteratorInfo.getName().equals(this.iterationRef)) continue;
                break;
            }
            this.iteratorInfos = iterators;
        }
        return this.iteratorInfos;
    }

    public List<Component> getRepeatedComponents() {
        return this.getPrototype().getSubcomponents();
    }

    public boolean isComponentFactorySupported() {
        return this.getSubcolumns().isEmpty();
    }

    public TableOptimized getGroupingComponentForNewComponents() {
        return this.getTable();
    }

    public Component getIteratorDefiningComponent() {
        return this.getTable();
    }

    @JsonIgnore
    public List<ColumnOptimized> getSubcolumns() {
        return this.getSubcomponents().stream().filter(subComponent -> subComponent instanceof ColumnOptimized).map(comp -> (ColumnOptimized)((Object)comp)).collect(Collectors.toList());
    }

    public TableOptimized getTable() {
        if (this.table == null) {
            this.table = ((ColumnOptimized)this.getGroupingParentComponent()).getTable();
        }
        return this.table;
    }

    public void setTable(TableOptimized table) {
        this.table = table;
        this.iteratorInfos = null;
    }

    private TableCellOptimized createCell(LowLevelRowMetadata lowLevelRowMetadata) {
        TableCellOptimized tableCell = this.createEmptyCell();
        RowIteratorMetadata mainTableIteratorMetadata = lowLevelRowMetadata.getIteratorData().get(this.getTable().getIterator());
        tableCell.setRowIndex(mainTableIteratorMetadata.getIndex());
        int mainTableIteratorIndex = mainTableIteratorMetadata.getIndex();
        List cellComponents = this.interatorComponentFactory.createComponentsForIterators((IGroupingComponent)this.getTable(), (IRowNumberOffsetSupplier)this.getTable(), lowLevelRowMetadata.getIteratorsIndices());
        for (FormElement cellComponent : cellComponents) {
            this.getForm().addToElementIdToFormElement(cellComponent);
            this.getTable().getBindedSubcomponents().add(new IterationContext(Integer.valueOf(mainTableIteratorIndex), (Component)cellComponent));
            tableCell.getSubcomponents().add(cellComponent);
            cellComponent.setGroupingParentComponent((IGroupingComponent)tableCell);
        }
        return tableCell;
    }

    public List<FormElement> createTableCells(LowLevelRowMetadata lowLevelRowMetadata) {
        return this.createTableCells(this, lowLevelRowMetadata);
    }

    private List<FormElement> createTableCells(ColumnOptimized columnOrSubcolumn, LowLevelRowMetadata lowLevelRowMetadata) {
        ArrayList<FormElement> tableCells;
        block3: {
            List<ColumnOptimized> subColumns;
            block1: {
                block2: {
                    tableCells = new ArrayList<FormElement>();
                    subColumns = columnOrSubcolumn.getSubcolumns();
                    if (subColumns.size() != 0) break block1;
                    if (this.table.getForm().getViewMode() != Form.ViewMode.NORMAL) break block2;
                    this.createTableCell(columnOrSubcolumn, lowLevelRowMetadata, this.getTable().getColumns()).ifPresent(tableCells::add);
                    break block3;
                }
                if (this.table.getForm().getForm().getViewMode() != Form.ViewMode.PREVIEW) break block3;
                this.createTableCellForDesigner(columnOrSubcolumn, lowLevelRowMetadata, this.getTable().getColumns()).ifPresent(tableCells::add);
                break block3;
            }
            for (ColumnOptimized subColumnElement : subColumns) {
                tableCells.addAll(this.createTableCells(subColumnElement, lowLevelRowMetadata));
            }
        }
        return tableCells;
    }

    private Optional<FormElement> createTableCell(ColumnOptimized column, LowLevelRowMetadata lowLevelRowMetadata, List<ColumnOptimized> columns) {
        column.setRowspan(this.getMaxColumnDepthForLevel(column.getLevel(), columns));
        RowIteratorMetadata rowIteratorMetadata = this.getRowIteratorMetadata(lowLevelRowMetadata, column.getIterationRef());
        TableCellOptimized tableCell = null;
        if (rowIteratorMetadata != null) {
            if (rowIteratorMetadata.isFirstOccurrence()) {
                tableCell = column.createCell(lowLevelRowMetadata);
                tableCell.setRowspan(rowIteratorMetadata.getRowSpan().get());
            }
        } else {
            tableCell = this.createEmptyCell();
            OutputLabel emptyLabel = this.createEmptyOutputLabel();
            emptyLabel.setGroupingParentComponent((IGroupingComponent)tableCell);
            tableCell.addSubcomponent((Component)emptyLabel);
        }
        if (tableCell != null) {
            tableCell.init();
            tableCell.setProcessComponentStateChange(false);
            tableCell.setGroupingParentComponent((IGroupingComponent)column);
        }
        return Optional.ofNullable(tableCell);
    }

    private Optional<FormElement> createTableCellForDesigner(ColumnOptimized column, LowLevelRowMetadata lowLevelRowMetadata, List<ColumnOptimized> columns) {
        TableCellOptimized tableCell = this.createEmptyCell();
        tableCell.setRowspan(1);
        tableCell.setProcessComponentStateChange(false);
        tableCell.setGroupingParentComponent((IGroupingComponent)this);
        for (FormElement prototypeCellComponent : this.prototype.getSubcomponents()) {
            this.getForm().addToElementIdToFormElement(prototypeCellComponent);
            this.getTable().getBindedSubcomponents().add(new IterationContext(Integer.valueOf(0), (Component)prototypeCellComponent));
            prototypeCellComponent.setGroupingParentComponent((IGroupingComponent)tableCell);
            tableCell.getSubcomponents().add(prototypeCellComponent);
        }
        return Optional.of(tableCell);
    }

    protected OutputLabel createEmptyOutputLabel() {
        OutputLabel emptyLabel = new OutputLabel(this.getForm());
        return emptyLabel;
    }

    private RowIteratorMetadata getRowIteratorMetadata(LowLevelRowMetadata lowLevelRowMetadata, String columnIterationRef) {
        if (columnIterationRef == null) {
            columnIterationRef = this.getTable().getIterator();
        }
        return lowLevelRowMetadata.getIteratorData().get(columnIterationRef);
    }

    private void collectSubColumns(int level, List<ColumnOptimized> columns, List<ColumnOptimized> collectedColumns) {
        columns.stream().filter(component -> component instanceof ColumnOptimized).forEach(column -> {
            if (column.getLevel() == level) {
                collectedColumns.add((ColumnOptimized)((Object)column));
            } else if (column.getLevel() < level) {
                this.collectSubColumns(level, column.getSubcomponents().stream().filter(subComponent -> subComponent instanceof ColumnOptimized).map(comp -> (ColumnOptimized)((Object)((Object)comp))).collect(Collectors.toList()), collectedColumns);
            }
        });
    }

    protected int getMaxColumnDepthForLevel(int level, List<ColumnOptimized> components) {
        int initialDepth = 0;
        int maxDepth = 1;
        LinkedList<ColumnOptimized> columns = new LinkedList<ColumnOptimized>();
        this.collectSubColumns(level, components, columns);
        for (ColumnOptimized column : columns) {
            maxDepth = Integer.max(maxDepth, this.getMaxColumnDepth(column, initialDepth));
        }
        return maxDepth;
    }

    private int getMaxColumnDepth(ColumnOptimized column, int initialDepth) {
        List<ColumnOptimized> subcolumns = column.getSubcolumns();
        ++initialDepth;
        if (subcolumns.size() == 0) {
            return initialDepth;
        }
        int maxDepth = initialDepth;
        for (ColumnOptimized subColumnElement : subcolumns) {
            maxDepth = Integer.max(this.getMaxColumnDepth(subColumnElement, initialDepth), maxDepth);
        }
        return maxDepth;
    }

    protected TableCellOptimized createEmptyCell() {
        TableCellOptimized tableCell = new TableCellOptimized(this.getForm());
        tableCell.setHorizontalAlign(this.getHorizontalAlign());
        tableCell.setVerticalAlign(this.getVerticalAlign());
        return tableCell;
    }

    public String getLabel() {
        return this.label;
    }

    public ModelBinding getLabelModelBinding() {
        return this.labelModelBinding;
    }

    @JsonIgnore
    public void setLabelModelBinding(ModelBinding labelModelBinding) {
        this.labelModelBinding = labelModelBinding;
    }

    public String getFormatter() {
        return this.formatter;
    }

    @JsonIgnore
    public void setFormatter(String formatter) {
        this.formatter = formatter;
    }

    public ModelBinding getValue() {
        return this.value;
    }

    @JsonIgnore
    public void setValue(ModelBinding value) {
        this.value = value;
    }

    public Integer getRowspan() {
        return this.rowspan;
    }

    public void setRowspan(Integer rowspan) {
        this.rowspan = rowspan;
    }

    public Boolean getFixedHeader() {
        return this.fixedHeader;
    }

    public void setFixedHeader(Boolean fixedHeader) {
        this.fixedHeader = fixedHeader;
    }

    public Integer getLevel() {
        return this.level;
    }

    @JsonIgnore
    public void setLevel(Integer level) {
        this.level = level;
    }

    public boolean isSubColumnsExists() {
        return this.subColumnsExists;
    }

    public void setSubColumnsExists(boolean subColumnsExists) {
        this.subColumnsExists = subColumnsExists;
    }

    public String getIterationRef() {
        return this.iterationRef;
    }

    public void setIterationRef(String iterationRef) {
        this.iterationRef = iterationRef;
    }

    public TableCellOptimized getPrototype() {
        return this.prototype;
    }

    @JsonIgnore
    public void setPrototype(TableCellOptimized prototype) {
        this.prototype = prototype;
    }

    @JsonIgnore
    public void setInteratorComponentFactory(IMultipleIteratorComponentFactory<TableOptimized> interatorComponentFactory) {
        this.interatorComponentFactory = interatorComponentFactory;
    }
}

