/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.throwing;

import java.util.Objects;
import java.util.function.BiConsumer;
import pl.touk.throwing.ThrowingBiFunction;
import pl.touk.throwing.exception.WrappedException;

@FunctionalInterface
public interface ThrowingBiConsumer<T, U, E extends Throwable> {
    public void accept(T var1, U var2) throws E;

    default public ThrowingBiConsumer<T, U, E> andThenConsume(ThrowingBiConsumer<? super T, ? super U, E> after) {
        Objects.requireNonNull(after);
        return (arg1, arg2) -> {
            this.accept(arg1, arg2);
            after.accept(arg1, arg2);
        };
    }

    default public ThrowingBiFunction<T, U, Void, E> asFunction() {
        return (arg1, arg2) -> {
            this.accept(arg1, arg2);
            return null;
        };
    }

    public static <T, U, E extends Exception> BiConsumer<T, U> unchecked(ThrowingBiConsumer<T, U, E> consumer) {
        Objects.requireNonNull(consumer);
        return consumer.uncheck();
    }

    default public BiConsumer<T, U> uncheck() {
        return (arg1, arg2) -> {
            try {
                this.accept(arg1, arg2);
            }
            catch (Throwable e) {
                throw new WrappedException(e);
            }
        };
    }
}

