/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.throwing;

import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import pl.touk.throwing.ThrowingFunction;
import pl.touk.throwing.exception.WrappedException;

@FunctionalInterface
public interface ThrowingBiFunction<T1, T2, R, E extends Throwable> {
    public R apply(T1 var1, T2 var2) throws E;

    public static <T1, T2, R, E extends Throwable> BiFunction<T1, T2, R> unchecked(ThrowingBiFunction<T1, T2, R, E> function) {
        Objects.requireNonNull(function);
        return function.unchecked();
    }

    public static <T1, T2, R, E extends Exception> BiFunction<T1, T2, Optional<R>> lifted(ThrowingBiFunction<T1, T2, R, E> f) {
        Objects.requireNonNull(f);
        return f.lift();
    }

    default public <V> ThrowingBiFunction<T1, T2, V, E> andThen(ThrowingFunction<? super R, ? extends V, E> after) {
        Objects.requireNonNull(after);
        return (arg1, arg2) -> after.apply((R)this.apply(arg1, arg2));
    }

    default public BiFunction<T1, T2, R> unchecked() {
        return (arg1, arg2) -> {
            try {
                return this.apply(arg1, arg2);
            }
            catch (Throwable e) {
                throw new WrappedException(e);
            }
        };
    }

    default public BiFunction<T1, T2, Optional<R>> lift() {
        return (arg1, arg2) -> {
            try {
                return Optional.of(this.apply(arg1, arg2));
            }
            catch (Throwable e) {
                return Optional.empty();
            }
        };
    }
}

