/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.throwing;

import java.util.Objects;
import java.util.function.BiPredicate;
import pl.touk.throwing.ThrowingBiFunction;
import pl.touk.throwing.exception.WrappedException;

@FunctionalInterface
public interface ThrowingBiPredicate<T, U, E extends Throwable> {
    public boolean test(T var1, U var2) throws E;

    public static <T, U, E extends Exception> BiPredicate<T, U> unchecked(ThrowingBiPredicate<T, U, E> predicate) {
        Objects.requireNonNull(predicate);
        return predicate.uncheck();
    }

    default public ThrowingBiPredicate<T, U, E> and(ThrowingBiPredicate<? super T, ? super U, E> other) {
        Objects.requireNonNull(other);
        return (arg1, arg2) -> this.test(arg1, arg2) && other.test(arg1, arg2);
    }

    default public ThrowingBiPredicate<T, U, E> or(ThrowingBiPredicate<? super T, ? super U, E> other) {
        Objects.requireNonNull(other);
        return (arg1, arg2) -> this.test(arg1, arg2) || other.test(arg1, arg2);
    }

    default public ThrowingBiPredicate<T, U, E> xor(ThrowingBiPredicate<? super T, ? super U, E> other) {
        Objects.requireNonNull(other);
        return (arg1, arg2) -> this.test(arg1, arg2) ^ other.test(arg1, arg2);
    }

    default public ThrowingBiPredicate<T, U, E> negate() {
        return (arg1, arg2) -> !this.test(arg1, arg2);
    }

    default public ThrowingBiFunction<T, U, Boolean, E> asFunction() {
        return this::test;
    }

    default public BiPredicate<T, U> uncheck() {
        return (arg1, arg2) -> {
            try {
                return this.test(arg1, arg2);
            }
            catch (Throwable e) {
                throw new WrappedException(e);
            }
        };
    }
}

