/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.throwing;

import java.util.Objects;
import java.util.function.Consumer;
import pl.touk.throwing.ThrowingFunction;
import pl.touk.throwing.exception.WrappedException;

@FunctionalInterface
public interface ThrowingConsumer<T, E extends Throwable> {
    public void accept(T var1) throws E;

    public static <T, E extends Throwable> Consumer<T> unchecked(ThrowingConsumer<T, E> consumer) {
        Objects.requireNonNull(consumer);
        return consumer.uncheck();
    }

    default public ThrowingConsumer<T, E> andThenConsume(ThrowingConsumer<? super T, E> after) {
        Objects.requireNonNull(after);
        return t -> {
            this.accept(t);
            after.accept(t);
        };
    }

    default public ThrowingFunction<T, Void, E> asFunction() {
        return arg -> {
            this.accept(arg);
            return null;
        };
    }

    default public Consumer<T> uncheck() {
        return t -> {
            try {
                this.accept(t);
            }
            catch (Throwable e) {
                throw new WrappedException(e);
            }
        };
    }
}

