/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.throwing;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import pl.touk.throwing.exception.WrappedException;

@FunctionalInterface
public interface ThrowingFunction<T, R, E extends Throwable> {
    public R apply(T var1) throws E;

    public static <T, E extends Exception> ThrowingFunction<T, T, E> identity() {
        return t -> t;
    }

    public static <T, R, E extends Exception> Function<T, Optional<R>> lifted(ThrowingFunction<T, R, E> f) {
        Objects.requireNonNull(f);
        return f.lift();
    }

    public static <T, R, E extends Exception> Function<T, R> unchecked(ThrowingFunction<T, R, E> f) {
        Objects.requireNonNull(f);
        return f.uncheck();
    }

    default public <V> ThrowingFunction<V, R, E> compose(ThrowingFunction<? super V, ? extends T, E> before) {
        Objects.requireNonNull(before);
        return v -> this.apply(before.apply((Object)v));
    }

    default public <V> ThrowingFunction<T, V, E> andThen(ThrowingFunction<? super R, ? extends V, E> after) {
        Objects.requireNonNull(after);
        return t -> after.apply((R)this.apply(t));
    }

    default public Function<T, Optional<R>> lift() {
        return t -> {
            try {
                return Optional.of(this.apply(t));
            }
            catch (Throwable e) {
                return Optional.empty();
            }
        };
    }

    default public Function<T, R> uncheck() {
        return t -> {
            try {
                return this.apply(t);
            }
            catch (Throwable e) {
                throw new WrappedException(e);
            }
        };
    }
}

