/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.throwing;

import java.util.Objects;
import java.util.function.Predicate;
import pl.touk.throwing.ThrowingFunction;
import pl.touk.throwing.exception.WrappedException;

@FunctionalInterface
public interface ThrowingPredicate<T, E extends Throwable> {
    public boolean test(T var1) throws E;

    public static <T, E extends Throwable> Predicate<T> unchecked(ThrowingPredicate<T, E> predicate) {
        Objects.requireNonNull(predicate);
        return predicate.uncheck();
    }

    default public ThrowingPredicate<T, E> and(ThrowingPredicate<? super T, E> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) && other.test(t);
    }

    default public ThrowingPredicate<T, E> or(ThrowingPredicate<? super T, E> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) || other.test(t);
    }

    default public ThrowingPredicate<T, E> xor(ThrowingPredicate<? super T, E> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) ^ other.test(t);
    }

    default public ThrowingPredicate<T, E> negate() {
        return t -> !this.test(t);
    }

    default public ThrowingFunction<T, Boolean, E> asFunction() {
        return this::test;
    }

    default public Predicate<T> uncheck() {
        return t -> {
            try {
                return this.test(t);
            }
            catch (Throwable e) {
                throw new WrappedException(e);
            }
        };
    }
}

