/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.throwing;

import java.util.Objects;
import pl.touk.throwing.exception.WrappedException;

@FunctionalInterface
public interface ThrowingRunnable<E extends Throwable> {
    public void run() throws E;

    public static <E extends Exception> Runnable unchecked(ThrowingRunnable<E> runnable) {
        Objects.requireNonNull(runnable);
        return runnable.unchecked();
    }

    default public Runnable unchecked() {
        return () -> {
            try {
                this.run();
            }
            catch (Throwable e) {
                throw new WrappedException(e);
            }
        };
    }
}

