/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.throwing;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import pl.touk.throwing.ThrowingFunction;
import pl.touk.throwing.exception.WrappedException;

@FunctionalInterface
public interface ThrowingSupplier<T, E extends Throwable> {
    public T get() throws E;

    default public ThrowingFunction<Void, T, E> asFunction() {
        return arg -> this.get();
    }

    public static <T, E extends Exception> Supplier<T> unchecked(ThrowingSupplier<T, E> supplier) {
        Objects.requireNonNull(supplier);
        return supplier.uncheck();
    }

    public static <T, E extends Exception> Supplier<Optional<T>> lifted(ThrowingSupplier<T, E> supplier) {
        Objects.requireNonNull(supplier);
        return supplier.lift();
    }

    default public Supplier<T> uncheck() {
        return () -> {
            try {
                return this.get();
            }
            catch (Throwable e) {
                throw new WrappedException(e);
            }
        };
    }

    default public Supplier<Optional<T>> lift() {
        return () -> {
            try {
                return Optional.of(this.get());
            }
            catch (Throwable e) {
                return Optional.empty();
            }
        };
    }
}

