/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.throwing;

import java.util.Objects;
import java.util.function.UnaryOperator;
import pl.touk.throwing.ThrowingFunction;
import pl.touk.throwing.exception.WrappedException;

@FunctionalInterface
public interface ThrowingUnaryOperator<T, E extends Throwable>
extends ThrowingFunction<T, T, E> {
    public static <T, E extends Exception> UnaryOperator<T> unchecked(ThrowingUnaryOperator<T, E> operator) {
        Objects.requireNonNull(operator);
        return operator.uncheck();
    }

    default public UnaryOperator<T> uncheck() {
        return t -> {
            try {
                return this.apply(t);
            }
            catch (Throwable e) {
                throw new WrappedException(e);
            }
        };
    }
}

