/*
 * Decompiled with CFR 0.152.
 */
package ru.testit.clients;

import java.util.List;
import java.util.UUID;
import ru.testit.client.api.AutoTestsApi;
import ru.testit.client.api.TestRunsApi;
import ru.testit.client.invoker.ApiException;
import ru.testit.client.model.AutoTestModel;
import ru.testit.client.model.AutoTestPostModel;
import ru.testit.client.model.AutoTestPutModel;
import ru.testit.client.model.AutoTestResultsForTestRunModel;
import ru.testit.client.model.TestRunV2GetModel;
import ru.testit.client.model.TestRunV2PostShortModel;
import ru.testit.clients.ApiClient;
import ru.testit.clients.ClientConfiguration;

public class TmsApiClient
implements ApiClient {
    private static final String AUTH_PREFIX = "PrivateToken";
    private static final boolean INCLUDE_STEPS = true;
    private static final boolean INCLUDE_LABELS = true;
    private final TestRunsApi testRunsApi;
    private final AutoTestsApi autoTestsApi;

    public TmsApiClient(ClientConfiguration config) {
        ru.testit.client.invoker.ApiClient apiClient = new ru.testit.client.invoker.ApiClient();
        apiClient.setBasePath(config.getUrl());
        apiClient.setApiKeyPrefix(AUTH_PREFIX);
        apiClient.setApiKey(config.getPrivateToken());
        this.testRunsApi = new TestRunsApi(apiClient);
        this.autoTestsApi = new AutoTestsApi(apiClient);
    }

    @Override
    public TestRunV2GetModel createTestRun(TestRunV2PostShortModel model) throws ApiException {
        return this.testRunsApi.createEmpty(model);
    }

    @Override
    public TestRunV2GetModel getTestRun(String uuid) throws ApiException {
        return this.testRunsApi.getTestRunById(UUID.fromString(uuid));
    }

    @Override
    public void completeTestRun(String uuid) throws ApiException {
        this.testRunsApi.completeTestRun(UUID.fromString(uuid));
    }

    @Override
    public void updateAutoTest(AutoTestPutModel model) throws ApiException {
        this.autoTestsApi.updateAutoTest(model);
    }

    @Override
    public void createAutoTest(AutoTestPostModel model) throws ApiException {
        this.autoTestsApi.createAutoTest(model);
    }

    @Override
    public AutoTestModel getAutoTestByExternalId(String projectId, String externalId) throws ApiException {
        List tests = this.autoTestsApi.getAllAutoTests(UUID.fromString(projectId), externalId, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, Boolean.valueOf(true), Boolean.valueOf(true), null, null, null, null, null);
        if ((long)tests.size() == 0L) {
            return null;
        }
        return (AutoTestModel)tests.get(0);
    }

    @Override
    public void sendTestResults(String testRunUuid, List<AutoTestResultsForTestRunModel> models) throws ApiException {
        this.testRunsApi.setAutoTestResultsForTestRun(UUID.fromString(testRunUuid), models);
    }
}

