/*
 * Decompiled with CFR 0.152.
 */
package ru.testit.properties;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppProperties {
    private static final String PROPERTIES_FILE = "testit.properties";
    private static final Logger log = LoggerFactory.getLogger(AppProperties.class);

    public static Properties loadProperties() {
        Properties properties = new Properties();
        AppProperties.loadPropertiesFrom(Thread.currentThread().getContextClassLoader(), properties);
        AppProperties.loadPropertiesFrom(ClassLoader.getSystemClassLoader(), properties);
        properties.putAll(System.getenv());
        return properties;
    }

    private static void loadPropertiesFrom(ClassLoader classLoader, Properties properties) {
        try (InputStream stream = classLoader.getResourceAsStream(PROPERTIES_FILE);){
            if (stream != null) {
                properties.load(stream);
            }
        }
        catch (IOException e) {
            log.error("Exception while read properties: {}", (Object)e.getMessage());
        }
    }
}

