/*
 * Decompiled with CFR 0.152.
 */
package ru.testit.services;

import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import ru.testit.annotations.Description;
import ru.testit.annotations.DisplayName;
import ru.testit.annotations.ExternalId;
import ru.testit.annotations.Labels;
import ru.testit.annotations.Link;
import ru.testit.annotations.Links;
import ru.testit.annotations.Title;
import ru.testit.annotations.WorkItemId;
import ru.testit.models.Label;
import ru.testit.models.LinkItem;

public class Utils {
    public static String extractExternalID(Method atomicTest) {
        ExternalId annotation = atomicTest.getAnnotation(ExternalId.class);
        return annotation != null ? annotation.value() : null;
    }

    public static String extractDisplayName(Method atomicTest) {
        DisplayName annotation = atomicTest.getAnnotation(DisplayName.class);
        return annotation != null ? annotation.value() : null;
    }

    public static String extractWorkItemId(Method method) {
        WorkItemId annotation = method.getAnnotation(WorkItemId.class);
        return annotation != null ? annotation.value() : null;
    }

    public static List<LinkItem> extractLinks(Method method) {
        LinkedList<LinkItem> links = new LinkedList<LinkItem>();
        Links linksAnnotation = method.getAnnotation(Links.class);
        if (linksAnnotation != null) {
            for (Link link : linksAnnotation.links()) {
                links.add(Utils.makeLink(link));
            }
        } else {
            Link linkAnnotation = method.getAnnotation(Link.class);
            if (linkAnnotation != null) {
                links.add(Utils.makeLink(linkAnnotation));
            }
        }
        return links;
    }

    public static List<Label> extractLabels(Method method) {
        LinkedList<Label> labels = new LinkedList<Label>();
        Labels annotation = method.getAnnotation(Labels.class);
        if (annotation != null) {
            for (String s : annotation.value()) {
                Label label = new Label();
                label.setName(s);
                labels.add(label);
            }
        }
        return labels;
    }

    public static String extractDescription(Method currentTest) {
        Description annotation = currentTest.getAnnotation(Description.class);
        return annotation != null ? annotation.value() : null;
    }

    public static String extractTitle(Method currentTest) {
        Title annotation = currentTest.getAnnotation(Title.class);
        return annotation != null ? annotation.value() : null;
    }

    private static LinkItem makeLink(Link linkAnnotation) {
        return new LinkItem().setTitle(linkAnnotation.title()).setDescription(linkAnnotation.description()).setUrl(linkAnnotation.url()).setType(linkAnnotation.type());
    }

    public static String urlTrim(String url) {
        if (url.endsWith("/")) {
            return Utils.removeTrailing(url);
        }
        return url;
    }

    private static String removeTrailing(String s) {
        StringBuilder sb = new StringBuilder(s);
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }
}

