/*
 * Decompiled with CFR 0.152.
 */
package ru.testit.writers;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.testit.client.invoker.ApiException;
import ru.testit.client.model.AttachmentPutModelAutoTestStepResultsModel;
import ru.testit.client.model.AutoTestModel;
import ru.testit.client.model.AutoTestPostModel;
import ru.testit.client.model.AutoTestPutModel;
import ru.testit.client.model.AutoTestResultsForTestRunModel;
import ru.testit.client.model.AutoTestStepModel;
import ru.testit.client.model.TestRunStateTypeModel;
import ru.testit.client.model.TestRunV2GetModel;
import ru.testit.client.model.TestRunV2PostShortModel;
import ru.testit.clients.ApiClient;
import ru.testit.clients.ClientConfiguration;
import ru.testit.models.ClassContainer;
import ru.testit.models.MainContainer;
import ru.testit.models.TestResult;
import ru.testit.services.ResultStorage;
import ru.testit.writers.Converter;
import ru.testit.writers.Writer;

public class HttpWriter
implements Writer {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpWriter.class);
    private final ApiClient apiClient;
    private final ResultStorage storage;
    private final ClientConfiguration config;

    public HttpWriter(ClientConfiguration config, ApiClient client, ResultStorage storage) {
        this.config = config;
        this.apiClient = client;
        this.storage = storage;
    }

    @Override
    public void startLaunch() {
        if (!Objects.equals(this.config.getTestRunId(), "null")) {
            return;
        }
        TestRunV2PostShortModel model = new TestRunV2PostShortModel();
        model.setProjectId(UUID.fromString(this.config.getProjectId()));
        try {
            TestRunV2GetModel response = this.apiClient.createTestRun(model);
            this.config.setTestRunId(response.getId().toString());
        }
        catch (ApiException e) {
            LOGGER.error("Can not start the launch: ".concat(e.getMessage()));
        }
    }

    @Override
    public void finishLaunch() {
        try {
            TestRunV2GetModel testRun = this.apiClient.getTestRun(this.config.getTestRunId());
            if (testRun.getStateName() != TestRunStateTypeModel.COMPLETED) {
                this.apiClient.completeTestRun(this.config.getTestRunId());
            }
        }
        catch (ApiException e) {
            if (e.getResponseBody().contains("the StateName is already Completed")) {
                return;
            }
            LOGGER.error("Can not finish the launch: ".concat(e.getMessage()));
        }
    }

    @Override
    public void writeTest(TestResult testResult) {
        try {
            AutoTestModel test = this.apiClient.getAutoTestByExternalId(this.config.getProjectId(), testResult.getExternalId());
            if (test != null) {
                AutoTestPutModel autoTestPutModel = Converter.testResultToAutoTestPutModel(this.storage, testResult);
                autoTestPutModel.setProjectId(UUID.fromString(this.config.getProjectId()));
                this.apiClient.updateAutoTest(autoTestPutModel);
                return;
            }
            AutoTestPostModel model = Converter.testResultToAutoTestPostModel(this.storage, testResult);
            model.setProjectId(UUID.fromString(this.config.getProjectId()));
            this.apiClient.createAutoTest(model);
        }
        catch (ApiException e) {
            LOGGER.error("Can not write the autotest: ".concat(e.getMessage()));
        }
    }

    @Override
    public void writeClass(ClassContainer container) {
        for (String testUuid : container.getChildren()) {
            this.storage.getTestResult(testUuid).ifPresent(test -> {
                try {
                    AutoTestModel autoTestModel = this.apiClient.getAutoTestByExternalId(this.config.getProjectId(), test.getExternalId());
                    if (autoTestModel == null) {
                        return;
                    }
                    AutoTestPutModel autoTestPutModel = Converter.autoTestModelToAutoTestPutModel(autoTestModel);
                    List<AutoTestStepModel> beforeClass = Converter.convertFixture(this.storage, container.getBeforeClassMethods(), null);
                    List<AutoTestStepModel> beforeEach = Converter.convertFixture(this.storage, container.getBeforeEachTest(), testUuid);
                    beforeClass.addAll(beforeEach);
                    List<AutoTestStepModel> afterClass = Converter.convertFixture(this.storage, container.getAfterClassMethods(), null);
                    List<AutoTestStepModel> afterEach = Converter.convertFixture(this.storage, container.getAfterEachTest(), testUuid);
                    afterClass.addAll(afterEach);
                    autoTestPutModel.setSetup(beforeClass);
                    autoTestPutModel.setTeardown(afterClass);
                    this.apiClient.updateAutoTest(autoTestPutModel);
                }
                catch (ApiException e) {
                    LOGGER.error("Can not write the class: ".concat(e.getMessage()));
                }
            });
        }
    }

    @Override
    public void writeTests(MainContainer container) {
        List<AutoTestStepModel> beforeAll = Converter.convertFixture(this.storage, container.getBeforeMethods(), null);
        List<AutoTestStepModel> afterAll = Converter.convertFixture(this.storage, container.getAfterMethods(), null);
        List<AttachmentPutModelAutoTestStepResultsModel> beforeResultAll = Converter.convertResultFixture(this.storage, container.getBeforeMethods(), null);
        List<AttachmentPutModelAutoTestStepResultsModel> afterResultAll = Converter.convertResultFixture(this.storage, container.getAfterMethods(), null);
        ArrayList<AutoTestResultsForTestRunModel> results = new ArrayList<AutoTestResultsForTestRunModel>();
        for (String classUuid : container.getChildren()) {
            this.storage.getClassContainer(classUuid).ifPresent(cl -> {
                List<AttachmentPutModelAutoTestStepResultsModel> beforeResultClass = Converter.convertResultFixture(this.storage, cl.getBeforeClassMethods(), null);
                List<AttachmentPutModelAutoTestStepResultsModel> afterResultClass = Converter.convertResultFixture(this.storage, cl.getAfterClassMethods(), null);
                for (String testUuid : cl.getChildren()) {
                    this.storage.getTestResult(testUuid).ifPresent(test -> {
                        try {
                            AutoTestModel autoTestModel = this.apiClient.getAutoTestByExternalId(this.config.getProjectId(), test.getExternalId());
                            if (autoTestModel == null) {
                                return;
                            }
                            AutoTestPutModel autoTestPutModel = Converter.autoTestModelToAutoTestPutModel(autoTestModel);
                            List beforeFinish = beforeAll;
                            beforeFinish.addAll(autoTestPutModel.getSetup());
                            autoTestPutModel.setSetup(beforeFinish);
                            List<AutoTestStepModel> afterClass = Converter.convertFixture(this.storage, cl.getAfterClassMethods(), null);
                            List afterFinish = autoTestPutModel.getTeardown();
                            afterFinish.addAll(afterClass);
                            afterFinish.addAll(afterAll);
                            autoTestPutModel.setTeardown(afterFinish);
                            this.apiClient.updateAutoTest(autoTestPutModel);
                            AutoTestResultsForTestRunModel autoTestResultsForTestRunModel = Converter.testResultToAutoTestResultsForTestRunModel(this.storage, test);
                            autoTestResultsForTestRunModel.setConfigurationId(UUID.fromString(this.config.getConfigurationId()));
                            List<AttachmentPutModelAutoTestStepResultsModel> beforeResultEach = Converter.convertResultFixture(this.storage, cl.getBeforeEachTest(), testUuid);
                            ArrayList<AttachmentPutModelAutoTestStepResultsModel> beforeResultFinish = new ArrayList<AttachmentPutModelAutoTestStepResultsModel>();
                            beforeResultFinish.addAll(beforeResultAll);
                            beforeResultFinish.addAll(beforeResultClass);
                            beforeResultFinish.addAll(beforeResultEach);
                            List<AttachmentPutModelAutoTestStepResultsModel> afterResultEach = Converter.convertResultFixture(this.storage, cl.getAfterEachTest(), testUuid);
                            ArrayList<AttachmentPutModelAutoTestStepResultsModel> afterResultFinish = new ArrayList<AttachmentPutModelAutoTestStepResultsModel>();
                            afterResultFinish.addAll(afterResultEach);
                            afterResultFinish.addAll(afterResultClass);
                            afterResultFinish.addAll(afterResultAll);
                            autoTestResultsForTestRunModel.setSetupResults(beforeResultFinish);
                            autoTestResultsForTestRunModel.setTeardownResults(afterResultFinish);
                            results.add(autoTestResultsForTestRunModel);
                        }
                        catch (ApiException e) {
                            LOGGER.error("Can not update the autotest: ".concat(e.getMessage()));
                        }
                    });
                }
            });
        }
        try {
            this.apiClient.sendTestResults(this.config.getTestRunId(), results);
        }
        catch (ApiException e) {
            LOGGER.error("Can not write the test results: ".concat(e.getMessage()));
        }
    }
}

