/*
 * Decompiled with CFR 0.152.
 */
package ru.testit.clients;

import java.io.File;
import java.util.List;
import java.util.UUID;
import ru.testit.client.api.AttachmentsApi;
import ru.testit.client.api.AutoTestsApi;
import ru.testit.client.api.TestRunsApi;
import ru.testit.client.invoker.ApiException;
import ru.testit.client.model.AttachmentModel;
import ru.testit.client.model.AutoTestModel;
import ru.testit.client.model.AutoTestPostModel;
import ru.testit.client.model.AutoTestPutModel;
import ru.testit.client.model.AutoTestResultsForTestRunModel;
import ru.testit.client.model.TestRunV2GetModel;
import ru.testit.client.model.TestRunV2PostShortModel;
import ru.testit.client.model.WorkItemIdModel;
import ru.testit.clients.ApiClient;
import ru.testit.clients.ApiClientExtended;
import ru.testit.clients.ClientConfiguration;

public class TmsApiClient
implements ApiClient {
    private static final String AUTH_PREFIX = "PrivateToken";
    private static final boolean INCLUDE_STEPS = true;
    private static final boolean INCLUDE_LABELS = true;
    private final TestRunsApi testRunsApi;
    private final AutoTestsApi autoTestsApi;
    private final AttachmentsApi attachmentsApi;

    public TmsApiClient(ClientConfiguration config) {
        ApiClientExtended apiClient = new ApiClientExtended();
        apiClient.setBasePath(config.getUrl());
        apiClient.setApiKeyPrefix(AUTH_PREFIX);
        apiClient.setApiKey(config.getPrivateToken());
        this.testRunsApi = new TestRunsApi((ru.testit.client.invoker.ApiClient)apiClient);
        this.autoTestsApi = new AutoTestsApi((ru.testit.client.invoker.ApiClient)apiClient);
        this.attachmentsApi = new AttachmentsApi((ru.testit.client.invoker.ApiClient)apiClient);
    }

    @Override
    public TestRunV2GetModel createTestRun(TestRunV2PostShortModel model) throws ApiException {
        TestRunV2GetModel response = this.testRunsApi.createEmpty(model);
        this.testRunsApi.startTestRun(response.getId());
        return response;
    }

    @Override
    public TestRunV2GetModel getTestRun(String uuid) throws ApiException {
        return this.testRunsApi.getTestRunById(UUID.fromString(uuid));
    }

    @Override
    public void completeTestRun(String uuid) throws ApiException {
        this.testRunsApi.completeTestRun(UUID.fromString(uuid));
    }

    @Override
    public void updateAutoTest(AutoTestPutModel model) throws ApiException {
        this.autoTestsApi.updateAutoTest(model);
    }

    @Override
    public String createAutoTest(AutoTestPostModel model) throws ApiException {
        return this.autoTestsApi.createAutoTest(model).getId().toString();
    }

    @Override
    public AutoTestModel getAutoTestByExternalId(String projectId, String externalId) throws ApiException {
        List tests = this.autoTestsApi.getAllAutoTests(UUID.fromString(projectId), externalId, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, Boolean.valueOf(true), Boolean.valueOf(true), null, null, null, null, null);
        if ((long)tests.size() == 0L) {
            return null;
        }
        return (AutoTestModel)tests.get(0);
    }

    @Override
    public void linkAutoTestToWorkItem(String id, String workItemId) throws ApiException {
        this.autoTestsApi.linkAutoTestToWorkItem(id, new WorkItemIdModel().id(workItemId));
    }

    @Override
    public void sendTestResults(String testRunUuid, List<AutoTestResultsForTestRunModel> models) throws ApiException {
        this.testRunsApi.setAutoTestResultsForTestRun(UUID.fromString(testRunUuid), models);
    }

    @Override
    public String addAttachment(String path) throws ApiException {
        File file = new File(path);
        AttachmentModel model = this.attachmentsApi.apiV2AttachmentsPost(file);
        return model.getId().toString();
    }
}

