/*
 * Decompiled with CFR 0.152.
 */
package ru.testit.services;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import ru.testit.models.LinkItem;
import ru.testit.models.LinkType;
import ru.testit.services.AdapterManager;
import ru.testit.services.ResultStorage;

public final class Adapter {
    private static AdapterManager adapterManager;
    private static ResultStorage storage;

    public static AdapterManager getAdapterManager() {
        if (Objects.isNull(adapterManager)) {
            adapterManager = new AdapterManager();
        }
        return adapterManager;
    }

    public static ResultStorage getResultStorage() {
        if (Objects.isNull(storage)) {
            storage = new ResultStorage();
        }
        return storage;
    }

    @Deprecated
    public static void link(String title, String description, LinkType type, String url) {
        LinkItem link = new LinkItem().setTitle(title).setDescription(description).setType(type).setUrl(url);
        Adapter.getAdapterManager().updateTestCase(testResult -> testResult.getResultLinks().add(link));
    }

    public static void addLink(String url, String title, String description, LinkType type) {
        final LinkItem link = new LinkItem().setTitle(title).setDescription(description).setType(type).setUrl(url);
        Adapter.addLinks((List<LinkItem>)new ArrayList<LinkItem>(){
            {
                this.add(link);
            }
        });
    }

    public static void addLinks(List<LinkItem> links) {
        Adapter.getAdapterManager().updateTestCase(testResult -> testResult.getResultLinks().addAll(links));
    }

    public static void addAttachments(List<String> attachments) {
        Adapter.getAdapterManager().addAttachments(attachments);
    }

    public static void addAttachment(final String attachment) {
        Adapter.getAdapterManager().addAttachments((List<String>)new ArrayList<String>(){
            {
                this.add(attachment);
            }
        });
    }

    public static void addMessage(String message) {
        Adapter.getAdapterManager().updateTestCase(testResult -> testResult.setMessage(message));
    }
}

