/*
 * Decompiled with CFR 0.152.
 */
package ru.testit.services;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.testit.clients.ClientConfiguration;
import ru.testit.clients.TmsApiClient;
import ru.testit.models.ClassContainer;
import ru.testit.models.FixtureResult;
import ru.testit.models.ItemStage;
import ru.testit.models.MainContainer;
import ru.testit.models.ResultWithAttachments;
import ru.testit.models.ResultWithSteps;
import ru.testit.models.StepResult;
import ru.testit.models.TestResult;
import ru.testit.properties.AppProperties;
import ru.testit.services.Adapter;
import ru.testit.services.ResultStorage;
import ru.testit.services.ThreadContext;
import ru.testit.writers.HttpWriter;
import ru.testit.writers.Writer;

public class AdapterManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdapterManager.class);
    private final ThreadContext threadContext;
    private final ResultStorage storage;
    private final Writer writer;

    public AdapterManager() {
        this.storage = Adapter.getResultStorage();
        this.threadContext = new ThreadContext();
        Properties appProperties = AppProperties.loadProperties();
        ClientConfiguration clientConfiguration = new ClientConfiguration(appProperties);
        TmsApiClient client = new TmsApiClient(clientConfiguration);
        this.writer = new HttpWriter(clientConfiguration, client, this.storage);
    }

    public AdapterManager(ThreadContext threadContext, ResultStorage storage, Writer writer) {
        this.threadContext = threadContext;
        this.storage = storage;
        this.writer = writer;
    }

    public void startTests() {
        this.writer.startLaunch();
    }

    public void stopTests() {
        this.writer.finishLaunch();
    }

    public void startMainContainer(MainContainer container) {
        container.setStart(System.currentTimeMillis());
        this.storage.put(container.getUuid(), container);
    }

    public void stopMainContainer(String uuid) {
        Optional<MainContainer> found = this.storage.getTestsContainer(uuid);
        if (!found.isPresent()) {
            LOGGER.error("Could not stop main container: container with uuid {} not found", (Object)uuid);
            return;
        }
        MainContainer container = found.get();
        container.setStop(System.currentTimeMillis());
        this.writer.writeTests(container);
    }

    public void startClassContainer(String parentUuid, ClassContainer container) {
        this.storage.getTestsContainer(parentUuid).ifPresent(parent -> {
            ResultStorage resultStorage = this.storage;
            synchronized (resultStorage) {
                parent.getChildren().add(container.getUuid());
            }
        });
        container.setStart(System.currentTimeMillis());
        this.storage.put(container.getUuid(), container);
    }

    public void stopClassContainer(String uuid) {
        Optional<ClassContainer> found = this.storage.getClassContainer(uuid);
        if (!found.isPresent()) {
            LOGGER.error("Could not stop class container: container with uuid {} not found", (Object)uuid);
            return;
        }
        ClassContainer container = found.get();
        container.setStop(System.currentTimeMillis());
        this.writer.writeClass(container);
    }

    public void updateClassContainer(String uuid, Consumer<ClassContainer> update) {
        Optional<ClassContainer> found = this.storage.getClassContainer(uuid);
        if (!found.isPresent()) {
            LOGGER.error("Could not update class container: container with uuid {} not found", (Object)uuid);
            return;
        }
        ClassContainer container = found.get();
        update.accept(container);
    }

    public void startTestCase(String uuid) {
        this.threadContext.clear();
        Optional<TestResult> found = this.storage.getTestResult(uuid);
        if (!found.isPresent()) {
            LOGGER.error("Could not start test case: test case with uuid {} is not scheduled", (Object)uuid);
            return;
        }
        TestResult testResult = found.get();
        testResult.setItemStage(ItemStage.RUNNING).setStart(System.currentTimeMillis());
        this.threadContext.start(uuid);
    }

    public void scheduleTestCase(TestResult result) {
        result.setItemStage(ItemStage.SCHEDULED);
        this.storage.put(result.getUuid(), result);
    }

    public void updateTestCase(Consumer<TestResult> update) {
        Optional<String> root = this.threadContext.getRoot();
        if (!root.isPresent()) {
            LOGGER.error("Could not update test case: no test case running");
            return;
        }
        String uuid = root.get();
        this.updateTestCase(uuid, update);
    }

    public void updateTestCase(String uuid, Consumer<TestResult> update) {
        Optional<TestResult> found = this.storage.getTestResult(uuid);
        if (!found.isPresent()) {
            LOGGER.error("Could not update test case: test case with uuid {} not found", (Object)uuid);
            return;
        }
        TestResult testResult = found.get();
        update.accept(testResult);
    }

    public void stopTestCase(String uuid) {
        Optional<TestResult> found = this.storage.getTestResult(uuid);
        if (!found.isPresent()) {
            LOGGER.error("Could not stop test case: test case with uuid {} not found", (Object)uuid);
            return;
        }
        TestResult testResult = found.get();
        testResult.setItemStage(ItemStage.FINISHED).setStop(System.currentTimeMillis());
        this.threadContext.clear();
        this.writer.writeTest(testResult);
    }

    public void startPrepareFixtureAll(String parentUuid, String uuid, FixtureResult result) {
        this.storage.getTestsContainer(parentUuid).ifPresent(container -> {
            ResultStorage resultStorage = this.storage;
            synchronized (resultStorage) {
                container.getBeforeMethods().add(uuid);
            }
        });
        this.startFixture(uuid, result);
    }

    public void startTearDownFixtureAll(String parentUuid, String uuid, FixtureResult result) {
        this.storage.getTestsContainer(parentUuid).ifPresent(container -> {
            ResultStorage resultStorage = this.storage;
            synchronized (resultStorage) {
                container.getAfterMethods().add(uuid);
            }
        });
        this.startFixture(uuid, result);
    }

    public void startPrepareFixture(String parentUuid, String uuid, FixtureResult result) {
        this.storage.getClassContainer(parentUuid).ifPresent(container -> {
            ResultStorage resultStorage = this.storage;
            synchronized (resultStorage) {
                container.getBeforeClassMethods().add(uuid);
            }
        });
        this.startFixture(uuid, result);
    }

    public void startTearDownFixture(String parentUuid, String uuid, FixtureResult result) {
        this.storage.getClassContainer(parentUuid).ifPresent(container -> {
            ResultStorage resultStorage = this.storage;
            synchronized (resultStorage) {
                container.getAfterClassMethods().add(uuid);
            }
        });
        this.startFixture(uuid, result);
    }

    public void startPrepareFixtureEachTest(String parentUuid, String uuid, FixtureResult result) {
        this.storage.getClassContainer(parentUuid).ifPresent(container -> {
            ResultStorage resultStorage = this.storage;
            synchronized (resultStorage) {
                container.getBeforeEachTest().add(uuid);
            }
        });
        this.startFixture(uuid, result);
    }

    public void startTearDownFixtureEachTest(String parentUuid, String uuid, FixtureResult result) {
        this.storage.getClassContainer(parentUuid).ifPresent(container -> {
            ResultStorage resultStorage = this.storage;
            synchronized (resultStorage) {
                container.getAfterEachTest().add(uuid);
            }
        });
        this.startFixture(uuid, result);
    }

    private void startFixture(String uuid, FixtureResult result) {
        this.storage.put(uuid, result);
        result.setItemStage(ItemStage.RUNNING).setStart(System.currentTimeMillis());
        this.threadContext.clear();
        this.threadContext.start(uuid);
    }

    public void updateFixture(String uuid, Consumer<FixtureResult> update) {
        Optional<FixtureResult> found = this.storage.getFixture(uuid);
        if (!found.isPresent()) {
            LOGGER.error("Could not update test fixture: test fixture with uuid {} not found", (Object)uuid);
            return;
        }
        FixtureResult fixture = found.get();
        update.accept(fixture);
    }

    public void stopFixture(String uuid) {
        Optional<FixtureResult> found = this.storage.getFixture(uuid);
        if (!found.isPresent()) {
            LOGGER.error("Could not stop test fixture: test fixture with uuid {} not found", (Object)uuid);
            return;
        }
        FixtureResult fixture = found.get();
        fixture.setItemStage(ItemStage.FINISHED).setStop(System.currentTimeMillis());
        this.threadContext.clear();
    }

    public void startStep(String uuid, StepResult result) {
        Optional<String> current = this.threadContext.getCurrent();
        if (!current.isPresent()) {
            LOGGER.error("Could not start step: no test case running");
            return;
        }
        String parentUuid = current.get();
        this.startStep(parentUuid, uuid, result);
    }

    public void startStep(String parentUuid, String uuid, StepResult result) {
        result.setItemStage(ItemStage.RUNNING).setStart(System.currentTimeMillis());
        this.threadContext.start(uuid);
        this.storage.put(uuid, result);
        this.storage.get(parentUuid, ResultWithSteps.class).ifPresent(parentStep -> {
            ResultStorage resultStorage = this.storage;
            synchronized (resultStorage) {
                parentStep.getSteps().add(uuid);
            }
        });
    }

    public void updateStep(Consumer<StepResult> update) {
        Optional<String> current = this.threadContext.getCurrent();
        if (!current.isPresent()) {
            LOGGER.error("Could not update step: no step running");
            return;
        }
        String uuid = current.get();
        this.updateStep(uuid, update);
    }

    public void updateStep(String uuid, Consumer<StepResult> update) {
        Optional<StepResult> found = this.storage.getStep(uuid);
        if (!found.isPresent()) {
            LOGGER.error("Could not update step: step with uuid {} not found", (Object)uuid);
            return;
        }
        StepResult step = found.get();
        update.accept(step);
    }

    public void stopStep() {
        String root = this.threadContext.getRoot().orElse(null);
        Optional<String> current = this.threadContext.getCurrent().filter(uuid -> !Objects.equals(uuid, root));
        if (!current.isPresent()) {
            LOGGER.error("Could not stop step: no step running");
            return;
        }
        String uuid2 = current.get();
        this.stopStep(uuid2);
    }

    private void stopStep(String uuid) {
        Optional<StepResult> found = this.storage.getStep(uuid);
        if (!found.isPresent()) {
            LOGGER.error("Could not stop step: step with uuid {} not found", (Object)uuid);
            return;
        }
        StepResult step = found.get();
        step.setItemStage(ItemStage.FINISHED);
        step.setStop(System.currentTimeMillis());
        this.threadContext.stop();
    }

    public void addAttachments(List<String> attachments) {
        ArrayList<String> uuids = new ArrayList<String>();
        for (String attachment : attachments) {
            uuids.add(this.writer.writeAttachment(attachment));
        }
        Optional<String> current = this.threadContext.getCurrent();
        if (!current.isPresent()) {
            LOGGER.error("Could not add attachment: no test is running");
            return;
        }
        this.storage.get(current.get(), ResultWithAttachments.class).ifPresent(result -> {
            ResultStorage resultStorage = this.storage;
            synchronized (resultStorage) {
                result.getAttachments().addAll(uuids);
            }
        });
    }
}

