/*
 * Decompiled with CFR 0.152.
 */
package ru.testit.clients;

import jakarta.ws.rs.core.GenericType;
import java.io.File;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import ru.testit.client.invoker.ApiClient;
import ru.testit.client.invoker.ApiException;
import ru.testit.client.invoker.ApiResponse;
import ru.testit.client.invoker.Pair;

public class ApiClientExtended
extends ApiClient {
    protected Random random = new Random();
    protected String multipartBoundary = "";

    public String serializeToString(Object obj, Map<String, Object> formParams, String contentType, boolean isBodyNullable) throws ApiException {
        String sep = "\r\n";
        String disposition = "Content-Disposition: form-data; name=\"$\"";
        String dispositionFile = "Content-Disposition: form-data; name=\"$\"; filename=\"@\"";
        if (!contentType.startsWith("multipart/form-data")) {
            return super.serializeToString(obj, formParams, contentType, isBodyNullable);
        }
        StringBuilder s = new StringBuilder();
        formParams.entrySet().forEach(e -> {
            String name = ((String)e.getKey()).replace("&", "ampersand");
            try {
                s.append("\r\n").append(this.multipartBoundary).append("\r\n");
                if (e.getValue() instanceof File) {
                    File f = (File)e.getValue();
                    s.append("Content-Disposition: form-data; name=\"$\"; filename=\"@\"".replace("$", name).replace("@", f.getName().replace("\"", ""))).append("\r\n").append("\r\n");
                    byte[] bytes = Files.readAllBytes(f.toPath());
                    s.append(bytes);
                } else {
                    s.append("Content-Disposition: form-data; name=\"$\"".replace("$", name)).append("\r\n").append("\r\n");
                    s.append(e.getValue());
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getMessage());
            }
        });
        return s.toString();
    }

    public <T> ApiResponse<T> invokeAPI(String operation, String path, String method, List<Pair> queryParams, Object body, Map<String, String> headerParams, Map<String, String> cookieParams, Map<String, Object> formParams, String accept, String contentType, String[] authNames, GenericType<T> returnType, boolean isBodyNullable) throws ApiException {
        if (Objects.equals(contentType, "multipart/form-data")) {
            this.multipartBoundary = "-----abcdefg" + this.random.nextInt(99999999);
            contentType = contentType + "; boundary=" + this.multipartBoundary;
        }
        return super.invokeAPI(operation, path, method, queryParams, body, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType, isBodyNullable);
    }
}

