/*
 * Decompiled with CFR 0.152.
 */
package ru.testit.properties;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppProperties {
    public static final String URL = "url";
    public static final String PRIVATE_TOKEN = "privateToken";
    public static final String PROJECT_ID = "projectId";
    public static final String CONFIGURATION_ID = "configurationId";
    public static final String TEST_RUN_ID = "testRunId";
    public static final String TEST_RUN_NAME = "testRunName";
    public static final String ADAPTER_MODE = "adapterMode";
    private static final String ENV_PREFIX = "TMS";
    private static final String CONFIG_FILE = "CONFIG_FILE";
    private static final String PROPERTIES_FILE = "testit.properties";
    private static final Logger log = LoggerFactory.getLogger(AppProperties.class);

    public static Properties loadProperties() {
        String configFile = AppProperties.getConfigFileName();
        Properties properties = new Properties();
        AppProperties.loadPropertiesFrom(Thread.currentThread().getContextClassLoader(), properties, configFile);
        AppProperties.loadPropertiesFrom(ClassLoader.getSystemClassLoader(), properties, configFile);
        if (!String.valueOf(properties.get(PRIVATE_TOKEN)).equals("null")) {
            log.warn("The configuration file specifies a private token. It is not safe. Use TMS_PRIVATE_TOKEN environment variable");
        }
        properties.putAll(AppProperties.loadPropertiesFromEnv());
        properties.putAll(AppProperties.loadPropertiesFromCli());
        return properties;
    }

    private static void loadPropertiesFrom(ClassLoader classLoader, Properties properties, String fileName) {
        try (InputStream stream = classLoader.getResourceAsStream(fileName);){
            if (stream != null) {
                properties.load(stream);
                return;
            }
        }
        catch (IOException e) {
            log.error("Exception while read properties: {}", (Object)e.getMessage());
        }
        throw new RuntimeException(String.format("Config file '%s' not found", fileName));
    }

    private static Map<String, String> loadPropertiesFromEnv() {
        String adapterMode;
        String testRunName;
        String testRunId;
        String config;
        String project;
        String token;
        HashMap<String, String> map = new HashMap<String, String>();
        String url = System.getenv(String.format("%s_URL", ENV_PREFIX));
        if (url != null) {
            map.put(URL, url);
        }
        if ((token = System.getenv(String.format("%s_PRIVATE_TOKEN", ENV_PREFIX))) != null) {
            map.put(PRIVATE_TOKEN, token);
        }
        if ((project = System.getenv(String.format("%s_PROJECT_ID", ENV_PREFIX))) != null) {
            map.put(PROJECT_ID, project);
        }
        if ((config = System.getenv(String.format("%s_CONFIGURATION_ID", ENV_PREFIX))) != null) {
            map.put(CONFIGURATION_ID, config);
        }
        if ((testRunId = System.getenv(String.format("%s_TEST_RUN_ID", ENV_PREFIX))) != null) {
            map.put(TEST_RUN_ID, testRunId);
        }
        if ((testRunName = System.getenv(String.format("%s_TEST_RUN_NAME", ENV_PREFIX))) != null) {
            map.put(TEST_RUN_NAME, testRunName);
        }
        if ((adapterMode = System.getenv(String.format("%s_ADAPTER_MODE", ENV_PREFIX))) != null) {
            map.put(ADAPTER_MODE, adapterMode);
        }
        return map;
    }

    private static Map<String, String> loadPropertiesFromCli() {
        String adapterMode;
        String testRunName;
        String testRunId;
        String config;
        String project;
        String token;
        HashMap<String, String> map = new HashMap<String, String>();
        Properties systemProperties = System.getProperties();
        String url = systemProperties.getProperty(String.format("%sUrl", ENV_PREFIX.toLowerCase()));
        if (url != null) {
            map.put(URL, url);
        }
        if ((token = systemProperties.getProperty(String.format("%sPrivateToken", ENV_PREFIX.toLowerCase()))) != null) {
            map.put(PRIVATE_TOKEN, token);
        }
        if ((project = systemProperties.getProperty(String.format("%sProjectId", ENV_PREFIX.toLowerCase()))) != null) {
            map.put(PROJECT_ID, project);
        }
        if ((config = systemProperties.getProperty(String.format("%sConfigurationId", ENV_PREFIX.toLowerCase()))) != null) {
            map.put(CONFIGURATION_ID, config);
        }
        if ((testRunId = systemProperties.getProperty(String.format("%sTestRunId", ENV_PREFIX.toLowerCase()))) != null) {
            map.put(TEST_RUN_ID, testRunId);
        }
        if ((testRunName = systemProperties.getProperty(String.format("%sTestRunName", ENV_PREFIX.toLowerCase()))) != null) {
            map.put(TEST_RUN_NAME, testRunName);
        }
        if ((adapterMode = systemProperties.getProperty(String.format("%sAdapterMode", ENV_PREFIX.toLowerCase()))) != null) {
            map.put(ADAPTER_MODE, adapterMode);
        }
        return map;
    }

    private static String getConfigFileName() {
        Properties systemProperties = System.getProperties();
        String fileNameFromCli = systemProperties.getProperty(String.format("%sConfigFile", ENV_PREFIX.toLowerCase()));
        if (fileNameFromCli != null) {
            return fileNameFromCli;
        }
        String fileNameFromEnv = System.getenv(String.format("%s%s", ENV_PREFIX, CONFIG_FILE.toUpperCase(Locale.getDefault())));
        if (fileNameFromEnv != null) {
            return fileNameFromEnv;
        }
        return PROPERTIES_FILE;
    }
}

