/*
 * Decompiled with CFR 0.152.
 */
package ru.testit.services;

import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import ru.testit.annotations.Description;
import ru.testit.annotations.DisplayName;
import ru.testit.annotations.ExternalId;
import ru.testit.annotations.Labels;
import ru.testit.annotations.Link;
import ru.testit.annotations.Links;
import ru.testit.annotations.Title;
import ru.testit.annotations.WorkItemId;
import ru.testit.annotations.WorkItemIds;
import ru.testit.models.Label;
import ru.testit.models.LinkItem;

public class Utils {
    public static String extractExternalID(Method atomicTest, Map<String, String> parameters) {
        ExternalId annotation = atomicTest.getAnnotation(ExternalId.class);
        return annotation != null ? Utils.setParameters(annotation.value(), parameters) : Utils.getHash(atomicTest.getDeclaringClass().getName() + atomicTest.getName());
    }

    public static String extractDisplayName(Method atomicTest, Map<String, String> parameters) {
        DisplayName annotation = atomicTest.getAnnotation(DisplayName.class);
        return annotation != null ? Utils.setParameters(annotation.value(), parameters) : atomicTest.getName();
    }

    public static List<String> extractWorkItemId(Method atomicTest, Map<String, String> parameters) {
        ArrayList<String> workItemIds = new ArrayList<String>();
        WorkItemId workItem = atomicTest.getAnnotation(WorkItemId.class);
        if (workItem != null) {
            workItemIds.add(Utils.setParameters(workItem.value(), parameters));
            return workItemIds;
        }
        WorkItemIds workItems = atomicTest.getAnnotation(WorkItemIds.class);
        if (workItems != null) {
            for (String workItemId : workItems.value()) {
                workItemIds.add(Utils.setParameters(workItemId, parameters));
            }
        }
        return workItemIds;
    }

    public static List<LinkItem> extractLinks(Method atomicTest, Map<String, String> parameters) {
        LinkedList<LinkItem> links = new LinkedList<LinkItem>();
        Links linksAnnotation = atomicTest.getAnnotation(Links.class);
        if (linksAnnotation != null) {
            for (Link link : linksAnnotation.links()) {
                links.add(Utils.makeLink(link, parameters));
            }
        } else {
            Link linkAnnotation = atomicTest.getAnnotation(Link.class);
            if (linkAnnotation != null) {
                links.add(Utils.makeLink(linkAnnotation, parameters));
            }
        }
        return links;
    }

    public static List<Label> extractLabels(Method atomicTest, Map<String, String> parameters) {
        LinkedList<Label> labels = new LinkedList<Label>();
        Labels annotation = atomicTest.getAnnotation(Labels.class);
        if (annotation != null) {
            for (String s : annotation.value()) {
                Label label = new Label().setName(Utils.setParameters(s, parameters));
                labels.add(label);
            }
        }
        return labels;
    }

    public static String extractDescription(Method atomicTest, Map<String, String> parameters) {
        Description annotation = atomicTest.getAnnotation(Description.class);
        return annotation != null ? Utils.setParameters(annotation.value(), parameters) : "";
    }

    public static String extractTitle(Method atomicTest, Map<String, String> parameters) {
        Title annotation = atomicTest.getAnnotation(Title.class);
        String title = annotation == null ? atomicTest.getName() : annotation.value();
        return Utils.setParameters(title, parameters);
    }

    public static String toIndentedString(Object o) {
        return o == null ? "null" : o.toString().replace("\n", "\n    ");
    }

    private static LinkItem makeLink(Link linkAnnotation, Map<String, String> parameters) {
        return new LinkItem().setTitle(Utils.setParameters(linkAnnotation.title(), parameters)).setDescription(Utils.setParameters(linkAnnotation.description(), parameters)).setUrl(Utils.setParameters(linkAnnotation.url(), parameters)).setType(linkAnnotation.type());
    }

    public static String urlTrim(String url) {
        if (url.endsWith("/")) {
            return Utils.removeTrailing(url);
        }
        return url;
    }

    private static String removeTrailing(String s) {
        StringBuilder sb = new StringBuilder(s);
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private static String setParameters(String value, Map<String, String> parameters) {
        if (!Objects.isNull(parameters) && !Objects.isNull(value)) {
            Pattern pattern = Pattern.compile("\\{\\s*(\\w+)}");
            Matcher matcher = pattern.matcher(value);
            while (matcher.find()) {
                String parameterName = matcher.group(1);
                String parameterValue = parameters.get(parameterName);
                if (Objects.isNull(parameterValue)) continue;
                value = value.replace(String.format("{%s}", parameterName), parameters.get(parameterName));
            }
        }
        return value;
    }

    public static String getHash(String value) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(value.getBytes(StandardCharsets.UTF_8));
            byte[] digest = md.digest();
            return DatatypeConverter.printHexBinary((byte[])digest);
        }
        catch (NoSuchAlgorithmException e) {
            return value;
        }
    }
}

