/*
 * Decompiled with CFR 0.152.
 */
package ru.testit.clients;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.testit.client.api.AttachmentsApi;
import ru.testit.client.api.AutoTestsApi;
import ru.testit.client.api.TestRunsApi;
import ru.testit.client.invoker.ApiException;
import ru.testit.client.model.AttachmentModel;
import ru.testit.client.model.AutoTestModel;
import ru.testit.client.model.AutoTestPostModel;
import ru.testit.client.model.AutoTestPutModel;
import ru.testit.client.model.AutoTestResultsForTestRunModel;
import ru.testit.client.model.AutotestFilterModel;
import ru.testit.client.model.AutotestsSelectModel;
import ru.testit.client.model.SearchAutoTestsQueryIncludesModel;
import ru.testit.client.model.TestRunV2GetModel;
import ru.testit.client.model.TestRunV2PostShortModel;
import ru.testit.client.model.WorkItemIdModel;
import ru.testit.clients.ApiClient;
import ru.testit.clients.ClientConfiguration;

public class TmsApiClient
implements ApiClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmsApiClient.class);
    private static final String AUTH_PREFIX = "PrivateToken";
    private static final boolean INCLUDE_STEPS = true;
    private static final boolean INCLUDE_LABELS = true;
    private final TestRunsApi testRunsApi;
    private final AutoTestsApi autoTestsApi;
    private final AttachmentsApi attachmentsApi;
    private final ClientConfiguration clientConfiguration;

    public TmsApiClient(ClientConfiguration config) {
        ru.testit.client.invoker.ApiClient apiClient = new ru.testit.client.invoker.ApiClient();
        apiClient.setBasePath(config.getUrl());
        apiClient.setApiKeyPrefix(AUTH_PREFIX);
        apiClient.setApiKey(config.getPrivateToken());
        apiClient.setVerifyingSsl(config.getCertValidation().booleanValue());
        this.clientConfiguration = config;
        this.testRunsApi = new TestRunsApi(apiClient);
        this.autoTestsApi = new AutoTestsApi(apiClient);
        this.attachmentsApi = new AttachmentsApi(apiClient);
    }

    @Override
    public TestRunV2GetModel createTestRun() throws ApiException {
        TestRunV2PostShortModel model = new TestRunV2PostShortModel();
        model.setProjectId(UUID.fromString(this.clientConfiguration.getProjectId()));
        if (!Objects.equals(this.clientConfiguration.getTestRunName(), "null")) {
            model.setName(this.clientConfiguration.getTestRunName());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Create new test run: {}", (Object)model);
        }
        TestRunV2GetModel response = this.testRunsApi.createEmpty(model);
        this.testRunsApi.startTestRun(response.getId());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("The test run created: {}", (Object)response);
        }
        return response;
    }

    @Override
    public TestRunV2GetModel getTestRun(String uuid) throws ApiException {
        return this.testRunsApi.getTestRunById(UUID.fromString(uuid));
    }

    @Override
    public void completeTestRun(String uuid) throws ApiException {
        this.testRunsApi.completeTestRun(UUID.fromString(uuid));
    }

    @Override
    public void updateAutoTest(AutoTestPutModel model) throws ApiException {
        this.autoTestsApi.updateAutoTest(model);
    }

    @Override
    public String createAutoTest(AutoTestPostModel model) throws ApiException {
        return Objects.requireNonNull(this.autoTestsApi.createAutoTest(model).getId()).toString();
    }

    @Override
    public AutoTestModel getAutoTestByExternalId(String externalId) throws ApiException {
        AutotestFilterModel filter = new AutotestFilterModel();
        HashSet<UUID> projectIds = new HashSet<UUID>();
        projectIds.add(UUID.fromString(this.clientConfiguration.getProjectId()));
        filter.setProjectIds(projectIds);
        HashSet<String> externalIds = new HashSet<String>();
        externalIds.add(externalId);
        filter.externalIds(externalIds);
        SearchAutoTestsQueryIncludesModel includes = new SearchAutoTestsQueryIncludesModel();
        includes.setIncludeLabels(Boolean.valueOf(true));
        includes.setIncludeSteps(Boolean.valueOf(true));
        AutotestsSelectModel model = new AutotestsSelectModel();
        model.setFilter(filter);
        model.setIncludes(includes);
        List tests = this.autoTestsApi.apiV2AutoTestsSearchPost(null, null, null, null, null, model);
        if ((long)tests.size() == 0L) {
            return null;
        }
        return (AutoTestModel)tests.get(0);
    }

    @Override
    public void linkAutoTestToWorkItem(String id, String workItemId) throws ApiException {
        this.autoTestsApi.linkAutoTestToWorkItem(id, new WorkItemIdModel().id(workItemId));
    }

    @Override
    public void sendTestResults(String testRunUuid, List<AutoTestResultsForTestRunModel> models) throws ApiException {
        this.testRunsApi.setAutoTestResultsForTestRun(UUID.fromString(testRunUuid), models);
    }

    @Override
    public String addAttachment(String path) throws ApiException {
        File file = new File(path);
        AttachmentModel model = this.attachmentsApi.apiV2AttachmentsPost(file);
        return model.getId().toString();
    }

    @Override
    public List<String> getTestFromTestRun(String testRunUuid, String configurationId) throws ApiException {
        TestRunV2GetModel model = this.testRunsApi.getTestRunById(UUID.fromString(testRunUuid));
        UUID configUUID = UUID.fromString(configurationId);
        if (Objects.requireNonNull(model.getTestResults()).size() == 0) {
            return new ArrayList<String>();
        }
        return model.getTestResults().stream().filter(result -> Objects.equals(result.getConfigurationId(), configUUID)).map(result -> Objects.requireNonNull(result.getAutoTest()).getExternalId()).collect(Collectors.toList());
    }
}

