/*
 * Decompiled with CFR 0.152.
 */
package ru.testit.writers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.testit.client.invoker.ApiException;
import ru.testit.client.model.AttachmentPutModelAutoTestStepResultsModel;
import ru.testit.client.model.AutoTestModel;
import ru.testit.client.model.AutoTestPostModel;
import ru.testit.client.model.AutoTestPutModel;
import ru.testit.client.model.AutoTestResultsForTestRunModel;
import ru.testit.client.model.AutoTestStepModel;
import ru.testit.client.model.TestResultModel;
import ru.testit.client.model.TestResultUpdateModel;
import ru.testit.clients.ApiClient;
import ru.testit.clients.ClientConfiguration;
import ru.testit.models.ClassContainer;
import ru.testit.models.ItemStatus;
import ru.testit.models.MainContainer;
import ru.testit.models.TestResult;
import ru.testit.services.ResultStorage;
import ru.testit.writers.Converter;
import ru.testit.writers.Writer;

public class HttpWriter
implements Writer {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpWriter.class);
    private final Map<String, UUID> testResults;
    private final ApiClient apiClient;
    private final ResultStorage storage;
    private final ClientConfiguration config;

    public HttpWriter(ClientConfiguration config, ApiClient client, ResultStorage storage) {
        this.config = config;
        this.apiClient = client;
        this.storage = storage;
        this.testResults = new HashMap<String, UUID>();
    }

    @Override
    public void writeTest(TestResult testResult) {
        try {
            String autoTestId;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Write auto test {}", (Object)testResult.getExternalId());
            }
            AutoTestModel test = this.apiClient.getAutoTestByExternalId(testResult.getExternalId());
            List<String> workItemId = testResult.getWorkItemId();
            if (test != null) {
                AutoTestPutModel autoTestPutModel;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Auto test is exist. Update auto test {}", (Object)testResult.getExternalId());
                }
                if (testResult.getItemStatus() == ItemStatus.FAILED) {
                    autoTestPutModel = Converter.autoTestModelToAutoTestPutModel(test);
                    autoTestPutModel.links(Converter.convertPutLinks(testResult.getLinkItems()));
                } else {
                    autoTestPutModel = Converter.testResultToAutoTestPutModel(testResult);
                    autoTestPutModel.setProjectId(UUID.fromString(this.config.getProjectId()));
                }
                autoTestPutModel.setIsFlaky(test.getIsFlaky());
                this.apiClient.updateAutoTest(autoTestPutModel);
                autoTestId = test.getId().toString();
            } else {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Create new auto test {}", (Object)testResult.getExternalId());
                }
                AutoTestPostModel model = Converter.testResultToAutoTestPostModel(testResult);
                model.setProjectId(UUID.fromString(this.config.getProjectId()));
                autoTestId = this.apiClient.createAutoTest(model);
            }
            AutoTestResultsForTestRunModel autoTestResultsForTestRunModel = Converter.testResultToAutoTestResultsForTestRunModel(testResult);
            autoTestResultsForTestRunModel.setConfigurationId(UUID.fromString(this.config.getConfigurationId()));
            ArrayList<AutoTestResultsForTestRunModel> results = new ArrayList<AutoTestResultsForTestRunModel>();
            results.add(autoTestResultsForTestRunModel);
            List<UUID> ids = this.apiClient.sendTestResults(this.config.getTestRunId(), results);
            this.testResults.put(testResult.getUuid(), ids.get(0));
            if (workItemId.size() == 0 || test != null && testResult.getItemStatus() == ItemStatus.FAILED) {
                return;
            }
            workItemId.forEach(i -> {
                try {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Link work item {} to auto test {}", i, (Object)testResult.getExternalId());
                    }
                    this.apiClient.linkAutoTestToWorkItem(autoTestId, (String)i);
                }
                catch (ApiException e) {
                    LOGGER.error("Can not link the autotest: ".concat(e.getMessage()));
                }
            });
        }
        catch (ApiException e) {
            LOGGER.error("Can not write the autotest: ".concat(e.getMessage()));
        }
    }

    @Override
    public void writeClass(ClassContainer container) {
        for (String testUuid : container.getChildren()) {
            this.storage.getTestResult(testUuid).ifPresent(test -> {
                try {
                    AutoTestModel autoTestModel = this.apiClient.getAutoTestByExternalId(test.getExternalId());
                    if (autoTestModel == null) {
                        return;
                    }
                    AutoTestPutModel autoTestPutModel = Converter.autoTestModelToAutoTestPutModel(autoTestModel);
                    List<AutoTestStepModel> beforeClass = Converter.convertFixture(container.getBeforeClassMethods(), null);
                    List<AutoTestStepModel> beforeEach = Converter.convertFixture(container.getBeforeEachTest(), testUuid);
                    beforeClass.addAll(beforeEach);
                    List<AutoTestStepModel> afterClass = Converter.convertFixture(container.getAfterClassMethods(), null);
                    List<AutoTestStepModel> afterEach = Converter.convertFixture(container.getAfterEachTest(), testUuid);
                    afterClass.addAll(afterEach);
                    autoTestPutModel.setSetup(beforeClass);
                    autoTestPutModel.setTeardown(afterClass);
                    autoTestPutModel.setIsFlaky(autoTestModel.getIsFlaky());
                    this.apiClient.updateAutoTest(autoTestPutModel);
                }
                catch (ApiException e) {
                    LOGGER.error("Can not write the class: ".concat(e.getMessage()));
                }
            });
        }
    }

    @Override
    public void writeTests(MainContainer container) {
        List<AutoTestStepModel> beforeAll = Converter.convertFixture(container.getBeforeMethods(), null);
        List<AutoTestStepModel> afterAll = Converter.convertFixture(container.getAfterMethods(), null);
        List<AttachmentPutModelAutoTestStepResultsModel> beforeResultAll = Converter.convertResultFixture(container.getBeforeMethods(), null);
        List<AttachmentPutModelAutoTestStepResultsModel> afterResultAll = Converter.convertResultFixture(container.getAfterMethods(), null);
        for (String classUuid : container.getChildren()) {
            this.storage.getClassContainer(classUuid).ifPresent(cl -> {
                List<AttachmentPutModelAutoTestStepResultsModel> beforeResultClass = Converter.convertResultFixture(cl.getBeforeClassMethods(), null);
                List<AttachmentPutModelAutoTestStepResultsModel> afterResultClass = Converter.convertResultFixture(cl.getAfterClassMethods(), null);
                for (String testUuid : cl.getChildren()) {
                    this.storage.getTestResult(testUuid).ifPresent(test -> {
                        try {
                            AutoTestModel autoTestModel = this.apiClient.getAutoTestByExternalId(test.getExternalId());
                            if (autoTestModel == null) {
                                return;
                            }
                            AutoTestPutModel autoTestPutModel = Converter.autoTestModelToAutoTestPutModel(autoTestModel);
                            ArrayList beforeFinish = new ArrayList(beforeAll);
                            beforeFinish.addAll(autoTestPutModel.getSetup());
                            autoTestPutModel.setSetup(beforeFinish);
                            List<AutoTestStepModel> afterClass = Converter.convertFixture(cl.getAfterClassMethods(), null);
                            List afterFinish = autoTestPutModel.getTeardown();
                            afterFinish.addAll(afterClass);
                            afterFinish.addAll(afterAll);
                            autoTestPutModel.setTeardown(afterFinish);
                            autoTestPutModel.setIsFlaky(autoTestModel.getIsFlaky());
                            this.apiClient.updateAutoTest(autoTestPutModel);
                            AutoTestResultsForTestRunModel autoTestResultsForTestRunModel = Converter.testResultToAutoTestResultsForTestRunModel(test);
                            List<AttachmentPutModelAutoTestStepResultsModel> beforeResultEach = Converter.convertResultFixture(cl.getBeforeEachTest(), testUuid);
                            ArrayList<AttachmentPutModelAutoTestStepResultsModel> beforeResultFinish = new ArrayList<AttachmentPutModelAutoTestStepResultsModel>();
                            beforeResultFinish.addAll(beforeResultAll);
                            beforeResultFinish.addAll(beforeResultClass);
                            beforeResultFinish.addAll(beforeResultEach);
                            List<AttachmentPutModelAutoTestStepResultsModel> afterResultEach = Converter.convertResultFixture(cl.getAfterEachTest(), testUuid);
                            ArrayList<AttachmentPutModelAutoTestStepResultsModel> afterResultFinish = new ArrayList<AttachmentPutModelAutoTestStepResultsModel>();
                            afterResultFinish.addAll(afterResultEach);
                            afterResultFinish.addAll(afterResultClass);
                            afterResultFinish.addAll(afterResultAll);
                            autoTestResultsForTestRunModel.setSetupResults(beforeResultFinish);
                            autoTestResultsForTestRunModel.setTeardownResults(afterResultFinish);
                            UUID testResultId = this.testResults.get(test.getUuid());
                            TestResultModel resultModel = this.apiClient.getTestResult(testResultId);
                            TestResultUpdateModel model = Converter.testResultToTestResultUpdateModel(resultModel);
                            model.setSetupResults(beforeResultFinish);
                            model.setTeardownResults(afterResultFinish);
                            this.apiClient.updateTestResult(testResultId, model);
                        }
                        catch (ApiException e) {
                            LOGGER.error("Can not update the autotest: ".concat(e.getMessage()));
                        }
                    });
                }
            });
        }
    }

    @Override
    public String writeAttachment(String path) {
        try {
            return this.apiClient.addAttachment(path);
        }
        catch (ApiException e) {
            LOGGER.error("Can not write attachment: ".concat(e.getMessage()));
            return "";
        }
    }

    void addUuid(String key, UUID uuid) {
        this.testResults.put(key, uuid);
    }
}

