/*
 * Decompiled with CFR 0.152.
 */
package ru.testit.properties;

import java.io.Serializable;
import java.util.Properties;
import ru.testit.properties.AdapterMode;
import ru.testit.services.Utils;

public class AdapterConfig
implements Serializable {
    private final AdapterMode mode;
    private final boolean automaticCreationTestCases;

    public AdapterConfig(Properties properties) {
        String modeValue = String.valueOf(properties.get("adapterMode"));
        if (modeValue.equals("null")) {
            modeValue = "0";
        }
        this.mode = AdapterMode.valueOf(Integer.parseInt(modeValue));
        String automaticCreationTestCasesValue = String.valueOf(properties.get("automaticCreationTestCases"));
        if (automaticCreationTestCasesValue.equals("null")) {
            automaticCreationTestCasesValue = "false";
        }
        this.automaticCreationTestCases = Boolean.parseBoolean(automaticCreationTestCasesValue);
    }

    public AdapterMode getMode() {
        return this.mode;
    }

    public boolean shouldAutomaticCreationTestCases() {
        return this.automaticCreationTestCases;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdapterConfig {\n");
        sb.append("    mode: ").append(Utils.toIndentedString((Object)this.mode)).append("\n");
        sb.append("    automaticCreationTestCases: ").append(Utils.toIndentedString(this.automaticCreationTestCases)).append("\n");
        sb.append("}");
        return sb.toString();
    }
}

