/*
 * Decompiled with CFR 0.152.
 */
package ru.testit.clients;

import java.io.Serializable;
import java.util.Objects;
import java.util.Properties;
import ru.testit.services.Utils;

public class ClientConfiguration
implements Serializable {
    private String privateToken;
    private String projectId;
    private String url;
    private String configurationId;
    private String testRunId;
    private String testRunName;
    private Boolean certValidation;
    private boolean automaticUpdationLinksToTestCases;
    private boolean tmsImportRealtime;

    public ClientConfiguration(Properties properties) {
        this.privateToken = String.valueOf(properties.get("privateToken"));
        this.projectId = String.valueOf(properties.get("projectId"));
        this.url = Utils.urlTrim(String.valueOf(properties.get("url")));
        this.configurationId = String.valueOf(properties.get("configurationId"));
        this.testRunId = String.valueOf(properties.get("testRunId"));
        this.testRunName = String.valueOf(properties.get("testRunName"));
        String validationCert = String.valueOf(properties.get("certValidation"));
        if (validationCert.equals("null")) {
            validationCert = "true";
        }
        try {
            String automaticUpdationLinksToTestCasesValue = String.valueOf(properties.get("automaticUpdationLinksToTestCases"));
            this.automaticUpdationLinksToTestCases = Objects.equals(automaticUpdationLinksToTestCasesValue, "true");
        }
        catch (NullPointerException ignored) {
            this.automaticUpdationLinksToTestCases = false;
        }
        try {
            String importRealtime = String.valueOf(properties.get("importRealtime"));
            this.tmsImportRealtime = Objects.equals(importRealtime, "true");
        }
        catch (NullPointerException ignored) {
            this.tmsImportRealtime = true;
        }
        this.certValidation = Boolean.parseBoolean(validationCert);
    }

    public String getPrivateToken() {
        return this.privateToken;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getUrl() {
        return this.url;
    }

    public String getConfigurationId() {
        return this.configurationId;
    }

    public String getTestRunId() {
        return this.testRunId;
    }

    public void setTestRunId(String id) {
        this.testRunId = id;
    }

    public String getTestRunName() {
        return this.testRunName;
    }

    public Boolean getCertValidation() {
        return this.certValidation;
    }

    public boolean shouldAutomaticUpdationLinksToTestCases() {
        return this.automaticUpdationLinksToTestCases;
    }

    public boolean shouldImportRealtime() {
        return this.tmsImportRealtime;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ClientConfiguration {\n");
        sb.append("    url: ").append(Utils.toIndentedString(this.url)).append("\n");
        sb.append("    privateToken: **********").append("\n");
        sb.append("    projectId: ").append(Utils.toIndentedString(this.projectId)).append("\n");
        sb.append("    configurationId: ").append(Utils.toIndentedString(this.configurationId)).append("\n");
        sb.append("    testRunId: ").append(Utils.toIndentedString(this.testRunId)).append("\n");
        sb.append("    testRunName: ").append(Utils.toIndentedString(this.testRunName)).append("\n");
        sb.append("    certValidation: ").append(Utils.toIndentedString(this.certValidation)).append("\n");
        sb.append("    automaticUpdationLinksToTestCases: ").append(Utils.toIndentedString(this.automaticUpdationLinksToTestCases)).append("\n");
        sb.append("    tmsImportRealtime: ").append(Utils.toIndentedString(this.tmsImportRealtime)).append("\n");
        sb.append("}");
        return sb.toString();
    }
}

