/*
 * Decompiled with CFR 0.152.
 */
package ru.testit.models;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import ru.testit.models.ItemStage;
import ru.testit.models.ItemStatus;
import ru.testit.models.LinkItem;
import ru.testit.models.ResultWithAttachments;
import ru.testit.models.ResultWithSteps;
import ru.testit.services.HtmlEscapeUtils;
import ru.testit.services.Utils;

public class StepResult
implements ResultWithSteps,
ResultWithAttachments,
Serializable {
    private String name;
    private ItemStatus itemStatus;
    private ItemStage itemStage;
    private String description;
    private List<StepResult> steps = new ArrayList<StepResult>();
    private List<LinkItem> linkItems = new ArrayList<LinkItem>();
    private List<String> attachments = new ArrayList<String>();
    private Throwable throwable;
    private Long start;
    private Long stop;
    private Map<String, String> parameters;

    public String getName() {
        return this.name;
    }

    public StepResult setName(String name) {
        this.name = HtmlEscapeUtils.escapeHtmlTags(name);
        return this;
    }

    public ItemStatus getItemStatus() {
        return this.itemStatus;
    }

    public StepResult setItemStatus(ItemStatus itemStatus) {
        this.itemStatus = itemStatus;
        return this;
    }

    public ItemStage getItemStage() {
        return this.itemStage;
    }

    public StepResult setItemStage(ItemStage itemStage) {
        this.itemStage = itemStage;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public StepResult setDescription(String description) {
        this.description = HtmlEscapeUtils.escapeHtmlTags(description);
        return this;
    }

    @Override
    public List<String> getAttachments() {
        return this.attachments;
    }

    public StepResult setAttachments(List<String> attachments) {
        this.attachments = attachments;
        return this;
    }

    @Override
    public List<StepResult> getSteps() {
        return this.steps;
    }

    public StepResult setSteps(List<StepResult> steps) {
        this.steps = steps;
        return this;
    }

    public List<LinkItem> getLinkItems() {
        return this.linkItems;
    }

    public StepResult setLinkItems(List<LinkItem> linkItems) {
        this.linkItems = linkItems;
        return this;
    }

    public Long getStart() {
        return this.start;
    }

    public StepResult setStart(Long start) {
        this.start = start;
        return this;
    }

    public Long getStop() {
        return this.stop;
    }

    public StepResult setStop(Long stop) {
        this.stop = stop;
        return this;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public StepResult setThrowable(Throwable throwable) {
        this.throwable = HtmlEscapeUtils.escapeHtmlInObject(throwable);
        return this;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public StepResult setParameters(Map<String, String> parameters) {
        this.parameters = HtmlEscapeUtils.escapeHtmlInObject(parameters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StepResult {\n");
        sb.append("    name: ").append(Utils.toIndentedString(this.name)).append("\n");
        sb.append("    itemStatus: ").append(Utils.toIndentedString((Object)this.itemStatus)).append("\n");
        sb.append("    itemStage: ").append(Utils.toIndentedString((Object)this.itemStage)).append("\n");
        sb.append("    description: ").append(Utils.toIndentedString(this.description)).append("\n");
        sb.append("    steps: ").append(Utils.toIndentedString(this.steps)).append("\n");
        sb.append("    linkItems: ").append(Utils.toIndentedString(this.linkItems)).append("\n");
        sb.append("    attachments: ").append(Utils.toIndentedString(this.attachments)).append("\n");
        sb.append("    throwable: ").append(Utils.toIndentedString(this.throwable)).append("\n");
        sb.append("    start: ").append(Utils.toIndentedString(this.start)).append("\n");
        sb.append("    stop: ").append(Utils.toIndentedString(this.stop)).append("\n");
        sb.append("    parameters: ").append(Utils.toIndentedString(this.parameters)).append("\n");
        sb.append("}");
        return sb.toString();
    }
}

