/*
 * Decompiled with CFR 0.152.
 */
package ru.testit.services;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.testit.models.LinkItem;
import ru.testit.models.LinkType;
import ru.testit.properties.AppProperties;
import ru.testit.services.AdapterManager;
import ru.testit.services.ConfigManager;
import ru.testit.services.ResultStorage;

public final class Adapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(Adapter.class);
    private static AdapterManager adapterManager;
    private static ResultStorage storage;

    private Adapter() {
    }

    public static AdapterManager getAdapterManager() {
        if (Objects.isNull(adapterManager)) {
            Properties appProperties = AppProperties.loadProperties();
            ConfigManager manager = new ConfigManager(appProperties);
            adapterManager = new AdapterManager(manager.getClientConfiguration(), manager.getAdapterConfig());
        }
        return adapterManager;
    }

    public static ResultStorage getResultStorage() {
        if (Objects.isNull(storage)) {
            storage = new ResultStorage();
        }
        return storage;
    }

    public static void addLinks(String url, String title, String description, LinkType type) {
        LinkItem link = new LinkItem().setTitle(title).setDescription(description).setType(type).setUrl(url);
        ArrayList<LinkItem> links = new ArrayList<LinkItem>();
        links.add(link);
        Adapter.addLinks(links);
    }

    public static void addLinks(List<LinkItem> links) {
        Adapter.getAdapterManager().updateTestCase(testResult -> testResult.getResultLinks().addAll(links));
    }

    public static void addAttachments(List<String> attachments) {
        Adapter.getAdapterManager().addAttachments(attachments);
    }

    public static void addAttachments(String attachment) {
        ArrayList<String> attachments = new ArrayList<String>();
        attachments.add(attachment);
        Adapter.addAttachments(attachments);
    }

    public static void addAttachments(String content, String fileName) {
        if (fileName == null) {
            fileName = UUID.randomUUID() + "-attachment.txt";
        }
        Path path = Paths.get(fileName, new String[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(path, Charset.defaultCharset(), new OpenOption[0]);){
            writer.write(content);
        }
        catch (IOException e) {
            LOGGER.error(String.format("Can not write file '%s':", fileName), (Throwable)e);
        }
        Adapter.addAttachments(fileName);
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException e) {
            LOGGER.error(String.format("Can not delete file '%s':", fileName), (Throwable)e);
        }
    }

    public static void addAttachments(String fileName, InputStream inputStream) {
        if (fileName == null) {
            LOGGER.error("Attachment name is empty");
            return;
        }
        Path path = Paths.get(fileName, new String[0]);
        try {
            Files.copy(inputStream, path, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            LOGGER.error(String.format("Can not write file '%s':", fileName), (Throwable)e);
        }
        Adapter.addAttachments(fileName);
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException e) {
            LOGGER.error(String.format("Can not delete file '%s':", fileName), (Throwable)e);
        }
    }

    public static void addMessage(String message) {
        Adapter.getAdapterManager().updateTestCase(testResult -> testResult.setMessage(message));
    }
}

