/*
 * Decompiled with CFR 0.152.
 */
package ru.testit.services;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.testit.client.invoker.ApiException;
import ru.testit.client.model.TestRunV2ApiResult;
import ru.testit.client.model.TestStatusApiResult;
import ru.testit.client.model.TestStatusApiType;
import ru.testit.clients.ClientConfiguration;
import ru.testit.clients.Converter;
import ru.testit.clients.ITmsApiClient;
import ru.testit.clients.TmsApiClient;
import ru.testit.listener.AdapterListener;
import ru.testit.listener.ListenerManager;
import ru.testit.listener.ServiceLoaderListener;
import ru.testit.models.ClassContainer;
import ru.testit.models.FixtureResult;
import ru.testit.models.ItemStage;
import ru.testit.models.MainContainer;
import ru.testit.models.ResultWithAttachments;
import ru.testit.models.ResultWithSteps;
import ru.testit.models.StepResult;
import ru.testit.models.TestResult;
import ru.testit.properties.AdapterConfig;
import ru.testit.properties.AdapterMode;
import ru.testit.services.Adapter;
import ru.testit.services.ResultStorage;
import ru.testit.services.ThreadContext;
import ru.testit.writers.HttpWriter;
import ru.testit.writers.Writer;

public class AdapterManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdapterManager.class);
    private final ThreadContext threadContext;
    private final ResultStorage storage;
    private final Writer writer;
    private final ITmsApiClient client;
    private final ClientConfiguration clientConfiguration;
    private final AdapterConfig adapterConfig;
    private final ListenerManager listenerManager;

    public AdapterManager(ClientConfiguration clientConfiguration, AdapterConfig adapterConfig) {
        this(clientConfiguration, adapterConfig, AdapterManager.getDefaultListenerManager());
    }

    public AdapterManager(ClientConfiguration clientConfiguration, AdapterConfig adapterConfig, ListenerManager listenerManager) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Client configurations: {}", (Object)clientConfiguration);
            LOGGER.debug("Adapter configurations: {}", (Object)adapterConfig);
        }
        this.clientConfiguration = clientConfiguration;
        this.adapterConfig = adapterConfig;
        this.storage = Adapter.getResultStorage();
        this.threadContext = new ThreadContext();
        this.client = new TmsApiClient(this.clientConfiguration);
        this.writer = new HttpWriter(this.clientConfiguration, this.client, this.storage);
        this.listenerManager = listenerManager;
    }

    public AdapterManager(ClientConfiguration clientConfiguration, AdapterConfig adapterConfig, ThreadContext threadContext, ResultStorage storage, Writer writer, ITmsApiClient client, ListenerManager listenerManager) {
        this.adapterConfig = adapterConfig;
        this.clientConfiguration = clientConfiguration;
        this.threadContext = threadContext;
        this.storage = storage;
        this.writer = writer;
        this.client = client;
        this.listenerManager = listenerManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTests() {
        if (!this.adapterConfig.shouldEnableTmsIntegration()) {
            return;
        }
        LOGGER.debug("Start launch");
        ClientConfiguration clientConfiguration = this.clientConfiguration;
        synchronized (clientConfiguration) {
            if (!Objects.equals(this.clientConfiguration.getTestRunId(), "null")) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Test run is exist.");
                }
                try {
                    this.updateTestRunName();
                }
                catch (ApiException e) {
                    LOGGER.error("Can not update the launch: ".concat(e.getMessage()));
                }
                return;
            }
            try {
                TestRunV2ApiResult response = this.client.createTestRun();
                this.clientConfiguration.setTestRunId(response.getId().toString());
            }
            catch (ApiException e) {
                LOGGER.error("Can not start the launch: ".concat(e.getMessage()));
            }
        }
    }

    private void updateTestRunName() throws ApiException {
        String testRunName = this.clientConfiguration.getTestRunName();
        if (testRunName.isEmpty()) {
            return;
        }
        TestRunV2ApiResult testRun = this.client.getTestRun(this.clientConfiguration.getTestRunId());
        if (testRun.getName().equals(testRunName)) {
            return;
        }
        testRun.setName(testRunName);
        this.client.updateTestRun(Converter.buildUpdateEmptyTestRunApiModel(testRun));
    }

    public void stopTests() {
        if (!this.adapterConfig.shouldEnableTmsIntegration()) {
            return;
        }
        LOGGER.debug("Stop launch");
        try {
            TestRunV2ApiResult testRun = this.client.getTestRun(this.clientConfiguration.getTestRunId());
            TestStatusApiResult status = testRun.getStatus();
            TestStatusApiType type = status.getType();
            if (type != TestStatusApiType.SUCCEEDED) {
                this.client.completeTestRun(this.clientConfiguration.getTestRunId());
            }
        }
        catch (ApiException e) {
            if (e.getResponseBody().contains("the StateName is already Completed")) {
                return;
            }
            LOGGER.error("Can not finish the launch: ".concat(e.getMessage()));
        }
    }

    public void startMainContainer(MainContainer container) {
        if (!this.adapterConfig.shouldEnableTmsIntegration()) {
            return;
        }
        container.setStart(System.currentTimeMillis());
        this.storage.put(container.getUuid(), container);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Start new main container {}", (Object)container);
        }
    }

    public void stopMainContainer(String uuid) {
        if (!this.adapterConfig.shouldEnableTmsIntegration()) {
            return;
        }
        Optional<MainContainer> found = this.storage.getTestsContainer(uuid);
        if (!found.isPresent()) {
            LOGGER.error("Could not stop main container: container with uuid {} not found", (Object)uuid);
            return;
        }
        MainContainer container = found.get();
        container.setStop(System.currentTimeMillis());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Stop main container {}", (Object)container);
        }
        this.writer.writeTests(container);
    }

    public void startClassContainer(String parentUuid, ClassContainer container) {
        if (!this.adapterConfig.shouldEnableTmsIntegration()) {
            return;
        }
        this.storage.getTestsContainer(parentUuid).ifPresent(parent -> {
            ResultStorage resultStorage = this.storage;
            synchronized (resultStorage) {
                parent.getChildren().add(container.getUuid());
            }
        });
        container.setStart(System.currentTimeMillis());
        this.storage.put(container.getUuid(), container);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Start new class container {} for parent {}", (Object)container, (Object)parentUuid);
        }
    }

    public void stopClassContainer(String uuid) {
        if (!this.adapterConfig.shouldEnableTmsIntegration()) {
            return;
        }
        Optional<ClassContainer> found = this.storage.getClassContainer(uuid);
        if (!found.isPresent()) {
            LOGGER.debug("Could not stop class container: container with uuid {} not found", (Object)uuid);
            return;
        }
        ClassContainer container = found.get();
        container.setStop(System.currentTimeMillis());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Stop class container {}", (Object)container);
        }
        this.writer.writeClass(container);
    }

    public void updateClassContainer(String uuid, Consumer<ClassContainer> update) {
        Optional<ClassContainer> found;
        if (!this.adapterConfig.shouldEnableTmsIntegration()) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Update class container {}", (Object)uuid);
        }
        if (!(found = this.storage.getClassContainer(uuid)).isPresent()) {
            LOGGER.debug("Could not update class container: container with uuid {} not found", (Object)uuid);
            return;
        }
        ClassContainer container = found.get();
        update.accept(container);
    }

    public void startTestCase(String uuid) {
        if (!this.adapterConfig.shouldEnableTmsIntegration()) {
            return;
        }
        this.threadContext.clear();
        Optional<TestResult> found = this.storage.getTestResult(uuid);
        if (!found.isPresent()) {
            LOGGER.error("Could not start test case: test case with uuid {} is not scheduled", (Object)uuid);
            return;
        }
        TestResult testResult = found.get();
        testResult.setItemStage(ItemStage.RUNNING).setStart(System.currentTimeMillis());
        this.threadContext.start(uuid);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Start test case {}", (Object)testResult);
        }
    }

    public void scheduleTestCase(TestResult result) {
        if (!this.adapterConfig.shouldEnableTmsIntegration()) {
            return;
        }
        result.setItemStage(ItemStage.SCHEDULED).setAutomaticCreationTestCases(this.adapterConfig.shouldAutomaticCreationTestCases());
        this.storage.put(result.getUuid(), result);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Schedule test case {}", (Object)result);
        }
    }

    public void updateTestCase(Consumer<TestResult> update) {
        if (!this.adapterConfig.shouldEnableTmsIntegration()) {
            return;
        }
        Optional<String> root = this.threadContext.getRoot();
        if (!root.isPresent()) {
            LOGGER.error("Could not update test case: no test case running");
            return;
        }
        String uuid = root.get();
        this.updateTestCase(uuid, update);
    }

    public void updateTestCase(String uuid, Consumer<TestResult> update) {
        Optional<TestResult> found;
        if (!this.adapterConfig.shouldEnableTmsIntegration()) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Update test case {}", (Object)uuid);
        }
        if (!(found = this.storage.getTestResult(uuid)).isPresent()) {
            LOGGER.error("Could not update test case: test case with uuid {} not found", (Object)uuid);
            return;
        }
        TestResult testResult = found.get();
        update.accept(testResult);
    }

    public void stopTestCase(String uuid) {
        if (!this.adapterConfig.shouldEnableTmsIntegration()) {
            return;
        }
        Optional<TestResult> found = this.storage.getTestResult(uuid);
        if (!found.isPresent()) {
            LOGGER.error("Could not stop test case: test case with uuid {} not found", (Object)uuid);
            return;
        }
        TestResult testResult = found.get();
        this.listenerManager.beforeTestStop(testResult);
        testResult.setItemStage(ItemStage.FINISHED).setStop(System.currentTimeMillis());
        this.threadContext.clear();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Stop test case {}", (Object)testResult);
        }
        this.writer.writeTest(testResult);
    }

    public void startPrepareFixtureAll(String parentUuid, String uuid, FixtureResult result) {
        if (!this.adapterConfig.shouldEnableTmsIntegration()) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Start prepare all fixture {} for parent {}", (Object)result, (Object)parentUuid);
        }
        this.storage.getTestsContainer(parentUuid).ifPresent(container -> {
            ResultStorage resultStorage = this.storage;
            synchronized (resultStorage) {
                container.getBeforeMethods().add(result);
            }
        });
        this.startFixture(uuid, result);
    }

    public void startTearDownFixtureAll(String parentUuid, String uuid, FixtureResult result) {
        if (!this.adapterConfig.shouldEnableTmsIntegration()) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Start tear down all fixture {} for parent {}", (Object)result, (Object)parentUuid);
        }
        this.storage.getTestsContainer(parentUuid).ifPresent(container -> {
            ResultStorage resultStorage = this.storage;
            synchronized (resultStorage) {
                container.getAfterMethods().add(result);
            }
        });
        this.startFixture(uuid, result);
    }

    public void startPrepareFixture(String parentUuid, String uuid, FixtureResult result) {
        if (!this.adapterConfig.shouldEnableTmsIntegration()) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Start prepare fixture {} for parent {}", (Object)result, (Object)parentUuid);
        }
        this.storage.getClassContainer(parentUuid).ifPresent(container -> {
            ResultStorage resultStorage = this.storage;
            synchronized (resultStorage) {
                container.getBeforeClassMethods().add(result);
            }
        });
        this.startFixture(uuid, result);
    }

    public void startTearDownFixture(String parentUuid, String uuid, FixtureResult result) {
        if (!this.adapterConfig.shouldEnableTmsIntegration()) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Start tear down fixture {} for parent {}", (Object)result, (Object)parentUuid);
        }
        this.storage.getClassContainer(parentUuid).ifPresent(container -> {
            ResultStorage resultStorage = this.storage;
            synchronized (resultStorage) {
                container.getAfterClassMethods().add(result);
            }
        });
        this.startFixture(uuid, result);
    }

    public void startPrepareFixtureEachTest(String parentUuid, String uuid, FixtureResult result) {
        if (!this.adapterConfig.shouldEnableTmsIntegration()) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Start prepare for each fixture {} for parent {}", (Object)result, (Object)parentUuid);
        }
        this.storage.getClassContainer(parentUuid).ifPresent(container -> {
            ResultStorage resultStorage = this.storage;
            synchronized (resultStorage) {
                container.getBeforeEachTest().add(result);
            }
        });
        this.startFixture(uuid, result);
    }

    public void startTearDownFixtureEachTest(String parentUuid, String uuid, FixtureResult result) {
        if (!this.adapterConfig.shouldEnableTmsIntegration()) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Start tear down for each fixture {} for parent {}", (Object)result, (Object)parentUuid);
        }
        this.storage.getClassContainer(parentUuid).ifPresent(container -> {
            ResultStorage resultStorage = this.storage;
            synchronized (resultStorage) {
                container.getAfterEachTest().add(result);
            }
        });
        this.startFixture(uuid, result);
    }

    private void startFixture(String uuid, FixtureResult result) {
        if (!this.adapterConfig.shouldEnableTmsIntegration()) {
            return;
        }
        this.storage.put(uuid, result);
        result.setItemStage(ItemStage.RUNNING).setStart(System.currentTimeMillis());
        this.threadContext.clear();
        this.threadContext.start(uuid);
    }

    public void updateFixture(String uuid, Consumer<FixtureResult> update) {
        Optional<FixtureResult> found;
        if (!this.adapterConfig.shouldEnableTmsIntegration()) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Update fixture {}", (Object)uuid);
        }
        if (!(found = this.storage.getFixture(uuid)).isPresent()) {
            LOGGER.error("Could not update test fixture: test fixture with uuid {} not found", (Object)uuid);
            return;
        }
        FixtureResult fixture = found.get();
        update.accept(fixture);
    }

    public void stopFixture(String uuid) {
        if (!this.adapterConfig.shouldEnableTmsIntegration()) {
            return;
        }
        Optional<FixtureResult> found = this.storage.getFixture(uuid);
        if (!found.isPresent()) {
            LOGGER.error("Could not stop test fixture: test fixture with uuid {} not found", (Object)uuid);
            return;
        }
        FixtureResult fixture = found.get();
        fixture.setItemStage(ItemStage.FINISHED).setStop(System.currentTimeMillis());
        this.storage.remove(uuid);
        this.threadContext.clear();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Stop fixture {}", (Object)fixture);
        }
    }

    public void startStep(String uuid, StepResult result) {
        if (!this.adapterConfig.shouldEnableTmsIntegration()) {
            return;
        }
        Optional<String> current = this.threadContext.getCurrent();
        if (!current.isPresent()) {
            LOGGER.debug("Could not start step {}: no test case running", (Object)result);
            return;
        }
        String parentUuid = current.get();
        this.startStep(parentUuid, uuid, result);
    }

    public void startStep(String parentUuid, String uuid, StepResult result) {
        if (!this.adapterConfig.shouldEnableTmsIntegration()) {
            return;
        }
        result.setItemStage(ItemStage.RUNNING).setStart(System.currentTimeMillis());
        this.threadContext.start(uuid);
        this.storage.put(uuid, result);
        this.storage.get(parentUuid, ResultWithSteps.class).ifPresent(parentStep -> {
            ResultStorage resultStorage = this.storage;
            synchronized (resultStorage) {
                parentStep.getSteps().add(result);
            }
        });
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Start step {} for parent {}", (Object)result, (Object)parentUuid);
        }
    }

    public void updateStep(Consumer<StepResult> update) {
        if (!this.adapterConfig.shouldEnableTmsIntegration()) {
            return;
        }
        Optional<String> current = this.threadContext.getCurrent();
        if (!current.isPresent()) {
            LOGGER.debug("Could not update step: no step running");
            return;
        }
        String uuid = current.get();
        this.updateStep(uuid, update);
    }

    public void updateStep(String uuid, Consumer<StepResult> update) {
        Optional<StepResult> found;
        if (!this.adapterConfig.shouldEnableTmsIntegration()) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Update step {}", (Object)uuid);
        }
        if (!(found = this.storage.getStep(uuid)).isPresent()) {
            LOGGER.error("Could not update step: step with uuid {} not found", (Object)uuid);
            return;
        }
        StepResult step = found.get();
        update.accept(step);
    }

    public void stopStep() {
        if (!this.adapterConfig.shouldEnableTmsIntegration()) {
            return;
        }
        String root = this.threadContext.getRoot().orElse(null);
        Optional<String> current = this.threadContext.getCurrent().filter(uuid -> !Objects.equals(uuid, root));
        if (!current.isPresent()) {
            LOGGER.debug("Could not stop step: no step running");
            return;
        }
        String uuid2 = current.get();
        this.stopStep(uuid2);
    }

    public void stopStep(String uuid) {
        if (!this.adapterConfig.shouldEnableTmsIntegration()) {
            return;
        }
        Optional<StepResult> found = this.storage.getStep(uuid);
        if (!found.isPresent()) {
            LOGGER.error("Could not stop step: step with uuid {} not found", (Object)uuid);
            return;
        }
        StepResult step = found.get();
        step.setItemStage(ItemStage.FINISHED);
        step.setStop(System.currentTimeMillis());
        this.storage.remove(uuid);
        this.threadContext.stop();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Stop step {}", (Object)step);
        }
    }

    public void addAttachments(List<String> attachments) {
        if (!this.adapterConfig.shouldEnableTmsIntegration()) {
            return;
        }
        ArrayList<String> uuids = new ArrayList<String>();
        for (String attachment : attachments) {
            String attachmentsId = this.writer.writeAttachment(attachment);
            if (attachmentsId.isEmpty()) {
                return;
            }
            uuids.add(attachmentsId);
        }
        Optional<String> current = this.threadContext.getCurrent();
        if (!current.isPresent()) {
            LOGGER.error("Could not add attachment: no test is running");
            return;
        }
        this.storage.get(current.get(), ResultWithAttachments.class).ifPresent(result -> {
            ResultStorage resultStorage = this.storage;
            synchronized (resultStorage) {
                result.getAttachments().addAll(uuids);
            }
        });
    }

    public boolean isFilteredMode() {
        return this.adapterConfig.getMode() == AdapterMode.USE_FILTER;
    }

    public List<String> getTestFromTestRun() {
        if (this.adapterConfig.shouldEnableTmsIntegration()) {
            try {
                List<String> externalIds = this.client.getAutotestExternalIdsFromTestRun();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("List of tests from test run: {}", externalIds);
                }
                return externalIds;
            }
            catch (ApiException e) {
                LOGGER.error("Could not get tests from test run", (Throwable)e);
            }
        }
        return new ArrayList<String>();
    }

    public Optional<String> getCurrentTestCaseOrStep() {
        return this.threadContext.getCurrent();
    }

    private static ListenerManager getDefaultListenerManager() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return new ListenerManager(ServiceLoaderListener.load(AdapterListener.class, classLoader));
    }
}

