/*
 * Decompiled with CFR 0.152.
 */
package ru.testit.writers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.testit.client.invoker.ApiException;
import ru.testit.client.model.AttachmentPutModelAutoTestStepResultsModel;
import ru.testit.client.model.AutoTestApiResult;
import ru.testit.client.model.AutoTestCreateApiModel;
import ru.testit.client.model.AutoTestResultsForTestRunModel;
import ru.testit.client.model.AutoTestStepApiModel;
import ru.testit.client.model.AutoTestUpdateApiModel;
import ru.testit.client.model.AutoTestWorkItemIdentifierApiResult;
import ru.testit.client.model.TestResultResponse;
import ru.testit.client.model.TestResultUpdateV2Request;
import ru.testit.clients.ClientConfiguration;
import ru.testit.clients.Converter;
import ru.testit.clients.ITmsApiClient;
import ru.testit.models.ClassContainer;
import ru.testit.models.MainContainer;
import ru.testit.models.TestResult;
import ru.testit.services.ResultStorage;
import ru.testit.writers.Writer;
import ru.testit.writers.helpers.BulkAutotestHelper;

public class HttpWriter
implements Writer {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpWriter.class);
    private final Map<String, UUID> testResults;
    private final ITmsApiClient apiClient;
    private final ResultStorage storage;
    private final ClientConfiguration config;

    public HttpWriter(ClientConfiguration config, ITmsApiClient client, ResultStorage storage) {
        this.config = config;
        this.apiClient = client;
        this.storage = storage;
        this.testResults = new HashMap<String, UUID>();
    }

    @Override
    public void writeTest(TestResult testResult) {
        if (!this.config.shouldImportRealtime()) {
            return;
        }
        this.writeTestRealtime(testResult);
    }

    private void writeTestRealtime(TestResult testResult) {
        try {
            String autoTestId;
            AutoTestApiResult autoTestApiResult;
            AutoTestApiResult autotest;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Write the auto test {}", (Object)testResult.getExternalId());
            }
            if ((autotest = Converter.convertAutoTestApiResultToAutoTestApiResult(autoTestApiResult = this.apiClient.getAutoTestByExternalId(testResult.getExternalId()))) != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("The auto test {} is exist", (Object)testResult.getExternalId());
                }
                AutoTestUpdateApiModel AutoTestUpdateApiModel2 = Converter.prepareToUpdateAutoTest(testResult, autotest, this.config.getProjectId());
                this.apiClient.updateAutoTest(AutoTestUpdateApiModel2);
                autoTestId = autotest.getId().toString();
            } else {
                AutoTestCreateApiModel model = Converter.prepareToCreateAutoTest(testResult, this.config.getProjectId());
                autoTestId = this.apiClient.createAutoTest(model);
            }
            List<String> workItemIds = testResult.getWorkItemIds();
            if (!workItemIds.isEmpty()) {
                this.updateTestLinkToWorkItems(autoTestId, workItemIds);
            }
            AutoTestResultsForTestRunModel autoTestResultsForTestRunModel = Converter.prepareTestResultForTestRun(testResult, this.config.getConfigurationId());
            ArrayList<AutoTestResultsForTestRunModel> results = new ArrayList<AutoTestResultsForTestRunModel>();
            results.add(autoTestResultsForTestRunModel);
            List<UUID> ids = this.apiClient.sendTestResults(this.config.getTestRunId(), results);
            this.testResults.put(testResult.getUuid(), ids.get(0));
        }
        catch (ApiException e) {
            LOGGER.error("Can not write the autotest: {}", (Object)e.getMessage());
        }
    }

    private List<UUID> prepareWorkItemUuidsForUpdateAutoTest(List<UUID> workItemUuids, String autoTestId) throws ApiException {
        List<AutoTestWorkItemIdentifierApiResult> linkedWorkItems = this.apiClient.getWorkItemsLinkedToTest(autoTestId);
        for (AutoTestWorkItemIdentifierApiResult linkedWorkItem : linkedWorkItems) {
            UUID linkedWorkItemUuid = linkedWorkItem.getId();
            if (workItemUuids.contains(linkedWorkItemUuid) || this.config.shouldAutomaticUpdationLinksToTestCases()) continue;
            workItemUuids.add(linkedWorkItemUuid);
        }
        return workItemUuids;
    }

    private void updateTestLinkToWorkItems(String autoTestId, List<String> workItemIds) throws ApiException {
        List<AutoTestWorkItemIdentifierApiResult> linkedWorkItems = this.apiClient.getWorkItemsLinkedToTest(autoTestId);
        for (AutoTestWorkItemIdentifierApiResult linkedWorkItem : linkedWorkItems) {
            String linkedWorkItemId = linkedWorkItem.getGlobalId().toString();
            if (workItemIds.contains(linkedWorkItemId)) {
                workItemIds.remove(linkedWorkItemId);
                continue;
            }
            if (!this.config.shouldAutomaticUpdationLinksToTestCases()) continue;
            this.apiClient.unlinkAutoTestToWorkItem(autoTestId, linkedWorkItemId);
        }
        this.apiClient.linkAutoTestToWorkItems(autoTestId, workItemIds);
    }

    @Override
    public void writeClass(ClassContainer container) {
        if (!this.config.shouldImportRealtime()) {
            return;
        }
        for (String testUuid : container.getChildren()) {
            this.storage.getTestResult(testUuid).ifPresent(test -> {
                try {
                    AutoTestApiResult autoTestApiResult = this.apiClient.getAutoTestByExternalId(test.getExternalId());
                    AutoTestApiResult AutoTestApiResult2 = Converter.convertAutoTestApiResultToAutoTestApiResult(autoTestApiResult);
                    if (AutoTestApiResult2 == null) {
                        return;
                    }
                    AutoTestUpdateApiModel autoTestUpdateApiModel = Converter.AutoTestApiResultToAutoTestUpdateApiModel(AutoTestApiResult2);
                    List<AutoTestStepApiModel> beforeClass = Converter.convertFixtureToApi(container.getBeforeClassMethods(), null);
                    List<AutoTestStepApiModel> beforeEach = Converter.convertFixtureToApi(container.getBeforeEachTest(), testUuid);
                    beforeClass.addAll(beforeEach);
                    List<AutoTestStepApiModel> afterClass = Converter.convertFixtureToApi(container.getAfterClassMethods(), null);
                    List<AutoTestStepApiModel> afterEach = Converter.convertFixtureToApi(container.getAfterEachTest(), testUuid);
                    afterClass.addAll(afterEach);
                    autoTestUpdateApiModel.setSetup(beforeClass);
                    autoTestUpdateApiModel.setTeardown(afterClass);
                    autoTestUpdateApiModel.setIsFlaky(AutoTestApiResult2.getIsFlaky());
                    this.apiClient.updateAutoTest(autoTestUpdateApiModel);
                }
                catch (ApiException e) {
                    LOGGER.error("Can not write the class: {}", (Object)e.getMessage());
                }
            });
        }
    }

    @Override
    public void writeTests(MainContainer container) {
        if (this.config.shouldImportRealtime()) {
            this.updateTestResults(container);
            return;
        }
        this.writeTestsAfterAll(container);
    }

    private void updateTestResults(MainContainer container) {
        List<AutoTestStepApiModel> beforeAll = Converter.convertFixtureToApi(container.getBeforeMethods(), null);
        List<AutoTestStepApiModel> afterAll = Converter.convertFixtureToApi(container.getAfterMethods(), null);
        List<AttachmentPutModelAutoTestStepResultsModel> beforeResultAll = Converter.convertResultFixture(container.getBeforeMethods(), null);
        List<AttachmentPutModelAutoTestStepResultsModel> afterResultAll = Converter.convertResultFixture(container.getAfterMethods(), null);
        for (String classUuid : container.getChildren()) {
            this.storage.getClassContainer(classUuid).ifPresent(cl -> {
                List<AutoTestStepApiModel> afterClass = Converter.convertFixtureToApi(cl.getAfterClassMethods(), null);
                List<AttachmentPutModelAutoTestStepResultsModel> beforeResultClass = Converter.convertResultFixture(cl.getBeforeClassMethods(), null);
                List<AttachmentPutModelAutoTestStepResultsModel> afterResultClass = Converter.convertResultFixture(cl.getAfterClassMethods(), null);
                for (String testUuid : cl.getChildren()) {
                    this.storage.getTestResult(testUuid).ifPresent(test -> {
                        try {
                            AutoTestApiResult autoTestApiResult = this.apiClient.getAutoTestByExternalId(test.getExternalId());
                            AutoTestApiResult AutoTestApiResult2 = Converter.convertAutoTestApiResultToAutoTestApiResult(autoTestApiResult);
                            if (AutoTestApiResult2 == null) {
                                return;
                            }
                            AutoTestUpdateApiModel autoTestUpdateApiModel = Converter.AutoTestApiResultToAutoTestUpdateApiModel(AutoTestApiResult2);
                            ArrayList beforeFinish = new ArrayList(beforeAll);
                            beforeFinish.addAll(autoTestUpdateApiModel.getSetup());
                            autoTestUpdateApiModel.setSetup(beforeFinish);
                            List afterFinish = autoTestUpdateApiModel.getTeardown();
                            afterFinish.addAll(afterClass);
                            afterFinish.addAll(afterAll);
                            autoTestUpdateApiModel.setTeardown(afterFinish);
                            autoTestUpdateApiModel.setIsFlaky(AutoTestApiResult2.getIsFlaky());
                            this.apiClient.updateAutoTest(autoTestUpdateApiModel);
                            AutoTestResultsForTestRunModel autoTestResultsForTestRunModel = Converter.testResultToAutoTestResultsForTestRunModel(test);
                            List<AttachmentPutModelAutoTestStepResultsModel> beforeResultEach = Converter.convertResultFixture(cl.getBeforeEachTest(), testUuid);
                            ArrayList<AttachmentPutModelAutoTestStepResultsModel> beforeResultFinish = new ArrayList<AttachmentPutModelAutoTestStepResultsModel>();
                            beforeResultFinish.addAll(beforeResultAll);
                            beforeResultFinish.addAll(beforeResultClass);
                            beforeResultFinish.addAll(beforeResultEach);
                            List<AttachmentPutModelAutoTestStepResultsModel> afterResultEach = Converter.convertResultFixture(cl.getAfterEachTest(), testUuid);
                            ArrayList<AttachmentPutModelAutoTestStepResultsModel> afterResultFinish = new ArrayList<AttachmentPutModelAutoTestStepResultsModel>();
                            afterResultFinish.addAll(afterResultEach);
                            afterResultFinish.addAll(afterResultClass);
                            afterResultFinish.addAll(afterResultAll);
                            autoTestResultsForTestRunModel.setSetupResults(beforeResultFinish);
                            autoTestResultsForTestRunModel.setTeardownResults(afterResultFinish);
                            UUID testResultId = this.testResults.get(test.getUuid());
                            TestResultResponse resultModel = this.apiClient.getTestResult(testResultId);
                            TestResultUpdateV2Request model = Converter.testResultToTestResultUpdateModel(resultModel);
                            model.setSetupResults(Converter.stepResultsToRequests(beforeResultFinish));
                            model.setTeardownResults(Converter.stepResultsToRequests(afterResultFinish));
                            this.apiClient.updateTestResult(testResultId, model);
                        }
                        catch (ApiException e) {
                            LOGGER.error("Can not update the autotest: {}", (Object)e.getMessage());
                        }
                    });
                }
            });
        }
    }

    private void writeTestsAfterAll(MainContainer container) {
        List<AutoTestStepApiModel> beforeAll = Converter.convertFixtureToApi(container.getBeforeMethods(), null);
        List<AutoTestStepApiModel> afterAll = Converter.convertFixtureToApi(container.getAfterMethods(), null);
        List<AttachmentPutModelAutoTestStepResultsModel> beforeResultAll = Converter.convertResultFixture(container.getBeforeMethods(), null);
        List<AttachmentPutModelAutoTestStepResultsModel> afterResultAll = Converter.convertResultFixture(container.getAfterMethods(), null);
        BulkAutotestHelper bulkHelper = new BulkAutotestHelper(this.apiClient, this.config);
        for (String classUuid : container.getChildren()) {
            this.storage.getClassContainer(classUuid).ifPresent(cl -> {
                List<AutoTestStepApiModel> beforeClass = Converter.convertFixtureToApi(cl.getBeforeClassMethods(), null);
                List<AttachmentPutModelAutoTestStepResultsModel> beforeResultClass = Converter.convertResultFixture(cl.getBeforeClassMethods(), null);
                List<AutoTestStepApiModel> afterClass = Converter.convertFixtureToApi(cl.getAfterClassMethods(), null);
                List<AttachmentPutModelAutoTestStepResultsModel> afterResultClass = Converter.convertResultFixture(cl.getAfterClassMethods(), null);
                for (String testUuid : cl.getChildren()) {
                    this.storage.getTestResult(testUuid).ifPresent(test -> {
                        try {
                            List<AutoTestStepApiModel> beforeEach = Converter.convertFixtureToApi(cl.getBeforeEachTest(), testUuid);
                            List<AttachmentPutModelAutoTestStepResultsModel> beforeResultEach = Converter.convertResultFixture(cl.getBeforeEachTest(), testUuid);
                            ArrayList<AttachmentPutModelAutoTestStepResultsModel> beforeResultFinish = new ArrayList<AttachmentPutModelAutoTestStepResultsModel>();
                            beforeResultFinish.addAll(beforeResultAll);
                            beforeResultFinish.addAll(beforeResultClass);
                            beforeResultFinish.addAll(beforeResultEach);
                            List<AutoTestStepApiModel> afterEach = Converter.convertFixtureToApi(cl.getAfterEachTest(), testUuid);
                            List<AttachmentPutModelAutoTestStepResultsModel> afterResultEach = Converter.convertResultFixture(cl.getAfterEachTest(), testUuid);
                            ArrayList<AttachmentPutModelAutoTestStepResultsModel> afterResultFinish = new ArrayList<AttachmentPutModelAutoTestStepResultsModel>();
                            afterResultFinish.addAll(afterResultEach);
                            afterResultFinish.addAll(afterResultClass);
                            afterResultFinish.addAll(afterResultAll);
                            ArrayList<AutoTestStepApiModel> beforeFinish = new ArrayList<AutoTestStepApiModel>();
                            beforeFinish.addAll(beforeAll);
                            beforeFinish.addAll(beforeClass);
                            beforeFinish.addAll(beforeEach);
                            ArrayList<AutoTestStepApiModel> afterFinish = new ArrayList<AutoTestStepApiModel>();
                            afterFinish.addAll(afterEach);
                            afterFinish.addAll(afterClass);
                            afterFinish.addAll(afterAll);
                            AutoTestApiResult autoTestApiResult = this.apiClient.getAutoTestByExternalId(test.getExternalId());
                            AutoTestApiResult AutoTestApiResult2 = Converter.convertAutoTestApiResultToAutoTestApiResult(autoTestApiResult);
                            AutoTestResultsForTestRunModel autoTestResultsForTestRunModel = Converter.prepareTestResultForTestRun(test, this.config.getConfigurationId());
                            autoTestResultsForTestRunModel.setSetupResults(beforeResultFinish);
                            autoTestResultsForTestRunModel.setTeardownResults(afterResultFinish);
                            if (AutoTestApiResult2 == null) {
                                AutoTestCreateApiModel model = Converter.prepareToCreateAutoTest(test, this.config.getProjectId());
                                model.setSetup(beforeFinish);
                                model.setTeardown(afterFinish);
                                bulkHelper.addForCreate(model, autoTestResultsForTestRunModel);
                            } else {
                                AutoTestUpdateApiModel model = Converter.prepareToUpdateAutoTest(test, AutoTestApiResult2, this.config.getProjectId());
                                model.setSetup(beforeFinish);
                                model.setTeardown(afterFinish);
                                String id = AutoTestApiResult2.getGlobalId().toString();
                                List<String> wi = test.getWorkItemIds();
                                HashMap<String, List<String>> autotestLinksToWIForUpdate = new HashMap<String, List<String>>();
                                autotestLinksToWIForUpdate.put(id, wi);
                                bulkHelper.addForUpdate(model, autoTestResultsForTestRunModel, autotestLinksToWIForUpdate);
                            }
                        }
                        catch (ApiException e) {
                            LOGGER.error(e.getMessage());
                        }
                    });
                }
            });
        }
        try {
            bulkHelper.teardown();
        }
        catch (ApiException e) {
            LOGGER.error(e.getMessage());
        }
    }

    @Override
    public String writeAttachment(String path) {
        try {
            return this.apiClient.addAttachment(path);
        }
        catch (ApiException e) {
            LOGGER.error("Can not write attachment: {}", (Object)e.getMessage());
            return "";
        }
    }

    void addUuid(String key, UUID uuid) {
        this.testResults.put(key, uuid);
    }
}

