/*
 * Decompiled with CFR 0.152.
 */
package ru.testit.clients;

import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.testit.client.api.AttachmentsApi;
import ru.testit.client.api.AutoTestsApi;
import ru.testit.client.api.TestResultsApi;
import ru.testit.client.api.TestRunsApi;
import ru.testit.client.api.WorkItemsApi;
import ru.testit.client.invoker.ApiClient;
import ru.testit.client.invoker.ApiException;
import ru.testit.client.model.AttachmentModel;
import ru.testit.client.model.AutoTestApiResult;
import ru.testit.client.model.AutoTestCreateApiModel;
import ru.testit.client.model.AutoTestFilterApiModel;
import ru.testit.client.model.AutoTestResultsForTestRunModel;
import ru.testit.client.model.AutoTestSearchApiModel;
import ru.testit.client.model.AutoTestSearchIncludeApiModel;
import ru.testit.client.model.AutoTestUpdateApiModel;
import ru.testit.client.model.AutoTestWorkItemIdentifierApiResult;
import ru.testit.client.model.CreateEmptyTestRunApiModel;
import ru.testit.client.model.TestResultResponse;
import ru.testit.client.model.TestResultUpdateV2Request;
import ru.testit.client.model.TestResultsFilterApiModel;
import ru.testit.client.model.TestRunV2ApiResult;
import ru.testit.client.model.UpdateEmptyTestRunApiModel;
import ru.testit.client.model.WorkItemIdApiModel;
import ru.testit.client.model.WorkItemModel;
import ru.testit.clients.ClientConfiguration;
import ru.testit.clients.Converter;
import ru.testit.clients.ITmsApiClient;
import ru.testit.services.HtmlEscapeUtils;

public class TmsApiClient
implements ITmsApiClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmsApiClient.class);
    private static final String AUTH_PREFIX = "PrivateToken";
    private static final boolean INCLUDE_STEPS = true;
    private static final boolean INCLUDE_LABELS = true;
    private static final boolean INCLUDE_LINKS = true;
    private static final int MAX_TRIES = 10;
    private static final int WAITING_TIME = 100;
    private static final int TESTS_LIMIT = 100;
    private final TestRunsApi testRunsApi;
    private final AutoTestsApi autoTestsApi;
    private final AttachmentsApi attachmentsApi;
    private final TestResultsApi testResultsApi;
    private final WorkItemsApi workItemsApi;
    private final ClientConfiguration clientConfiguration;

    public TmsApiClient(ClientConfiguration config) {
        boolean disableCertificateValidation = config.getCertValidation() == false;
        ApiClient apiClient = new ApiClient(disableCertificateValidation);
        apiClient.setBasePath(config.getUrl());
        apiClient.setApiKeyPrefix(AUTH_PREFIX);
        apiClient.setApiKey(config.getPrivateToken());
        this.clientConfiguration = config;
        this.testRunsApi = new TestRunsApi(apiClient);
        this.autoTestsApi = new AutoTestsApi(apiClient);
        this.attachmentsApi = new AttachmentsApi(apiClient);
        this.testResultsApi = new TestResultsApi(apiClient);
        this.workItemsApi = new WorkItemsApi(apiClient);
    }

    @Override
    public TestRunV2ApiResult createTestRun() throws ApiException {
        CreateEmptyTestRunApiModel model = new CreateEmptyTestRunApiModel();
        model.setProjectId(UUID.fromString(this.clientConfiguration.getProjectId()));
        if (!Objects.equals(this.clientConfiguration.getTestRunName(), "null")) {
            model.setName(HtmlEscapeUtils.escapeHtmlTags(this.clientConfiguration.getTestRunName()));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Create new test run: {}", (Object)model);
        }
        TestRunV2ApiResult response = this.testRunsApi.createEmpty(model);
        this.testRunsApi.startTestRun(response.getId());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("The test run created: {}", (Object)response);
        }
        return response;
    }

    @Override
    public TestRunV2ApiResult getTestRun(String uuid) throws ApiException {
        return this.testRunsApi.getTestRunById(UUID.fromString(uuid));
    }

    @Override
    public void updateTestRun(UpdateEmptyTestRunApiModel testRun) throws ApiException {
        this.testRunsApi.updateEmpty(testRun);
    }

    @Override
    public void completeTestRun(String uuid) throws ApiException {
        this.testRunsApi.completeTestRun(UUID.fromString(uuid));
    }

    @Override
    public void updateAutoTest(AutoTestUpdateApiModel model) throws ApiException {
        this.autoTestsApi.updateAutoTest(model);
    }

    @Override
    public String createAutoTest(AutoTestCreateApiModel model) throws ApiException {
        return Objects.requireNonNull(this.autoTestsApi.createAutoTest(model).getId()).toString();
    }

    @Override
    public void updateAutoTests(List<AutoTestUpdateApiModel> models) throws ApiException {
        this.autoTestsApi.updateMultiple(models);
    }

    @Override
    public List<AutoTestApiResult> createAutoTests(List<AutoTestCreateApiModel> models) throws ApiException {
        return this.autoTestsApi.createMultiple(models);
    }

    @Override
    public List<UUID> getWorkItemUuidsByIds(Iterable<String> workItemIds) {
        ArrayList<UUID> workItemUuids = new ArrayList<UUID>();
        for (String workItemId : workItemIds) {
            try {
                WorkItemModel workItem = this.workItemsApi.getWorkItemById(workItemId, null, null);
                workItemUuids.add(workItem.getId());
            }
            catch (ApiException e) {
                LOGGER.error("Cannot get work item by id {} {}", (Object)workItemId, (Object)e.getMessage());
            }
        }
        return workItemUuids;
    }

    @Override
    public AutoTestApiResult getAutoTestByExternalId(String externalId) throws ApiException {
        AutoTestFilterApiModel filter = new AutoTestFilterApiModel();
        HashSet<UUID> projectIds = new HashSet<UUID>();
        projectIds.add(UUID.fromString(this.clientConfiguration.getProjectId()));
        filter.setProjectIds(projectIds);
        filter.setIsDeleted(Boolean.valueOf(false));
        HashSet<String> externalIds = new HashSet<String>();
        externalIds.add(externalId);
        filter.externalIds(externalIds);
        AutoTestSearchIncludeApiModel includes = new AutoTestSearchIncludeApiModel();
        includes.setIncludeLabels(Boolean.valueOf(true));
        includes.setIncludeSteps(Boolean.valueOf(true));
        includes.setIncludeLinks(Boolean.valueOf(true));
        AutoTestSearchApiModel model = new AutoTestSearchApiModel();
        model.setFilter(filter);
        model.setIncludes(includes);
        List tests = this.autoTestsApi.apiV2AutoTestsSearchPost(null, null, null, null, null, model);
        if ((long)tests.size() == 0L) {
            return null;
        }
        return (AutoTestApiResult)tests.get(0);
    }

    @Override
    public void linkAutoTestToWorkItems(String id, Iterable<String> workItemIds) {
        for (String workItemId : workItemIds) {
            this.linkAutoTestToWorkItem(id, workItemId);
        }
    }

    public void linkAutoTestToWorkItem(String id, String workItemId) {
        LOGGER.debug("Link autotest {} from workitem {}", (Object)id, (Object)workItemId);
        for (int attempts = 0; attempts < 10; ++attempts) {
            try {
                this.autoTestsApi.linkAutoTestToWorkItem(id, new WorkItemIdApiModel().id(workItemId));
                LOGGER.debug("Link autotest {} to workitem {} is successfully", (Object)id, (Object)workItemId);
                return;
            }
            catch (ApiException e) {
                LOGGER.error("Cannot link autotest {} to work item {}", (Object)id, (Object)workItemId);
                try {
                    Thread.sleep(Duration.ofMillis(100L).toMillis());
                    continue;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
    }

    @Override
    public void unlinkAutoTestToWorkItem(String id, String workItemId) {
        LOGGER.debug("Unlink autotest {} from workitem {}", (Object)id, (Object)workItemId);
        for (int attempts = 0; attempts < 10; ++attempts) {
            try {
                this.autoTestsApi.deleteAutoTestLinkFromWorkItem(id, workItemId);
                LOGGER.debug("Unlink autotest {} from workitem {} is successfully", (Object)id, (Object)workItemId);
                return;
            }
            catch (ApiException e) {
                LOGGER.error("Cannot unlink autotest {} from work item {}", (Object)id, (Object)workItemId);
                try {
                    Thread.sleep(Duration.ofMillis(100L).toMillis());
                    continue;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
    }

    @Override
    public List<AutoTestWorkItemIdentifierApiResult> getWorkItemsLinkedToTest(String id) throws ApiException {
        return this.autoTestsApi.getWorkItemsLinkedToAutoTest(id, Boolean.valueOf(false), Boolean.valueOf(false));
    }

    @Override
    public List<UUID> sendTestResults(String testRunUuid, List<AutoTestResultsForTestRunModel> models) throws ApiException {
        return this.testRunsApi.setAutoTestResultsForTestRun(UUID.fromString(testRunUuid), models);
    }

    @Override
    public String addAttachment(String path) throws ApiException {
        File file = new File(path);
        AttachmentModel model = this.attachmentsApi.apiV2AttachmentsPost(file);
        return model.getId().toString();
    }

    @Override
    public List<String> getTestFromTestRun(String testRunUuid, String configurationId) throws ApiException {
        TestRunV2ApiResult model = this.testRunsApi.getTestRunById(UUID.fromString(testRunUuid));
        UUID configUUID = UUID.fromString(configurationId);
        if (Objects.requireNonNull(model.getTestResults()).isEmpty()) {
            return new ArrayList<String>();
        }
        return model.getTestResults().stream().filter(result -> Objects.equals(result.getConfigurationId(), configUUID)).map(result -> Objects.requireNonNull(result.getAutoTest()).getExternalId()).collect(Collectors.toList());
    }

    @Override
    public List<String> getAutotestExternalIdsFromTestRun() throws ApiException {
        ArrayList allTestResults = new ArrayList();
        TestResultsFilterApiModel model = Converter.buildTestResultsFilterApiModelWithInProgressOutcome(UUID.fromString(this.clientConfiguration.getTestRunId()), UUID.fromString(this.clientConfiguration.getConfigurationId()));
        int skip = 0;
        do {
            List testResults = this.testResultsApi.apiV2TestResultsSearchPost(Integer.valueOf(skip), Integer.valueOf(100), null, null, null, model);
            allTestResults.addAll(testResults);
            skip += 100;
            if (!testResults.isEmpty()) continue;
            skip = -1;
        } while (skip >= 0);
        return allTestResults.stream().map(result -> Objects.requireNonNull(result).getAutotestExternalId()).collect(Collectors.toList());
    }

    @Override
    public TestResultResponse getTestResult(UUID uuid) throws ApiException {
        return this.testResultsApi.apiV2TestResultsIdGet(uuid);
    }

    @Override
    public void updateTestResult(UUID uuid, TestResultUpdateV2Request model) throws ApiException {
        this.testResultsApi.apiV2TestResultsIdPut(uuid, model);
    }
}

