/*
 * Decompiled with CFR 0.152.
 */
package ru.testit.properties;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppProperties {
    public static final String URL = "url";
    public static final String PRIVATE_TOKEN = "privateToken";
    public static final String PROJECT_ID = "projectId";
    public static final String CONFIGURATION_ID = "configurationId";
    public static final String TEST_RUN_ID = "testRunId";
    public static final String TEST_RUN_NAME = "testRunName";
    public static final String ADAPTER_MODE = "adapterMode";
    public static final String AUTOMATIC_CREATION_TEST_CASES = "automaticCreationTestCases";
    public static final String AUTOMATIC_UPDATION_LINKS_TO_TEST_CASES = "automaticUpdationLinksToTestCases";
    public static final String CERT_VALIDATION = "certValidation";
    public static final String TMS_INTEGRATION = "testIt";
    public static final String TMS_IMPORT_REALTIME = "importRealtime";
    private static final String PROPERTIES_FILE = "testit.properties";
    private static final Logger log = LoggerFactory.getLogger(AppProperties.class);
    private static final HashMap<String, HashMap<String, String>> envVarsNames = new HashMap<String, HashMap<String, String>>(){
        {
            this.put("env", new HashMap<String, String>(){
                {
                    this.put(AppProperties.URL, "TMS_URL");
                    this.put(AppProperties.PRIVATE_TOKEN, "TMS_PRIVATE_TOKEN");
                    this.put(AppProperties.PROJECT_ID, "TMS_PROJECT_ID");
                    this.put(AppProperties.CONFIGURATION_ID, "TMS_CONFIGURATION_ID");
                    this.put(AppProperties.TEST_RUN_ID, "TMS_TEST_RUN_ID");
                    this.put(AppProperties.TEST_RUN_NAME, "TMS_TEST_RUN_NAME");
                    this.put(AppProperties.ADAPTER_MODE, "TMS_ADAPTER_MODE");
                    this.put(AppProperties.AUTOMATIC_CREATION_TEST_CASES, "TMS_AUTOMATIC_CREATION_TEST_CASES");
                    this.put(AppProperties.AUTOMATIC_UPDATION_LINKS_TO_TEST_CASES, "TMS_AUTOMATIC_UPDATION_LINKS_TO_TEST_CASES");
                    this.put(AppProperties.CERT_VALIDATION, "TMS_CERT_VALIDATION");
                    this.put(AppProperties.TMS_INTEGRATION, "TMS_TEST_IT");
                    this.put(AppProperties.TMS_IMPORT_REALTIME, "TMS_IMPORT_REALTIME");
                }
            });
            this.put("cli", new HashMap<String, String>(){
                {
                    this.put(AppProperties.URL, "tmsUrl");
                    this.put(AppProperties.PRIVATE_TOKEN, "tmsPrivateToken");
                    this.put(AppProperties.PROJECT_ID, "tmsProjectId");
                    this.put(AppProperties.CONFIGURATION_ID, "tmsConfigurationId");
                    this.put(AppProperties.TEST_RUN_ID, "tmsTestRunId");
                    this.put(AppProperties.TEST_RUN_NAME, "tmsTestRunName");
                    this.put(AppProperties.ADAPTER_MODE, "tmsAdapterMode");
                    this.put(AppProperties.AUTOMATIC_CREATION_TEST_CASES, "tmsAutomaticCreationTestCases");
                    this.put(AppProperties.AUTOMATIC_UPDATION_LINKS_TO_TEST_CASES, "tmsAutomaticUpdationLinksToTestCases");
                    this.put(AppProperties.CERT_VALIDATION, "tmsCertValidation");
                    this.put(AppProperties.TMS_INTEGRATION, "tmsTestIt");
                    this.put(AppProperties.TMS_IMPORT_REALTIME, "tmsImportRealtime");
                }
            });
        }
    };

    private AppProperties() {
    }

    public static Properties loadProperties() {
        String configFile = AppProperties.getConfigFileName();
        Properties properties = new Properties();
        AppProperties.loadPropertiesFrom(Thread.currentThread().getContextClassLoader(), properties, configFile);
        AppProperties.loadPropertiesFrom(ClassLoader.getSystemClassLoader(), properties, configFile);
        String token = String.valueOf(properties.get(PRIVATE_TOKEN));
        if (token != null && !token.isEmpty() && !token.equals("null")) {
            log.warn("The configuration file specifies a private token. It is not safe. Use TMS_PRIVATE_TOKEN environment variable");
        }
        Properties systemProps = System.getProperties();
        Properties envProps = new Properties();
        envProps.putAll(System.getenv());
        properties.putAll(AppProperties.loadPropertiesFromEnv(systemProps, envVarsNames.getOrDefault("env", new HashMap())));
        properties.putAll(AppProperties.loadPropertiesFromEnv(envProps, envVarsNames.getOrDefault("env", new HashMap())));
        properties.putAll(AppProperties.loadPropertiesFromEnv(systemProps, envVarsNames.getOrDefault("cli", new HashMap())));
        properties.putAll(AppProperties.loadPropertiesFromEnv(envProps, envVarsNames.getOrDefault("cli", new HashMap())));
        if (Objects.equals(properties.getProperty(TMS_INTEGRATION, "true"), "false")) {
            return properties;
        }
        return AppProperties.validateProperties(properties);
    }

    private static void loadPropertiesFrom(ClassLoader classLoader, Properties properties, String fileName) {
        Properties newProps = new Properties();
        try (InputStream stream = classLoader.getResourceAsStream(fileName);){
            if (stream != null) {
                newProps.load(stream);
                for (String key : newProps.stringPropertyNames()) {
                    String value = newProps.getProperty(key);
                    if (value == null || value.isEmpty()) continue;
                    properties.setProperty(key, value);
                }
            }
        }
        catch (IOException e) {
            log.error("Exception while read properties: {}", (Object)e.getMessage());
        }
    }

    private static Map<String, String> loadPropertiesFromEnv(Properties properties, HashMap<String, String> varNames) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            String url = properties.getProperty(varNames.get(URL), null);
            new URL(url).toURI();
            result.put(URL, url);
        }
        catch (IllegalArgumentException | NullPointerException | SecurityException | MalformedURLException | URISyntaxException url) {
            // empty catch block
        }
        try {
            String token = properties.getProperty(varNames.get(PRIVATE_TOKEN), null);
            if (token != null && !token.isEmpty() && !token.equals("null")) {
                result.put(PRIVATE_TOKEN, token);
            }
        }
        catch (IllegalArgumentException | NullPointerException | SecurityException token) {
            // empty catch block
        }
        try {
            String projectId = properties.getProperty(varNames.get(PROJECT_ID), null);
            if (projectId != null && !projectId.isEmpty()) {
                UUID.fromString(projectId);
                result.put(PROJECT_ID, projectId);
            }
        }
        catch (IllegalArgumentException | NullPointerException | SecurityException projectId) {
            // empty catch block
        }
        try {
            String configurationId = properties.getProperty(varNames.get(CONFIGURATION_ID), null);
            if (configurationId != null && !configurationId.isEmpty()) {
                UUID.fromString(configurationId);
                result.put(CONFIGURATION_ID, configurationId);
            }
        }
        catch (IllegalArgumentException | NullPointerException | SecurityException configurationId) {
            // empty catch block
        }
        try {
            String testRunId = properties.getProperty(varNames.get(TEST_RUN_ID), null);
            if (testRunId != null && !testRunId.isEmpty()) {
                UUID.fromString(testRunId);
                result.put(TEST_RUN_ID, testRunId);
            }
        }
        catch (IllegalArgumentException | NullPointerException | SecurityException testRunId) {
            // empty catch block
        }
        try {
            String testRunName = properties.getProperty(varNames.get(TEST_RUN_NAME), null);
            if (testRunName != null && !testRunName.isEmpty() && !testRunName.equals("null")) {
                result.put(TEST_RUN_NAME, testRunName);
            }
        }
        catch (IllegalArgumentException | NullPointerException | SecurityException testRunName) {
            // empty catch block
        }
        try {
            String adapterMode = properties.getProperty(varNames.get(ADAPTER_MODE), null);
            int mode = Integer.parseInt(adapterMode);
            if (0 <= mode && mode <= 2) {
                result.put(ADAPTER_MODE, adapterMode);
            }
        }
        catch (IllegalArgumentException | NullPointerException | SecurityException adapterMode) {
            // empty catch block
        }
        try {
            String createTestCases = properties.getProperty(varNames.get(AUTOMATIC_CREATION_TEST_CASES), null);
            if (Objects.equals(createTestCases, "false") || Objects.equals(createTestCases, "true")) {
                result.put(AUTOMATIC_CREATION_TEST_CASES, createTestCases);
            }
        }
        catch (IllegalArgumentException | NullPointerException | SecurityException createTestCases) {
            // empty catch block
        }
        try {
            String updateLinksToTestCases = properties.getProperty(varNames.get(AUTOMATIC_UPDATION_LINKS_TO_TEST_CASES), null);
            if (Objects.equals(updateLinksToTestCases, "false") || Objects.equals(updateLinksToTestCases, "true")) {
                result.put(AUTOMATIC_UPDATION_LINKS_TO_TEST_CASES, updateLinksToTestCases);
            }
        }
        catch (IllegalArgumentException | NullPointerException | SecurityException updateLinksToTestCases) {
            // empty catch block
        }
        try {
            String certValidation = properties.getProperty(varNames.get(CERT_VALIDATION), null);
            if (Objects.equals(certValidation, "false") || Objects.equals(certValidation, "true")) {
                result.put(CERT_VALIDATION, certValidation);
            }
        }
        catch (IllegalArgumentException | NullPointerException | SecurityException certValidation) {
            // empty catch block
        }
        try {
            String tmsIntegration = properties.getProperty(varNames.get(TMS_INTEGRATION), null);
            if (Objects.equals(tmsIntegration, "false") || Objects.equals(tmsIntegration, "true")) {
                result.put(TMS_INTEGRATION, tmsIntegration);
            }
        }
        catch (IllegalArgumentException | NullPointerException | SecurityException tmsIntegration) {
            // empty catch block
        }
        try {
            String tmsImportRealtime = properties.getProperty(varNames.get(TMS_IMPORT_REALTIME), null);
            if (Objects.equals(tmsImportRealtime, "false") || Objects.equals(tmsImportRealtime, "true")) {
                result.put(TMS_IMPORT_REALTIME, tmsImportRealtime);
            }
        }
        catch (IllegalArgumentException | NullPointerException | SecurityException runtimeException) {
            // empty catch block
        }
        return result;
    }

    private static Properties validateProperties(Properties properties) {
        String errors;
        String tmsImportRealtime;
        String tmsIntegration;
        String certValidation;
        String updateLinksToTestCases;
        StringBuilder errorsBuilder;
        block21: {
            String message;
            String message2;
            String message3;
            errorsBuilder = new StringBuilder();
            try {
                String url = properties.getProperty(URL);
                new URL(url).toURI();
            }
            catch (Exception e) {
                message3 = "Invalid url: " + e.getMessage();
                log.error(message3);
                errorsBuilder.append(message3).append(System.lineSeparator());
            }
            String token = properties.getProperty(PRIVATE_TOKEN);
            if (token == null || token.isEmpty() || token.equals("null")) {
                message3 = "Invalid token: " + token;
                log.error(message3);
                errorsBuilder.append(message3).append(System.lineSeparator());
            }
            try {
                String projectId = properties.getProperty(PROJECT_ID);
                UUID.fromString(projectId);
            }
            catch (Exception e) {
                message2 = "Invalid projectId: " + e.getMessage();
                log.error(message2);
                errorsBuilder.append(message2).append(System.lineSeparator());
            }
            try {
                String configurationId = properties.getProperty(CONFIGURATION_ID);
                UUID.fromString(configurationId);
            }
            catch (Exception e) {
                message2 = "Invalid configurationId: " + e.getMessage();
                log.error(message2);
                errorsBuilder.append(message2).append(System.lineSeparator());
            }
            try {
                String adapterMode = properties.getProperty(ADAPTER_MODE);
                int mode = Integer.parseInt(adapterMode);
                if (mode > 2 || mode < 0) {
                    log.warn("Invalid adapterMode: {}. Use default value instead: 0", (Object)mode);
                    properties.setProperty(ADAPTER_MODE, "0");
                }
            }
            catch (Exception e) {
                log.warn("Invalid adapterMode: {}. Use default value instead: 0", (Object)e.getMessage());
                properties.setProperty(ADAPTER_MODE, "0");
            }
            int adapterMode = 0;
            try {
                adapterMode = Integer.parseInt(properties.getProperty(ADAPTER_MODE));
            }
            catch (Exception mode) {
                // empty catch block
            }
            try {
                String testRunId = properties.getProperty(TEST_RUN_ID);
                UUID.fromString(testRunId);
                if (adapterMode == 2) {
                    message = "Adapter works in mode 2. Config should not contains test run id.";
                    errorsBuilder.append(message).append(System.lineSeparator());
                }
            }
            catch (Exception e) {
                if (adapterMode != 0 && adapterMode != 1) break block21;
                message = "Invalid testRunId: " + e.getMessage();
                log.error(message);
                errorsBuilder.append(message).append(System.lineSeparator());
            }
        }
        String createTestCases = properties.getProperty(AUTOMATIC_CREATION_TEST_CASES);
        if (!Objects.equals(createTestCases, "false") && !Objects.equals(createTestCases, "true")) {
            log.warn("Invalid autoCreateTestCases: {}. Use default value instead: false", (Object)createTestCases);
            properties.setProperty(AUTOMATIC_CREATION_TEST_CASES, "false");
        }
        if (!Objects.equals(updateLinksToTestCases = properties.getProperty(AUTOMATIC_UPDATION_LINKS_TO_TEST_CASES), "false") && !Objects.equals(updateLinksToTestCases, "true")) {
            log.warn("Invalid autoUpdateLinksToTestCases: {}. Use default value instead: false", (Object)updateLinksToTestCases);
            properties.setProperty(AUTOMATIC_UPDATION_LINKS_TO_TEST_CASES, "false");
        }
        if (!Objects.equals(certValidation = properties.getProperty(CERT_VALIDATION), "false") && !Objects.equals(certValidation, "true")) {
            log.warn("Invalid certValidation: {}. Use default value instead: true", (Object)certValidation);
            properties.setProperty(CERT_VALIDATION, "true");
        }
        if (!Objects.equals(tmsIntegration = properties.getProperty(TMS_INTEGRATION), "false") && !Objects.equals(tmsIntegration, "true")) {
            log.warn("Invalid tmsIntegration: {}. Use default value instead: true", (Object)tmsIntegration);
            properties.setProperty(TMS_INTEGRATION, "true");
        }
        if (!Objects.equals(tmsImportRealtime = properties.getProperty(TMS_IMPORT_REALTIME), "false") && !Objects.equals(tmsImportRealtime, "true")) {
            log.warn("Invalid tmsImportRealtime: {}. Use default value instead: true", (Object)tmsImportRealtime);
            properties.setProperty(TMS_IMPORT_REALTIME, "true");
        }
        if (!(errors = errorsBuilder.toString()).isEmpty()) {
            throw new AssertionError((Object)("Invalid configuration provided : " + errors));
        }
        return properties;
    }

    private static String getConfigFileName() {
        try {
            String fileName = System.getProperty("TMS_CONFIG_FILE");
            if (fileName != null && !fileName.isEmpty() && !fileName.equals("null")) {
                return fileName;
            }
        }
        catch (IllegalArgumentException | NullPointerException | SecurityException runtimeException) {
            // empty catch block
        }
        return PROPERTIES_FILE;
    }
}

