/*
 * Decompiled with CFR 0.152.
 */
package ru.testit.services;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;

public class HtmlEscapeUtils {
    private static final String NO_ESCAPE_HTML = System.getenv("NO_ESCAPE_HTML");
    private static final Pattern HTML_TAG_PATTERN = Pattern.compile("<\\S.*[^>]*>");
    private static final Pattern LESS_THAN_PATTERN = Pattern.compile("<");
    private static final Pattern GREATER_THAN_PATTERN = Pattern.compile(">");

    private HtmlEscapeUtils() {
    }

    public static String escapeHtmlTags(String text) {
        if (text == null) {
            return null;
        }
        if (!HTML_TAG_PATTERN.matcher(text).find()) {
            return text;
        }
        String result = LESS_THAN_PATTERN.matcher(text).replaceAll("&lt;");
        result = GREATER_THAN_PATTERN.matcher(result).replaceAll("&gt;");
        return result;
    }

    private static boolean isSimpleType(Class<?> clazz) {
        return clazz.isPrimitive() || clazz.isEnum() || clazz == String.class || clazz == Boolean.class || clazz == Byte.class || clazz == Character.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class || clazz == Float.class || clazz == Double.class || clazz == BigDecimal.class || clazz == BigInteger.class || clazz == Date.class || clazz == LocalDate.class || clazz == LocalDateTime.class || clazz == LocalTime.class || clazz == ZonedDateTime.class || clazz == OffsetDateTime.class || clazz == Instant.class || clazz == Duration.class || clazz == UUID.class || clazz == Optional.class;
    }

    public static <T> T escapeHtmlInObject(T obj) {
        return HtmlEscapeUtils.escapeHtmlInObject(obj, new HashSet<Object>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T escapeHtmlInObject(T obj, Set<Object> visited) {
        if (obj == null) {
            return null;
        }
        if ("true".equalsIgnoreCase(NO_ESCAPE_HTML)) {
            return obj;
        }
        if (!HtmlEscapeUtils.isSimpleType(obj.getClass()) && visited.contains(obj)) {
            return obj;
        }
        try {
            Field[] fields;
            if (!HtmlEscapeUtils.isSimpleType(obj.getClass())) {
                visited.add(obj);
            }
            Class<?> clazz = obj.getClass();
            for (Field field : fields = clazz.getDeclaredFields()) {
                field.setAccessible(true);
                Object value = field.get(obj);
                if (value instanceof String) {
                    field.set(obj, HtmlEscapeUtils.escapeHtmlTags((String)value));
                    continue;
                }
                if (value instanceof List) {
                    field.set(obj, HtmlEscapeUtils.escapeHtmlInObjectList((List)value, visited));
                    continue;
                }
                if (value == null || HtmlEscapeUtils.isSimpleType(value.getClass())) continue;
                HtmlEscapeUtils.escapeHtmlInObject(value, visited);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (!HtmlEscapeUtils.isSimpleType(obj.getClass())) {
                visited.remove(obj);
            }
        }
        return obj;
    }

    public static <T> List<T> escapeHtmlInObjectList(List<T> list) {
        return HtmlEscapeUtils.escapeHtmlInObjectList(list, new HashSet<Object>());
    }

    private static <T> List<T> escapeHtmlInObjectList(List<T> list, Set<Object> visited) {
        block5: {
            T firstElement;
            block4: {
                if (list == null) {
                    return null;
                }
                if ("true".equalsIgnoreCase(NO_ESCAPE_HTML)) {
                    return list;
                }
                firstElement = list.get(0);
                if (!(firstElement instanceof String)) break block4;
                for (int i = 0; i < list.size(); ++i) {
                    T element = list.get(i);
                    if (!(element instanceof String)) continue;
                    list.set(i, HtmlEscapeUtils.escapeHtmlTags((String)element));
                }
                break block5;
            }
            if (firstElement == null) break block5;
            for (T item : list) {
                HtmlEscapeUtils.escapeHtmlInObject(item, visited);
            }
        }
        return list;
    }
}

