/*
 * Decompiled with CFR 0.152.
 */
package ru.testit.writers.helpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.testit.client.invoker.ApiException;
import ru.testit.client.model.AutoTestCreateApiModel;
import ru.testit.client.model.AutoTestResultsForTestRunModel;
import ru.testit.client.model.AutoTestUpdateApiModel;
import ru.testit.client.model.AutoTestWorkItemIdentifierApiResult;
import ru.testit.clients.ClientConfiguration;
import ru.testit.clients.ITmsApiClient;

public class BulkAutotestHelper {
    private final ITmsApiClient apiClient;
    private final ClientConfiguration config;
    private static final int MAX_TESTS_FOR_IMPORT = 100;
    private final List<AutoTestCreateApiModel> autotestsForCreate;
    private final List<AutoTestUpdateApiModel> autotestsForUpdate;
    private final Map<String, List<String>> autotestLinksToWIForUpdate;
    private final List<AutoTestResultsForTestRunModel> resultsForAutotestsBeingCreated;
    private final List<AutoTestResultsForTestRunModel> resultsForAutotestsBeingUpdated;

    public BulkAutotestHelper(ITmsApiClient client, ClientConfiguration configuration) {
        this.config = configuration;
        this.apiClient = client;
        this.autotestsForCreate = new ArrayList<AutoTestCreateApiModel>();
        this.autotestsForUpdate = new ArrayList<AutoTestUpdateApiModel>();
        this.autotestLinksToWIForUpdate = new HashMap<String, List<String>>();
        this.resultsForAutotestsBeingCreated = new ArrayList<AutoTestResultsForTestRunModel>();
        this.resultsForAutotestsBeingUpdated = new ArrayList<AutoTestResultsForTestRunModel>();
    }

    public void addForCreate(AutoTestCreateApiModel createModel, AutoTestResultsForTestRunModel resultModel) throws ApiException {
        this.autotestsForCreate.add(createModel);
        this.resultsForAutotestsBeingCreated.add(resultModel);
        if (this.autotestsForCreate.size() >= 100) {
            this.bulkCreate();
        }
    }

    public void addForUpdate(AutoTestUpdateApiModel updateModel, AutoTestResultsForTestRunModel resultModel, Map<String, List<String>> wiForUpdate) throws ApiException {
        this.autotestsForUpdate.add(updateModel);
        this.resultsForAutotestsBeingUpdated.add(resultModel);
        this.autotestLinksToWIForUpdate.putAll(wiForUpdate);
        if (this.autotestsForUpdate.size() >= 100) {
            this.bulkUpdate();
        }
    }

    public void teardown() throws ApiException {
        if (!this.autotestsForCreate.isEmpty()) {
            this.bulkCreate();
        }
        if (!this.autotestsForUpdate.isEmpty()) {
            this.bulkUpdate();
        }
    }

    private void bulkCreate() throws ApiException {
        this.apiClient.createAutoTests(this.autotestsForCreate);
        this.apiClient.sendTestResults(this.config.getTestRunId(), this.resultsForAutotestsBeingCreated);
        this.autotestsForCreate.clear();
        this.resultsForAutotestsBeingCreated.clear();
    }

    private void bulkUpdate() throws ApiException {
        this.apiClient.updateAutoTests(this.autotestsForUpdate);
        this.apiClient.sendTestResults(this.config.getTestRunId(), this.resultsForAutotestsBeingUpdated);
        this.autotestLinksToWIForUpdate.forEach((autotestId, workItemIds) -> {
            try {
                this.updateTestLinkToWorkItems((String)autotestId, (List<String>)workItemIds);
            }
            catch (ApiException e) {
                throw new RuntimeException(e);
            }
        });
        this.autotestsForUpdate.clear();
        this.resultsForAutotestsBeingUpdated.clear();
    }

    private void updateTestLinkToWorkItems(String autoTestId, List<String> workItemIds) throws ApiException {
        List<AutoTestWorkItemIdentifierApiResult> linkedWorkItems = this.apiClient.getWorkItemsLinkedToTest(autoTestId);
        for (AutoTestWorkItemIdentifierApiResult linkedWorkItem : linkedWorkItems) {
            String linkedWorkItemId = linkedWorkItem.getGlobalId().toString();
            if (workItemIds.contains(linkedWorkItemId)) {
                workItemIds.remove(linkedWorkItemId);
                continue;
            }
            if (!this.config.shouldAutomaticUpdationLinksToTestCases()) continue;
            this.apiClient.unlinkAutoTestToWorkItem(autoTestId, linkedWorkItemId);
        }
        this.apiClient.linkAutoTestToWorkItems(autoTestId, workItemIds);
    }
}

