/*
 * Decompiled with CFR 0.152.
 */
package ru.testit.services;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import ru.testit.models.ClassContainer;
import ru.testit.models.FixtureResult;
import ru.testit.models.MainContainer;
import ru.testit.models.StepResult;
import ru.testit.models.TestResult;

public class ResultStorage {
    private final Map<String, Object> storage = new ConcurrentHashMap<String, Object>();

    public Optional<TestResult> getTestResult(String uuid) {
        return this.get(uuid, TestResult.class);
    }

    public Optional<FixtureResult> getFixture(String uuid) {
        return this.get(uuid, FixtureResult.class);
    }

    public Optional<StepResult> getStep(String uuid) {
        return this.get(uuid, StepResult.class);
    }

    public Optional<MainContainer> getTestsContainer(String uuid) {
        return this.get(uuid, MainContainer.class);
    }

    public Optional<ClassContainer> getClassContainer(String uuid) {
        return this.get(uuid, ClassContainer.class);
    }

    public <T> Optional<T> get(String uuid, Class<T> clazz) {
        Objects.requireNonNull(uuid, "Can't get result from storage: uuid can't be null");
        return Optional.ofNullable(this.storage.get(uuid)).filter(clazz::isInstance).map(clazz::cast);
    }

    public <T> T put(String uuid, T item) {
        Objects.requireNonNull(uuid, "Can't put result to storage: uuid can't be null");
        Objects.requireNonNull(item, "Can't put result to storage: item can't be null");
        this.storage.put(uuid, item);
        return item;
    }

    public void remove(String uuid) {
        Objects.requireNonNull(uuid, "Can't remove item from storage: uuid can't be null");
        this.storage.remove(uuid);
    }

    public <T> void updateIfPresent(String uuid, Class<T> clazz, Consumer<T> update) {
        Objects.requireNonNull(uuid, "Can't update item in storage: uuid can't be null");
        Objects.requireNonNull(clazz, "Can't update item in storage: clazz can't be null");
        Objects.requireNonNull(update, "Can't update item in storage: update can't be null");
        this.storage.computeIfPresent(uuid, (key, value) -> {
            if (!clazz.isInstance(value)) {
                return value;
            }
            Object object = value;
            synchronized (object) {
                update.accept(clazz.cast(value));
            }
            return value;
        });
    }
}

