/*
 * Decompiled with CFR 0.152.
 */
package ru.testit.properties;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppProperties {
    public static final String URL = "url";
    public static final String PRIVATE_TOKEN = "privateToken";
    public static final String PROJECT_ID = "projectId";
    public static final String CONFIGURATION_ID = "configurationId";
    public static final String TEST_RUN_ID = "testRunId";
    public static final String TEST_RUN_NAME = "testRunName";
    public static final String ADAPTER_MODE = "adapterMode";
    public static final String AUTOMATIC_CREATION_TEST_CASES = "automaticCreationTestCases";
    public static final String CERT_VALIDATION = "certValidation";
    public static final String TMS_INTEGRATION = "tmsTestIt";
    private static final String ENV_PREFIX = "TMS";
    private static final String PROPERTIES_FILE = "testit.properties";
    private static final Logger log = LoggerFactory.getLogger(AppProperties.class);

    public static Properties loadProperties() {
        String configFile = AppProperties.getConfigFileName();
        Properties properties = new Properties();
        AppProperties.loadPropertiesFrom(Thread.currentThread().getContextClassLoader(), properties, configFile);
        AppProperties.loadPropertiesFrom(ClassLoader.getSystemClassLoader(), properties, configFile);
        String token = String.valueOf(properties.get(PRIVATE_TOKEN));
        if (token != null && !token.isEmpty() && !token.equals("null")) {
            log.warn("The configuration file specifies a private token. It is not safe. Use TMS_PRIVATE_TOKEN environment variable");
        }
        properties.putAll(AppProperties.loadPropertiesFromEnv());
        return AppProperties.ValidateProperties(properties);
    }

    private static void loadPropertiesFrom(ClassLoader classLoader, Properties properties, String fileName) {
        Properties newProps = new Properties();
        try (InputStream stream = classLoader.getResourceAsStream(fileName);){
            if (stream != null) {
                newProps.load(stream);
                for (String key : newProps.stringPropertyNames()) {
                    String value = newProps.getProperty(key);
                    if (value == null || value.isEmpty()) continue;
                    properties.setProperty(key, value);
                }
            }
        }
        catch (IOException e) {
            log.error("Exception while read properties: {}", (Object)e.getMessage());
        }
    }

    private static Map<String, String> loadPropertiesFromEnv() {
        Comparable<URI> ignored;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String url = System.getenv(String.format("%s_URL", ENV_PREFIX));
            ignored = new URL(url).toURI();
            map.put(URL, url);
        }
        catch (IllegalArgumentException | NullPointerException | SecurityException | MalformedURLException | URISyntaxException url) {
            // empty catch block
        }
        try {
            String token = System.getenv(String.format("%s_PRIVATE_TOKEN", ENV_PREFIX));
            if (token != null && !token.isEmpty() && !token.equals("null")) {
                map.put(PRIVATE_TOKEN, token);
            }
        }
        catch (IllegalArgumentException | NullPointerException | SecurityException token) {
            // empty catch block
        }
        try {
            String projectId = System.getenv(String.format("%s_PROJECT_ID", ENV_PREFIX));
            if (projectId != null && !projectId.isEmpty()) {
                ignored = UUID.fromString(projectId);
                map.put(PROJECT_ID, projectId);
            }
        }
        catch (IllegalArgumentException | NullPointerException | SecurityException projectId) {
            // empty catch block
        }
        try {
            String configurationId = System.getenv(String.format("%s_CONFIGURATION_ID", ENV_PREFIX));
            if (configurationId != null && !configurationId.isEmpty()) {
                ignored = UUID.fromString(configurationId);
                map.put(CONFIGURATION_ID, configurationId);
            }
        }
        catch (IllegalArgumentException | NullPointerException | SecurityException configurationId) {
            // empty catch block
        }
        try {
            String testRunId = System.getenv(String.format("%s_TEST_RUN_ID", ENV_PREFIX));
            if (testRunId != null && !testRunId.isEmpty()) {
                ignored = UUID.fromString(testRunId);
                map.put(TEST_RUN_ID, testRunId);
            }
        }
        catch (IllegalArgumentException | NullPointerException | SecurityException testRunId) {
            // empty catch block
        }
        try {
            String testRunName = System.getenv(String.format("%s_TEST_RUN_NAME", ENV_PREFIX));
            if (testRunName != null && !testRunName.isEmpty() && !testRunName.equals("null")) {
                map.put(TEST_RUN_NAME, testRunName);
            }
        }
        catch (IllegalArgumentException | NullPointerException | SecurityException testRunName) {
            // empty catch block
        }
        try {
            String adapterMode = System.getenv(String.format("%s_ADAPTER_MODE", ENV_PREFIX));
            int mode = Integer.parseInt(adapterMode);
            if (0 <= mode && mode <= 2) {
                map.put(ADAPTER_MODE, adapterMode);
            }
        }
        catch (IllegalArgumentException | NullPointerException | SecurityException adapterMode) {
            // empty catch block
        }
        try {
            String createTestCases = System.getenv(String.format("%s_AUTOMATIC_CREATION_TEST_CASES", ENV_PREFIX));
            if (Objects.equals(createTestCases, "false") || Objects.equals(createTestCases, "true")) {
                map.put(AUTOMATIC_CREATION_TEST_CASES, createTestCases);
            }
        }
        catch (IllegalArgumentException | NullPointerException | SecurityException createTestCases) {
            // empty catch block
        }
        try {
            String certValidation = System.getenv(String.format("%s_CERT_VALIDATION", ENV_PREFIX));
            if (Objects.equals(certValidation, "false") || Objects.equals(certValidation, "true")) {
                map.put(CERT_VALIDATION, certValidation);
            }
        }
        catch (IllegalArgumentException | NullPointerException | SecurityException certValidation) {
            // empty catch block
        }
        try {
            String tmsIntegration = System.getenv(String.format("%s_TEST_IT", ENV_PREFIX));
            if (Objects.equals(tmsIntegration, "false") || Objects.equals(tmsIntegration, "true")) {
                map.put(TMS_INTEGRATION, tmsIntegration);
            }
        }
        catch (IllegalArgumentException | NullPointerException | SecurityException runtimeException) {
            // empty catch block
        }
        return map;
    }

    private static Properties ValidateProperties(Properties properties) {
        String errors;
        String tmsIntegration;
        String certValidation;
        StringBuilder errorsBuilder;
        block16: {
            Object message;
            String message2;
            errorsBuilder = new StringBuilder();
            try {
                String url = properties.getProperty(URL);
                URI uRI = new URL(url).toURI();
            }
            catch (Exception e) {
                message2 = "Invalid url: " + e.getMessage();
                log.error(message2);
                errorsBuilder.append(message2).append(System.lineSeparator());
            }
            String token = properties.getProperty(PRIVATE_TOKEN);
            if (token == null || token.isEmpty() || token.equals("null")) {
                message2 = "Invalid token: " + token;
                log.error(message2);
                errorsBuilder.append(message2).append(System.lineSeparator());
            }
            try {
                String projectId = properties.getProperty(PROJECT_ID);
                UUID uUID = UUID.fromString(projectId);
            }
            catch (Exception e) {
                message = "Invalid projectId: " + e.getMessage();
                log.error((String)message);
                errorsBuilder.append((String)message).append(System.lineSeparator());
            }
            try {
                String configurationId = properties.getProperty(CONFIGURATION_ID);
                message = UUID.fromString(configurationId);
            }
            catch (Exception e) {
                message = "Invalid configurationId: " + e.getMessage();
                log.error((String)message);
                errorsBuilder.append((String)message).append(System.lineSeparator());
            }
            try {
                String adapterMode = properties.getProperty(ADAPTER_MODE);
                int mode = Integer.parseInt(adapterMode);
                if (mode > 2 || mode < 0) {
                    log.warn("Invalid adapterMode: {}. Use default value instead: 0", (Object)mode);
                    properties.setProperty(ADAPTER_MODE, "0");
                }
            }
            catch (Exception e) {
                log.warn("Invalid adapterMode: {}. Use default value instead: 0", (Object)e.getMessage());
                properties.setProperty(ADAPTER_MODE, "0");
            }
            try {
                String testRunId = properties.getProperty(TEST_RUN_ID);
                UUID mode = UUID.fromString(testRunId);
            }
            catch (Exception e) {
                int adapterMode = Integer.parseInt(properties.getProperty(ADAPTER_MODE));
                if (adapterMode != 0 && adapterMode != 1) break block16;
                String message3 = "Invalid testRunId: " + e.getMessage();
                log.error(message3);
                errorsBuilder.append(message3).append(System.lineSeparator());
            }
        }
        String createTestCases = properties.getProperty(AUTOMATIC_CREATION_TEST_CASES);
        if (!Objects.equals(createTestCases, "false") && !Objects.equals(createTestCases, "true")) {
            log.warn("Invalid autoCreateTestCases: {}. Use default value instead: false", (Object)createTestCases);
            properties.setProperty(AUTOMATIC_CREATION_TEST_CASES, "false");
        }
        if (!Objects.equals(certValidation = properties.getProperty(CERT_VALIDATION), "false") && !Objects.equals(certValidation, "true")) {
            log.warn("Invalid certValidation: {}. Use default value instead: true", (Object)certValidation);
            properties.setProperty(CERT_VALIDATION, "true");
        }
        if (!Objects.equals(tmsIntegration = properties.getProperty(TMS_INTEGRATION), "false") && !Objects.equals(tmsIntegration, "true")) {
            log.warn("Invalid tmsIntegration: {}. Use default value instead: true", (Object)tmsIntegration);
            properties.setProperty(TMS_INTEGRATION, "true");
        }
        if (!(errors = errorsBuilder.toString()).isEmpty()) {
            throw new AssertionError((Object)("Invalid configuration provided : " + errors));
        }
        return properties;
    }

    private static String getConfigFileName() {
        try {
            String fileName = System.getProperty(String.format("%s_CONFIG_FILE", ENV_PREFIX));
            if (fileName != null && !fileName.isEmpty() && !fileName.equals("null")) {
                return fileName;
            }
        }
        catch (IllegalArgumentException | NullPointerException | SecurityException runtimeException) {
            // empty catch block
        }
        return PROPERTIES_FILE;
    }
}

