/*
 * Decompiled with CFR 0.152.
 */
package ru.testit.listener;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceLoaderListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceLoaderListener.class);

    private ServiceLoaderListener() {
        throw new IllegalStateException("Do not have instance");
    }

    public static <T> List<T> load(Class<T> type, ClassLoader classLoader) {
        ArrayList<T> loaded = new ArrayList<T>();
        Iterator<T> iterator = ServiceLoader.load(type, classLoader).iterator();
        while (ServiceLoaderListener.nextSafely(iterator)) {
            try {
                T next = iterator.next();
                loaded.add(next);
                LOGGER.debug("Found type {}", type);
            }
            catch (Exception e) {
                LOGGER.error("Could not load listener {}: {}", type, (Object)e);
            }
        }
        return loaded;
    }

    private static boolean nextSafely(Iterator iterator) {
        try {
            return iterator.hasNext();
        }
        catch (Exception e) {
            LOGGER.error("nextSafely failed", (Throwable)e);
            return false;
        }
    }
}

