/*
 * Decompiled with CFR 0.152.
 */
package ru.testit.services;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import ru.testit.models.ClassContainer;
import ru.testit.models.FixtureResult;
import ru.testit.models.MainContainer;
import ru.testit.models.StepResult;
import ru.testit.models.TestResult;

public class ResultStorage {
    private final Map<String, Object> storage = new ConcurrentHashMap<String, Object>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public Optional<TestResult> getTestResult(String uuid) {
        return this.get(uuid, TestResult.class);
    }

    public Optional<FixtureResult> getFixture(String uuid) {
        return this.get(uuid, FixtureResult.class);
    }

    public Optional<StepResult> getStep(String uuid) {
        return this.get(uuid, StepResult.class);
    }

    public Optional<MainContainer> getTestsContainer(String uuid) {
        return this.get(uuid, MainContainer.class);
    }

    public Optional<ClassContainer> getClassContainer(String uuid) {
        return this.get(uuid, ClassContainer.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Optional<T> get(String uuid, Class<T> clazz) {
        this.lock.readLock().lock();
        try {
            Objects.requireNonNull(uuid, "Can't get result from storage: uuid can't be null");
            Optional<Object> optional = Optional.ofNullable(this.storage.get(uuid)).filter(clazz::isInstance).map(clazz::cast);
            return optional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T put(String uuid, T item) {
        this.lock.writeLock().lock();
        try {
            Objects.requireNonNull(uuid, "Can't put result to storage: uuid can't be null");
            Objects.requireNonNull(item, "Can't put result to storage: item can't be null");
            this.storage.put(uuid, item);
            T t = item;
            return t;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void remove(String uuid) {
        this.lock.writeLock().lock();
        try {
            Objects.requireNonNull(uuid, "Can't remove item from storage: uuid can't be null");
            this.storage.remove(uuid);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

