/*
 * Decompiled with CFR 0.152.
 */
package ru.testit.writers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.testit.client.invoker.ApiException;
import ru.testit.client.model.AttachmentPutModelAutoTestStepResultsModel;
import ru.testit.client.model.AutoTestApiResult;
import ru.testit.client.model.AutoTestModel;
import ru.testit.client.model.AutoTestPostModel;
import ru.testit.client.model.AutoTestPutModel;
import ru.testit.client.model.AutoTestResultsForTestRunModel;
import ru.testit.client.model.AutoTestStepModel;
import ru.testit.client.model.TestResultResponse;
import ru.testit.client.model.TestResultUpdateV2Request;
import ru.testit.client.model.WorkItemIdentifierModel;
import ru.testit.clients.ClientConfiguration;
import ru.testit.clients.ITmsApiClient;
import ru.testit.models.ClassContainer;
import ru.testit.models.ItemStatus;
import ru.testit.models.MainContainer;
import ru.testit.models.TestResult;
import ru.testit.services.ResultStorage;
import ru.testit.writers.Converter;
import ru.testit.writers.Writer;

public class HttpWriter
implements Writer {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpWriter.class);
    private final Map<String, UUID> testResults;
    private final ITmsApiClient apiClient;
    private final ResultStorage storage;
    private final ClientConfiguration config;
    private final int maxTestsForWrite = 100;

    public HttpWriter(ClientConfiguration config, ITmsApiClient client, ResultStorage storage) {
        this.config = config;
        this.apiClient = client;
        this.storage = storage;
        this.testResults = new HashMap<String, UUID>();
    }

    @Override
    public void writeTest(TestResult testResult) {
        if (!this.config.shouldImportRealtime()) {
            return;
        }
        this.writeTestRealtime(testResult);
    }

    private void writeTestRealtime(TestResult testResult) {
        try {
            String autoTestId;
            AutoTestApiResult autoTestApiResult;
            AutoTestModel autotest;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Write the auto test {}", (Object)testResult.getExternalId());
            }
            if ((autotest = Converter.convertAutoTestApiResultToAutoTestModel(autoTestApiResult = this.apiClient.getAutoTestByExternalId(testResult.getExternalId()))) != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("The auto test {} is exist", (Object)testResult.getExternalId());
                }
                AutoTestPutModel autoTestPutModel = this.prepareToUpdateAutoTest(testResult, autotest);
                this.apiClient.updateAutoTest(autoTestPutModel);
                autoTestId = autotest.getId().toString();
            } else {
                AutoTestPostModel model = this.prepareToCreateAutoTest(testResult);
                autoTestId = this.apiClient.createAutoTest(model);
            }
            List<String> workItemIds = testResult.getWorkItemIds();
            if (!workItemIds.isEmpty()) {
                this.updateTestLinkToWorkItems(autoTestId, workItemIds);
            }
            AutoTestResultsForTestRunModel autoTestResultsForTestRunModel = this.prepareTestResultForTestRun(testResult);
            ArrayList<AutoTestResultsForTestRunModel> results = new ArrayList<AutoTestResultsForTestRunModel>();
            results.add(autoTestResultsForTestRunModel);
            List<UUID> ids = this.apiClient.sendTestResults(this.config.getTestRunId(), results);
            this.testResults.put(testResult.getUuid(), ids.get(0));
        }
        catch (ApiException e) {
            LOGGER.error("Can not write the autotest: " + e.getMessage());
        }
    }

    private AutoTestPostModel prepareToCreateAutoTest(TestResult testResult) throws ApiException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Preparing to create the auto test {}", (Object)testResult.getExternalId());
        }
        AutoTestPostModel model = Converter.testResultToAutoTestPostModel(testResult);
        model.setProjectId(UUID.fromString(this.config.getProjectId()));
        List<UUID> workItemUuids = this.apiClient.GetWorkItemUuidsByIds(testResult.getWorkItemIds());
        model.setWorkItemIdsForLinkWithAutoTest(new HashSet<UUID>(workItemUuids));
        return model;
    }

    private AutoTestPutModel prepareToUpdateAutoTest(TestResult testResult, AutoTestModel autotest) throws ApiException {
        AutoTestPutModel model;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Preparing to update the auto test {}", (Object)testResult.getExternalId());
        }
        if (testResult.getItemStatus() == ItemStatus.FAILED) {
            model = Converter.autoTestModelToAutoTestPutModel(autotest);
            model.links(Converter.convertPutLinks(testResult.getLinkItems()));
        } else {
            model = Converter.testResultToAutoTestPutModel(testResult);
            model.setProjectId(UUID.fromString(this.config.getProjectId()));
        }
        model.setIsFlaky(autotest.getIsFlaky());
        List<UUID> workItemUuids = this.apiClient.GetWorkItemUuidsByIds(testResult.getWorkItemIds());
        workItemUuids = this.prepareWorkItemUuidsForUpdateAutoTest(workItemUuids, autotest.getId().toString());
        model.setWorkItemIdsForLinkWithAutoTest(new HashSet<UUID>(workItemUuids));
        return model;
    }

    private List<UUID> prepareWorkItemUuidsForUpdateAutoTest(List<UUID> workItemUuids, String autoTestId) throws ApiException {
        List<WorkItemIdentifierModel> linkedWorkItems = this.apiClient.getWorkItemsLinkedToTest(autoTestId);
        for (WorkItemIdentifierModel linkedWorkItem : linkedWorkItems) {
            UUID linkedWorkItemUuid = linkedWorkItem.getId();
            if (workItemUuids.contains(linkedWorkItemUuid) || this.config.shouldAutomaticUpdationLinksToTestCases()) continue;
            workItemUuids.add(linkedWorkItemUuid);
        }
        return workItemUuids;
    }

    private AutoTestResultsForTestRunModel prepareTestResultForTestRun(TestResult testResult) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Preparing the test result for the auto test {}", (Object)testResult.getExternalId());
        }
        AutoTestResultsForTestRunModel model = Converter.testResultToAutoTestResultsForTestRunModel(testResult);
        model.setConfigurationId(UUID.fromString(this.config.getConfigurationId()));
        return model;
    }

    private void updateTestLinkToWorkItems(String autoTestId, List<String> workItemIds) throws ApiException {
        List<WorkItemIdentifierModel> linkedWorkItems = this.apiClient.getWorkItemsLinkedToTest(autoTestId);
        for (WorkItemIdentifierModel linkedWorkItem : linkedWorkItems) {
            String linkedWorkItemId = linkedWorkItem.getGlobalId().toString();
            if (workItemIds.contains(linkedWorkItemId)) {
                workItemIds.remove(linkedWorkItemId);
                continue;
            }
            if (!this.config.shouldAutomaticUpdationLinksToTestCases()) continue;
            this.apiClient.unlinkAutoTestToWorkItem(autoTestId, linkedWorkItemId);
        }
        this.apiClient.linkAutoTestToWorkItems(autoTestId, workItemIds);
    }

    @Override
    public void writeClass(ClassContainer container) {
        if (!this.config.shouldImportRealtime()) {
            return;
        }
        for (String testUuid : container.getChildren()) {
            this.storage.getTestResult(testUuid).ifPresent(test -> {
                try {
                    AutoTestApiResult autoTestApiResult = this.apiClient.getAutoTestByExternalId(test.getExternalId());
                    AutoTestModel autoTestModel = Converter.convertAutoTestApiResultToAutoTestModel(autoTestApiResult);
                    if (autoTestModel == null) {
                        return;
                    }
                    AutoTestPutModel autoTestPutModel = Converter.autoTestModelToAutoTestPutModel(autoTestModel);
                    List<AutoTestStepModel> beforeClass = Converter.convertFixture(container.getBeforeClassMethods(), null);
                    List<AutoTestStepModel> beforeEach = Converter.convertFixture(container.getBeforeEachTest(), testUuid);
                    beforeClass.addAll(beforeEach);
                    List<AutoTestStepModel> afterClass = Converter.convertFixture(container.getAfterClassMethods(), null);
                    List<AutoTestStepModel> afterEach = Converter.convertFixture(container.getAfterEachTest(), testUuid);
                    afterClass.addAll(afterEach);
                    autoTestPutModel.setSetup(beforeClass);
                    autoTestPutModel.setTeardown(afterClass);
                    autoTestPutModel.setIsFlaky(autoTestModel.getIsFlaky());
                    this.apiClient.updateAutoTest(autoTestPutModel);
                }
                catch (ApiException e) {
                    LOGGER.error("Can not write the class: " + e.getMessage());
                }
            });
        }
    }

    @Override
    public void writeTests(MainContainer container) {
        if (this.config.shouldImportRealtime()) {
            this.updateTestResults(container);
            return;
        }
        this.writeTestsAfterAll(container);
    }

    private void updateTestResults(MainContainer container) {
        List<AutoTestStepModel> beforeAll = Converter.convertFixture(container.getBeforeMethods(), null);
        List<AutoTestStepModel> afterAll = Converter.convertFixture(container.getAfterMethods(), null);
        List<AttachmentPutModelAutoTestStepResultsModel> beforeResultAll = Converter.convertResultFixture(container.getBeforeMethods(), null);
        List<AttachmentPutModelAutoTestStepResultsModel> afterResultAll = Converter.convertResultFixture(container.getAfterMethods(), null);
        for (String classUuid : container.getChildren()) {
            this.storage.getClassContainer(classUuid).ifPresent(cl -> {
                List<AutoTestStepModel> afterClass = Converter.convertFixture(cl.getAfterClassMethods(), null);
                List<AttachmentPutModelAutoTestStepResultsModel> beforeResultClass = Converter.convertResultFixture(cl.getBeforeClassMethods(), null);
                List<AttachmentPutModelAutoTestStepResultsModel> afterResultClass = Converter.convertResultFixture(cl.getAfterClassMethods(), null);
                for (String testUuid : cl.getChildren()) {
                    this.storage.getTestResult(testUuid).ifPresent(test -> {
                        try {
                            AutoTestApiResult autoTestApiResult = this.apiClient.getAutoTestByExternalId(test.getExternalId());
                            AutoTestModel autoTestModel = Converter.convertAutoTestApiResultToAutoTestModel(autoTestApiResult);
                            if (autoTestModel == null) {
                                return;
                            }
                            AutoTestPutModel autoTestPutModel = Converter.autoTestModelToAutoTestPutModel(autoTestModel);
                            ArrayList beforeFinish = new ArrayList(beforeAll);
                            beforeFinish.addAll(autoTestPutModel.getSetup());
                            autoTestPutModel.setSetup(beforeFinish);
                            List afterFinish = autoTestPutModel.getTeardown();
                            afterFinish.addAll(afterClass);
                            afterFinish.addAll(afterAll);
                            autoTestPutModel.setTeardown(afterFinish);
                            autoTestPutModel.setIsFlaky(autoTestModel.getIsFlaky());
                            this.apiClient.updateAutoTest(autoTestPutModel);
                            AutoTestResultsForTestRunModel autoTestResultsForTestRunModel = Converter.testResultToAutoTestResultsForTestRunModel(test);
                            List<AttachmentPutModelAutoTestStepResultsModel> beforeResultEach = Converter.convertResultFixture(cl.getBeforeEachTest(), testUuid);
                            ArrayList<AttachmentPutModelAutoTestStepResultsModel> beforeResultFinish = new ArrayList<AttachmentPutModelAutoTestStepResultsModel>();
                            beforeResultFinish.addAll(beforeResultAll);
                            beforeResultFinish.addAll(beforeResultClass);
                            beforeResultFinish.addAll(beforeResultEach);
                            List<AttachmentPutModelAutoTestStepResultsModel> afterResultEach = Converter.convertResultFixture(cl.getAfterEachTest(), testUuid);
                            ArrayList<AttachmentPutModelAutoTestStepResultsModel> afterResultFinish = new ArrayList<AttachmentPutModelAutoTestStepResultsModel>();
                            afterResultFinish.addAll(afterResultEach);
                            afterResultFinish.addAll(afterResultClass);
                            afterResultFinish.addAll(afterResultAll);
                            autoTestResultsForTestRunModel.setSetupResults(beforeResultFinish);
                            autoTestResultsForTestRunModel.setTeardownResults(afterResultFinish);
                            UUID testResultId = this.testResults.get(test.getUuid());
                            TestResultResponse resultModel = this.apiClient.getTestResult(testResultId);
                            TestResultUpdateV2Request model = Converter.testResultToTestResultUpdateModel(resultModel);
                            model.setSetupResults(Converter.stepResultsToRequests(beforeResultFinish));
                            model.setTeardownResults(Converter.stepResultsToRequests(afterResultFinish));
                            this.apiClient.updateTestResult(testResultId, model);
                        }
                        catch (ApiException e) {
                            LOGGER.error("Can not update the autotest: " + e.getMessage());
                        }
                    });
                }
            });
        }
    }

    private void writeTestsAfterAll(MainContainer container) {
        List<AutoTestStepModel> beforeAll = Converter.convertFixture(container.getBeforeMethods(), null);
        List<AutoTestStepModel> afterAll = Converter.convertFixture(container.getAfterMethods(), null);
        List<AttachmentPutModelAutoTestStepResultsModel> beforeResultAll = Converter.convertResultFixture(container.getBeforeMethods(), null);
        List<AttachmentPutModelAutoTestStepResultsModel> afterResultAll = Converter.convertResultFixture(container.getAfterMethods(), null);
        ArrayList<AutoTestPostModel> autotestsForCreate = new ArrayList<AutoTestPostModel>();
        ArrayList<AutoTestPutModel> autotestsForUpdate = new ArrayList<AutoTestPutModel>();
        ArrayList<AutoTestResultsForTestRunModel> resultsForAutotestsBeingCreated = new ArrayList<AutoTestResultsForTestRunModel>();
        ArrayList<AutoTestResultsForTestRunModel> resultsForAutotestsBeingUpdated = new ArrayList<AutoTestResultsForTestRunModel>();
        for (String classUuid : container.getChildren()) {
            this.storage.getClassContainer(classUuid).ifPresent(cl -> {
                List<AutoTestStepModel> beforeClass = Converter.convertFixture(cl.getBeforeClassMethods(), null);
                List<AttachmentPutModelAutoTestStepResultsModel> beforeResultClass = Converter.convertResultFixture(cl.getBeforeClassMethods(), null);
                List<AutoTestStepModel> afterClass = Converter.convertFixture(cl.getAfterClassMethods(), null);
                List<AttachmentPutModelAutoTestStepResultsModel> afterResultClass = Converter.convertResultFixture(cl.getAfterClassMethods(), null);
                for (String testUuid : cl.getChildren()) {
                    this.storage.getTestResult(testUuid).ifPresent(test -> {
                        try {
                            List<AutoTestStepModel> beforeEach = Converter.convertFixture(cl.getBeforeEachTest(), testUuid);
                            List<AttachmentPutModelAutoTestStepResultsModel> beforeResultEach = Converter.convertResultFixture(cl.getBeforeEachTest(), testUuid);
                            ArrayList<AttachmentPutModelAutoTestStepResultsModel> beforeResultFinish = new ArrayList<AttachmentPutModelAutoTestStepResultsModel>();
                            beforeResultFinish.addAll(beforeResultAll);
                            beforeResultFinish.addAll(beforeResultClass);
                            beforeResultFinish.addAll(beforeResultEach);
                            List<AutoTestStepModel> afterEach = Converter.convertFixture(cl.getAfterEachTest(), testUuid);
                            List<AttachmentPutModelAutoTestStepResultsModel> afterResultEach = Converter.convertResultFixture(cl.getAfterEachTest(), testUuid);
                            ArrayList<AttachmentPutModelAutoTestStepResultsModel> afterResultFinish = new ArrayList<AttachmentPutModelAutoTestStepResultsModel>();
                            afterResultFinish.addAll(afterResultEach);
                            afterResultFinish.addAll(afterResultClass);
                            afterResultFinish.addAll(afterResultAll);
                            ArrayList<AutoTestStepModel> beforeFinish = new ArrayList<AutoTestStepModel>();
                            beforeFinish.addAll(beforeAll);
                            beforeFinish.addAll(beforeClass);
                            beforeFinish.addAll(beforeEach);
                            ArrayList<AutoTestStepModel> afterFinish = new ArrayList<AutoTestStepModel>();
                            afterFinish.addAll(afterEach);
                            afterFinish.addAll(afterClass);
                            afterFinish.addAll(afterAll);
                            AutoTestApiResult autoTestApiResult = this.apiClient.getAutoTestByExternalId(test.getExternalId());
                            AutoTestModel autoTestModel = Converter.convertAutoTestApiResultToAutoTestModel(autoTestApiResult);
                            AutoTestResultsForTestRunModel autoTestResultsForTestRunModel = this.prepareTestResultForTestRun((TestResult)test);
                            autoTestResultsForTestRunModel.setSetupResults(beforeResultFinish);
                            autoTestResultsForTestRunModel.setTeardownResults(afterResultFinish);
                            if (autoTestModel == null) {
                                AutoTestPostModel model = this.prepareToCreateAutoTest((TestResult)test);
                                model.setSetup(beforeFinish);
                                model.setTeardown(afterFinish);
                                autotestsForCreate.add(model);
                                resultsForAutotestsBeingCreated.add(autoTestResultsForTestRunModel);
                                if (autotestsForCreate.size() >= 100) {
                                    this.apiClient.createAutoTests(autotestsForCreate);
                                    this.apiClient.sendTestResults(this.config.getTestRunId(), resultsForAutotestsBeingCreated);
                                    autotestsForCreate.clear();
                                    resultsForAutotestsBeingCreated.clear();
                                }
                            } else {
                                AutoTestPutModel model = this.prepareToUpdateAutoTest((TestResult)test, autoTestModel);
                                model.setSetup(beforeFinish);
                                model.setTeardown(afterFinish);
                                autotestsForUpdate.add(model);
                                resultsForAutotestsBeingUpdated.add(autoTestResultsForTestRunModel);
                                if (autotestsForUpdate.size() >= 100) {
                                    this.apiClient.updateAutoTests(autotestsForUpdate);
                                    this.apiClient.sendTestResults(this.config.getTestRunId(), resultsForAutotestsBeingUpdated);
                                    autotestsForUpdate.clear();
                                    resultsForAutotestsBeingUpdated.clear();
                                }
                            }
                        }
                        catch (ApiException e) {
                            LOGGER.error(e.getMessage());
                        }
                    });
                }
            });
        }
        try {
            if (!autotestsForCreate.isEmpty()) {
                this.apiClient.createAutoTests(autotestsForCreate);
                this.apiClient.sendTestResults(this.config.getTestRunId(), resultsForAutotestsBeingCreated);
                autotestsForCreate.clear();
                resultsForAutotestsBeingCreated.clear();
            }
            if (!autotestsForUpdate.isEmpty()) {
                this.apiClient.updateAutoTests(autotestsForUpdate);
                this.apiClient.sendTestResults(this.config.getTestRunId(), resultsForAutotestsBeingUpdated);
                autotestsForUpdate.clear();
                resultsForAutotestsBeingUpdated.clear();
            }
        }
        catch (ApiException e) {
            LOGGER.error(e.getMessage());
        }
    }

    @Override
    public String writeAttachment(String path) {
        try {
            return this.apiClient.addAttachment(path);
        }
        catch (ApiException e) {
            LOGGER.error("Can not write attachment: " + e.getMessage());
            return "";
        }
    }

    void addUuid(String key, UUID uuid) {
        this.testResults.put(key, uuid);
    }
}

