/*
 * Decompiled with CFR 0.152.
 */
package ru.testit.writers;

import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import ru.testit.client.model.AttachmentApiResult;
import ru.testit.client.model.AttachmentPutModel;
import ru.testit.client.model.AttachmentPutModelAutoTestStepResultsModel;
import ru.testit.client.model.AttachmentUpdateRequest;
import ru.testit.client.model.AutoTestApiResult;
import ru.testit.client.model.AutoTestModel;
import ru.testit.client.model.AutoTestPostModel;
import ru.testit.client.model.AutoTestPutModel;
import ru.testit.client.model.AutoTestResultsForTestRunModel;
import ru.testit.client.model.AutoTestStepApiResult;
import ru.testit.client.model.AutoTestStepModel;
import ru.testit.client.model.AutoTestStepResultUpdateRequest;
import ru.testit.client.model.AvailableTestResultOutcome;
import ru.testit.client.model.LabelApiResult;
import ru.testit.client.model.LabelPostModel;
import ru.testit.client.model.LabelShortModel;
import ru.testit.client.model.LinkApiResult;
import ru.testit.client.model.LinkPostModel;
import ru.testit.client.model.LinkPutModel;
import ru.testit.client.model.LinkType;
import ru.testit.client.model.TestResultResponse;
import ru.testit.client.model.TestResultUpdateV2Request;
import ru.testit.models.FixtureResult;
import ru.testit.models.Label;
import ru.testit.models.LinkItem;
import ru.testit.models.StepResult;
import ru.testit.models.TestResult;

public class Converter {
    public static AutoTestPostModel testResultToAutoTestPostModel(TestResult result) {
        AutoTestPostModel model = new AutoTestPostModel();
        model.setExternalId(result.getExternalId());
        model.setDescription(result.getDescription());
        model.setName(result.getName());
        model.setClassname(result.getClassName());
        model.setNamespace(result.getSpaceName());
        model.setTitle(result.getTitle());
        model.setLinks(Converter.convertPostLinks(result.getLinkItems()));
        model.setSteps(Converter.convertSteps(result.getSteps()));
        model.setLabels(Converter.labelsPostConvert(result.getLabels()));
        model.shouldCreateWorkItem(Boolean.valueOf(result.getAutomaticCreationTestCases()));
        model.externalKey(result.getExternalKey());
        return model;
    }

    public static List<AutoTestStepModel> convertFixture(List<FixtureResult> fixtures, String parentUuid) {
        return fixtures.stream().filter(fixture -> Converter.filterSteps(parentUuid, fixture)).map(fixture -> {
            AutoTestStepModel model = new AutoTestStepModel();
            model.setTitle(fixture.getName());
            model.setDescription(fixture.getDescription());
            model.setSteps(Converter.convertSteps(fixture.getSteps()));
            return model;
        }).collect(Collectors.toList());
    }

    private static boolean filterSteps(String parentUuid, FixtureResult f) {
        if (f == null) {
            return false;
        }
        if (parentUuid != null && Objects.equals(f.getParent(), parentUuid)) {
            return true;
        }
        return parentUuid == null || Objects.equals(f.getParent(), parentUuid);
    }

    public static AutoTestResultsForTestRunModel testResultToAutoTestResultsForTestRunModel(TestResult result) {
        AutoTestResultsForTestRunModel model = new AutoTestResultsForTestRunModel();
        model.setLinks(Converter.convertPostLinks(result.getResultLinks()));
        model.setAutoTestExternalId(result.getExternalId());
        model.setStartedOn(Converter.dateToOffsetDateTime(result.getStart()));
        model.setCompletedOn(Converter.dateToOffsetDateTime(result.getStop()));
        model.setDuration(Long.valueOf(result.getStop() - result.getStart()));
        model.setOutcome(AvailableTestResultOutcome.fromValue((String)result.getItemStatus().value()));
        model.setStepResults(Converter.convertResultStep(result.getSteps()));
        model.attachments(Converter.convertAttachments(result.getAttachments()));
        model.setMessage(result.getMessage());
        model.setParameters(result.getParameters());
        Throwable throwable = result.getThrowable();
        if (throwable != null) {
            model.setMessage(throwable.getMessage());
            model.setTraces(ExceptionUtils.getStackTrace((Throwable)throwable));
        }
        return model;
    }

    public static List<AttachmentPutModelAutoTestStepResultsModel> convertResultFixture(List<FixtureResult> fixtures, String parentUuid) {
        return fixtures.stream().filter(f -> Converter.filterSteps(parentUuid, f)).map(fixture -> {
            AttachmentPutModelAutoTestStepResultsModel model = new AttachmentPutModelAutoTestStepResultsModel();
            model.setTitle(fixture.getName());
            model.setDescription(fixture.getDescription());
            model.setStartedOn(Converter.dateToOffsetDateTime(fixture.getStart()));
            model.setCompletedOn(Converter.dateToOffsetDateTime(fixture.getStop()));
            model.setDuration(Long.valueOf(fixture.getStop() - fixture.getStart()));
            model.setOutcome(AvailableTestResultOutcome.fromValue((String)fixture.getItemStatus().value()));
            model.setStepResults(Converter.convertResultStep(fixture.getSteps()));
            model.attachments(Converter.convertAttachments(fixture.getAttachments()));
            model.parameters(fixture.getParameters());
            return model;
        }).collect(Collectors.toList());
    }

    public static TestResultUpdateV2Request testResultToTestResultUpdateModel(TestResultResponse result) {
        TestResultUpdateV2Request model = new TestResultUpdateV2Request();
        model.setDuration(result.getDurationInMs());
        model.setOutcome(result.getOutcome());
        model.setLinks(result.getLinks());
        model.setStepResults(result.getStepResults());
        model.setFailureClassIds(result.getFailureClassIds());
        model.setComment(result.getComment());
        if (result.getAttachments() != null) {
            model.setAttachments(Converter.convertAttachmentsFromModel(result.getAttachments()));
        }
        return model;
    }

    public static AutoTestPutModel testResultToAutoTestPutModel(TestResult result) {
        AutoTestPutModel model = new AutoTestPutModel();
        model.setExternalId(result.getExternalId());
        model.setDescription(result.getDescription());
        model.setName(result.getName());
        model.setClassname(result.getClassName());
        model.setNamespace(result.getSpaceName());
        model.setTitle(result.getTitle());
        model.setLinks(Converter.convertPutLinks(result.getLinkItems()));
        model.setSteps(Converter.convertSteps(result.getSteps()));
        model.setLabels(Converter.labelsPostConvert(result.getLabels()));
        model.setSetup(new ArrayList());
        model.setTeardown(new ArrayList());
        model.externalKey(result.getExternalKey());
        return model;
    }

    public static AutoTestPutModel autoTestModelToAutoTestPutModel(AutoTestModel autoTestModel) {
        AutoTestPutModel model = new AutoTestPutModel();
        model.setId(autoTestModel.getId());
        model.setExternalId(autoTestModel.getExternalId());
        model.setLinks(autoTestModel.getLinks());
        model.setProjectId(autoTestModel.getProjectId());
        model.setName(autoTestModel.getName());
        model.setNamespace(autoTestModel.getNamespace());
        model.setClassname(autoTestModel.getClassname());
        model.setSteps(autoTestModel.getSteps());
        model.setSetup(autoTestModel.getSetup());
        model.setTeardown(autoTestModel.getTeardown());
        model.setTitle(autoTestModel.getTitle());
        model.setDescription(autoTestModel.getDescription());
        model.setLabels(Converter.labelsConvert(autoTestModel.getLabels()));
        model.externalKey(autoTestModel.getExternalKey());
        return model;
    }

    public static Map<String, List<String>> getRelationWorkItemIdsToAutotestIdsByExternalIds(Map<String, List<String>> relationWorkItemIdsToAutotestExternalIdsBeingCreated, List<AutoTestModel> autoTestModels) {
        HashMap<String, List<String>> relationWorkItemIdsToAutotestIds = new HashMap<String, List<String>>();
        Set<String> externalIds = relationWorkItemIdsToAutotestExternalIdsBeingCreated.keySet();
        for (String externalId : externalIds) {
            AutoTestModel autotest = autoTestModels.stream().filter(m -> m.getExternalId().equals(externalId)).findFirst().orElse(null);
            if (autotest == null) continue;
            relationWorkItemIdsToAutotestIds.put(autotest.getId().toString(), relationWorkItemIdsToAutotestExternalIdsBeingCreated.get(externalId));
        }
        return relationWorkItemIdsToAutotestIds;
    }

    private static List<LinkPostModel> convertPostLinks(List<LinkItem> links) {
        return links.stream().map(link -> {
            LinkPostModel model = new LinkPostModel();
            model.setTitle(link.getTitle());
            model.setDescription(link.getDescription());
            model.setUrl(link.getUrl());
            model.setType(LinkType.fromValue((String)link.getType().getValue()));
            return model;
        }).collect(Collectors.toList());
    }

    public static List<LinkPutModel> convertPutLinks(List<LinkItem> links) {
        return links.stream().map(link -> {
            LinkPutModel model = new LinkPutModel();
            model.setTitle(link.getTitle());
            model.setDescription(link.getDescription());
            model.setUrl(link.getUrl());
            model.setType(LinkType.fromValue((String)link.getType().getValue()));
            return model;
        }).collect(Collectors.toList());
    }

    private static List<AutoTestStepModel> convertSteps(List<StepResult> steps) {
        return steps.stream().map(step -> {
            AutoTestStepModel model = new AutoTestStepModel();
            model.setTitle(step.getName());
            model.setDescription(step.getDescription());
            model.setSteps(Converter.convertSteps(step.getSteps()));
            return model;
        }).collect(Collectors.toList());
    }

    private static List<AttachmentPutModelAutoTestStepResultsModel> convertResultStep(List<StepResult> steps) {
        return steps.stream().map(step -> {
            AttachmentPutModelAutoTestStepResultsModel model = new AttachmentPutModelAutoTestStepResultsModel();
            model.setTitle(step.getName());
            model.setDescription(step.getDescription());
            model.setStartedOn(Converter.dateToOffsetDateTime(step.getStart()));
            model.setCompletedOn(Converter.dateToOffsetDateTime(step.getStop()));
            model.setDuration(Long.valueOf(step.getStop() - step.getStart()));
            model.setOutcome(AvailableTestResultOutcome.fromValue((String)step.getItemStatus().value()));
            model.setStepResults(Converter.convertResultStep(step.getSteps()));
            model.attachments(Converter.convertAttachments(step.getAttachments()));
            model.parameters(step.getParameters());
            return model;
        }).collect(Collectors.toList());
    }

    private static List<LabelPostModel> labelsConvert(List<LabelShortModel> labels) {
        return labels.stream().map(label -> {
            LabelPostModel model = new LabelPostModel();
            model.setName(label.getName());
            return model;
        }).collect(Collectors.toList());
    }

    private static List<LabelPostModel> labelsPostConvert(List<Label> labels) {
        return labels.stream().map(label -> {
            LabelPostModel model = new LabelPostModel();
            model.setName(label.getName());
            return model;
        }).collect(Collectors.toList());
    }

    private static OffsetDateTime dateToOffsetDateTime(Long time) {
        if (time == null) {
            return null;
        }
        Date date = new Date(time);
        return date.toInstant().atOffset(ZoneOffset.UTC);
    }

    private static List<AttachmentPutModel> convertAttachments(List<String> uuids) {
        return uuids.stream().map(attach -> {
            AttachmentPutModel model = new AttachmentPutModel();
            model.setId(UUID.fromString(attach));
            return model;
        }).collect(Collectors.toList());
    }

    private static List<AttachmentUpdateRequest> convertAttachmentsFromModel(List<AttachmentApiResult> models) {
        return models.stream().map(attach -> {
            AttachmentUpdateRequest model = new AttachmentUpdateRequest();
            model.setId(attach.getId());
            return model;
        }).collect(Collectors.toList());
    }

    public static AutoTestModel convertAutoTestApiResultToAutoTestModel(AutoTestApiResult autoTestApiResult) {
        if (autoTestApiResult == null || autoTestApiResult.getExternalId() == null) {
            return null;
        }
        AutoTestModel model = new AutoTestModel();
        model.setId(autoTestApiResult.getId());
        model.setExternalId(autoTestApiResult.getExternalId());
        model.setLinks(Converter.convertLinkApiResultsToPutLinks(autoTestApiResult.getLinks()));
        model.setProjectId(autoTestApiResult.getProjectId());
        model.setName(autoTestApiResult.getName());
        model.setNamespace(autoTestApiResult.getNamespace());
        model.setClassname(autoTestApiResult.getClassname());
        model.setSteps(Converter.convertAutoTestStepApiResultsToSteps(autoTestApiResult.getSteps()));
        model.setSetup(Converter.convertAutoTestStepApiResultsToSteps(autoTestApiResult.getSetup()));
        model.setTeardown(Converter.convertAutoTestStepApiResultsToSteps(autoTestApiResult.getTeardown()));
        model.setTitle(autoTestApiResult.getTitle());
        model.setDescription(autoTestApiResult.getDescription());
        model.setLabels(Converter.convertLabelApiResultsToLabelShortModels(autoTestApiResult.getLabels()));
        model.externalKey(autoTestApiResult.getExternalKey());
        return model;
    }

    private static List<AutoTestStepModel> convertAutoTestStepApiResultsToSteps(List<AutoTestStepApiResult> steps) {
        if (steps == null) {
            return new ArrayList<AutoTestStepModel>();
        }
        return steps.stream().map(step -> {
            AutoTestStepModel model = new AutoTestStepModel();
            model.setTitle(step.getTitle());
            model.setDescription(step.getDescription());
            if (step.getSteps() != null) {
                model.setSteps(Converter.convertAutoTestStepApiResultsToSteps(step.getSteps()));
            }
            return model;
        }).collect(Collectors.toList());
    }

    public static List<LinkPutModel> convertLinkApiResultsToPutLinks(List<LinkApiResult> links) {
        if (links == null) {
            return new ArrayList<LinkPutModel>();
        }
        return links.stream().map(link -> {
            LinkPutModel model = new LinkPutModel();
            model.setTitle(link.getTitle());
            model.setDescription(link.getDescription());
            model.setUrl(link.getUrl());
            if (link.getType() != null) {
                model.setType(LinkType.fromValue((String)link.getType().getValue()));
            }
            return model;
        }).collect(Collectors.toList());
    }

    private static List<LabelShortModel> convertLabelApiResultsToLabelShortModels(List<LabelApiResult> labels) {
        if (labels == null) {
            return new ArrayList<LabelShortModel>();
        }
        return labels.stream().map(label -> {
            LabelShortModel model = new LabelShortModel();
            model.setName(label.getName());
            return model;
        }).collect(Collectors.toList());
    }

    public static AutoTestStepResultUpdateRequest stepResultToRequest(AttachmentPutModelAutoTestStepResultsModel model) {
        AutoTestStepResultUpdateRequest req = new AutoTestStepResultUpdateRequest();
        req.setTitle(model.getTitle());
        req.setDescription(model.getDescription());
        req.setInfo(model.getInfo());
        req.setStartedOn(model.getStartedOn());
        req.setCompletedOn(model.getCompletedOn());
        req.setDuration(model.getDuration());
        req.setOutcome(model.getOutcome());
        req.setStepResults(Converter.stepResultsToRequests(model.getStepResults()));
        req.setAttachments(Converter.attachmentsToRequests(model.getAttachments()));
        req.setParameters(model.getParameters());
        return req;
    }

    public static List<AutoTestStepResultUpdateRequest> stepResultsToRequests(List<AttachmentPutModelAutoTestStepResultsModel> models) {
        if (models == null) {
            return null;
        }
        return models.stream().map(Converter::stepResultToRequest).collect(Collectors.toList());
    }

    public static AttachmentUpdateRequest attachmentToRequest(AttachmentPutModel model) {
        AttachmentUpdateRequest req = new AttachmentUpdateRequest();
        req.setId(model.getId());
        return req;
    }

    public static List<AttachmentUpdateRequest> attachmentsToRequests(List<AttachmentPutModel> models) {
        if (models == null) {
            return null;
        }
        return models.stream().map(Converter::attachmentToRequest).collect(Collectors.toList());
    }
}

