/*
 * Decompiled with CFR 0.152.
 */
package ru.testit.aspects;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.UUID;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import ru.testit.models.ItemStatus;
import ru.testit.models.StepResult;
import ru.testit.services.Adapter;
import ru.testit.services.AdapterManager;
import ru.testit.services.Utils;

@Aspect
public class StepAspect {
    private static final InheritableThreadLocal<AdapterManager> adapterManager = new InheritableThreadLocal<AdapterManager>(){

        @Override
        protected AdapterManager initialValue() {
            return Adapter.getAdapterManager();
        }
    };

    @Pointcut(value="@annotation(ru.testit.annotations.Step)")
    public void withStepAnnotation() {
    }

    @Pointcut(value="execution(* *(..))")
    public void anyMethod() {
    }

    @Before(value="anyMethod() && withStepAnnotation()")
    public void startStep(JoinPoint joinPoint) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String uuid = UUID.randomUUID().toString();
        Method method = signature.getMethod();
        Parameter[] parameters = method.getParameters();
        HashMap<String, String> stepParameters = new HashMap<String, String>();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            String name = parameter.getName();
            String value = joinPoint.getArgs()[i] != null ? joinPoint.getArgs()[i].toString() : "";
            stepParameters.put(name, value);
        }
        StepResult result = new StepResult().setName(Utils.extractTitle(method, stepParameters, false)).setDescription(Utils.extractDescription(method, stepParameters)).setParameters(stepParameters);
        this.getManager().startStep(uuid, result);
    }

    @AfterReturning(value="anyMethod() && withStepAnnotation()")
    public void finishStep() {
        this.getManager().updateStep(s -> s.setItemStatus(ItemStatus.PASSED));
        this.getManager().stopStep();
    }

    @AfterThrowing(value="anyMethod() && withStepAnnotation()", throwing="throwable")
    public void failedStep(Throwable throwable) {
        this.getManager().updateStep(s -> s.setItemStatus(ItemStatus.FAILED).setThrowable(throwable));
        this.getManager().stopStep();
    }

    private AdapterManager getManager() {
        return (AdapterManager)adapterManager.get();
    }
}

