/*
 * Decompiled with CFR 0.152.
 */
package ru.testit.clients;

import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.testit.client.api.AttachmentsApi;
import ru.testit.client.api.AutoTestsApi;
import ru.testit.client.api.TestResultsApi;
import ru.testit.client.api.TestRunsApi;
import ru.testit.client.api.WorkItemsApi;
import ru.testit.client.invoker.ApiException;
import ru.testit.client.model.AttachmentModel;
import ru.testit.client.model.AutoTestApiResult;
import ru.testit.client.model.AutoTestFilterApiModel;
import ru.testit.client.model.AutoTestModel;
import ru.testit.client.model.AutoTestPostModel;
import ru.testit.client.model.AutoTestPutModel;
import ru.testit.client.model.AutoTestResultsForTestRunModel;
import ru.testit.client.model.AutoTestSearchApiModel;
import ru.testit.client.model.AutoTestSearchIncludeApiModel;
import ru.testit.client.model.CreateEmptyTestRunApiModel;
import ru.testit.client.model.TestResultResponse;
import ru.testit.client.model.TestResultUpdateV2Request;
import ru.testit.client.model.TestRunV2ApiResult;
import ru.testit.client.model.WorkItemIdModel;
import ru.testit.client.model.WorkItemIdentifierModel;
import ru.testit.client.model.WorkItemModel;
import ru.testit.clients.ApiClient;
import ru.testit.clients.ClientConfiguration;
import ru.testit.services.HtmlEscapeUtils;

public class TmsApiClient
implements ApiClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmsApiClient.class);
    private static final String AUTH_PREFIX = "PrivateToken";
    private static final boolean INCLUDE_STEPS = true;
    private static final boolean INCLUDE_LABELS = true;
    private static final boolean INCLUDE_LINKS = true;
    private static final int MAX_TRIES = 10;
    private static final int WAITING_TIME = 100;
    private final TestRunsApi testRunsApi;
    private final AutoTestsApi autoTestsApi;
    private final AttachmentsApi attachmentsApi;
    private final TestResultsApi testResultsApi;
    private final WorkItemsApi workItemsApi;
    private final ClientConfiguration clientConfiguration;

    public TmsApiClient(ClientConfiguration config) {
        ru.testit.client.invoker.ApiClient apiClient = new ru.testit.client.invoker.ApiClient();
        apiClient.setBasePath(config.getUrl());
        apiClient.setApiKeyPrefix(AUTH_PREFIX);
        apiClient.setApiKey(config.getPrivateToken());
        apiClient.setVerifyingSsl(config.getCertValidation().booleanValue());
        this.clientConfiguration = config;
        this.testRunsApi = new TestRunsApi(apiClient);
        this.autoTestsApi = new AutoTestsApi(apiClient);
        this.attachmentsApi = new AttachmentsApi(apiClient);
        this.testResultsApi = new TestResultsApi(apiClient);
        this.workItemsApi = new WorkItemsApi(apiClient);
    }

    @Override
    public TestRunV2ApiResult createTestRun() throws ApiException {
        CreateEmptyTestRunApiModel model = new CreateEmptyTestRunApiModel();
        model.setProjectId(UUID.fromString(this.clientConfiguration.getProjectId()));
        if (!Objects.equals(this.clientConfiguration.getTestRunName(), "null")) {
            model.setName(HtmlEscapeUtils.escapeHtmlTags(this.clientConfiguration.getTestRunName()));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Create new test run: {}", (Object)model);
        }
        TestRunV2ApiResult response = this.testRunsApi.createEmpty(model);
        this.testRunsApi.startTestRun(response.getId());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("The test run created: {}", (Object)response);
        }
        return response;
    }

    @Override
    public TestRunV2ApiResult getTestRun(String uuid) throws ApiException {
        return this.testRunsApi.getTestRunById(UUID.fromString(uuid));
    }

    @Override
    public void completeTestRun(String uuid) throws ApiException {
        this.testRunsApi.completeTestRun(UUID.fromString(uuid));
    }

    @Override
    public void updateAutoTest(AutoTestPutModel model) throws ApiException {
        HtmlEscapeUtils.escapeHtmlInObject(model);
        this.autoTestsApi.updateAutoTest(model);
    }

    @Override
    public String createAutoTest(AutoTestPostModel model) throws ApiException {
        HtmlEscapeUtils.escapeHtmlInObject(model);
        return Objects.requireNonNull(this.autoTestsApi.createAutoTest(model).getId()).toString();
    }

    @Override
    public void updateAutoTests(List<AutoTestPutModel> models) throws ApiException {
        for (AutoTestPutModel model : models) {
            HtmlEscapeUtils.escapeHtmlInObject(model);
        }
        this.autoTestsApi.updateMultiple(models);
    }

    @Override
    public List<AutoTestModel> createAutoTests(List<AutoTestPostModel> models) throws ApiException {
        for (AutoTestPostModel model : models) {
            HtmlEscapeUtils.escapeHtmlInObject(model);
        }
        return this.autoTestsApi.createMultiple(models);
    }

    @Override
    public List<UUID> GetWorkItemUuidsByIds(Iterable<String> workItemIds) {
        ArrayList<UUID> workItemUuids = new ArrayList<UUID>();
        for (String workItemId : workItemIds) {
            try {
                WorkItemModel workItem = this.workItemsApi.getWorkItemById(workItemId, null, null);
                workItemUuids.add(workItem.getId());
            }
            catch (ApiException e) {
                LOGGER.error("Cannot get work item by id {}" + e.getMessage(), (Object)workItemId);
            }
        }
        return workItemUuids;
    }

    @Override
    public AutoTestApiResult getAutoTestByExternalId(String externalId) throws ApiException {
        AutoTestFilterApiModel filter = new AutoTestFilterApiModel();
        HashSet<UUID> projectIds = new HashSet<UUID>();
        projectIds.add(UUID.fromString(this.clientConfiguration.getProjectId()));
        filter.setProjectIds(projectIds);
        filter.setIsDeleted(Boolean.valueOf(false));
        HashSet<String> externalIds = new HashSet<String>();
        externalIds.add(externalId);
        filter.externalIds(externalIds);
        AutoTestSearchIncludeApiModel includes = new AutoTestSearchIncludeApiModel();
        includes.setIncludeLabels(Boolean.valueOf(true));
        includes.setIncludeSteps(Boolean.valueOf(true));
        includes.setIncludeLinks(Boolean.valueOf(true));
        AutoTestSearchApiModel model = new AutoTestSearchApiModel();
        model.setFilter(filter);
        model.setIncludes(includes);
        List tests = this.autoTestsApi.apiV2AutoTestsSearchPost(null, null, null, null, null, model);
        if ((long)tests.size() == 0L) {
            return null;
        }
        return (AutoTestApiResult)tests.get(0);
    }

    @Override
    public void linkAutoTestToWorkItems(String id, Iterable<String> workItemIds) {
        block4: for (String workItemId : workItemIds) {
            LOGGER.debug("Link autotest {} to workitem {}", (Object)id, (Object)workItemId);
            for (int attempts = 0; attempts < 10; ++attempts) {
                try {
                    this.autoTestsApi.linkAutoTestToWorkItem(id, new WorkItemIdModel().id(workItemId));
                    LOGGER.debug("Link autotest {} to workitem {} is successfully", (Object)id, (Object)workItemId);
                    attempts = 10;
                    continue;
                }
                catch (ApiException e) {
                    LOGGER.error("Cannot link autotest {} to work item {}", (Object)id, (Object)workItemId);
                    try {
                        Thread.sleep(Duration.ofMillis(100L).toMillis());
                        continue;
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        continue block4;
                    }
                }
            }
        }
    }

    @Override
    public void unlinkAutoTestToWorkItem(String id, String workItemId) {
        LOGGER.debug("Unlink autotest {} from workitem {}", (Object)id, (Object)workItemId);
        for (int attempts = 0; attempts < 10; ++attempts) {
            try {
                this.autoTestsApi.deleteAutoTestLinkFromWorkItem(id, workItemId);
                LOGGER.debug("Unlink autotest {} from workitem {} is successfully", (Object)id, (Object)workItemId);
                return;
            }
            catch (ApiException e) {
                LOGGER.error("Cannot unlink autotest {} from work item {}", (Object)id, (Object)workItemId);
                try {
                    Thread.sleep(Duration.ofMillis(100L).toMillis());
                    continue;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
    }

    @Override
    public List<WorkItemIdentifierModel> getWorkItemsLinkedToTest(String id) throws ApiException {
        return this.autoTestsApi.getWorkItemsLinkedToAutoTest(id, Boolean.valueOf(false), Boolean.valueOf(false));
    }

    @Override
    public List<UUID> sendTestResults(String testRunUuid, List<AutoTestResultsForTestRunModel> models) throws ApiException {
        HtmlEscapeUtils.escapeHtmlInObjectList(models);
        return this.testRunsApi.setAutoTestResultsForTestRun(UUID.fromString(testRunUuid), models);
    }

    @Override
    public String addAttachment(String path) throws ApiException {
        File file = new File(path);
        AttachmentModel model = this.attachmentsApi.apiV2AttachmentsPost(file);
        return model.getId().toString();
    }

    @Override
    public List<String> getTestFromTestRun(String testRunUuid, String configurationId) throws ApiException {
        TestRunV2ApiResult model = this.testRunsApi.getTestRunById(UUID.fromString(testRunUuid));
        UUID configUUID = UUID.fromString(configurationId);
        if (Objects.requireNonNull(model.getTestResults()).isEmpty()) {
            return new ArrayList<String>();
        }
        return model.getTestResults().stream().filter(result -> Objects.equals(result.getConfigurationId(), configUUID)).map(result -> Objects.requireNonNull(result.getAutoTest()).getExternalId()).collect(Collectors.toList());
    }

    @Override
    public TestResultResponse getTestResult(UUID uuid) throws ApiException {
        return this.testResultsApi.apiV2TestResultsIdGet(uuid);
    }

    @Override
    public void updateTestResult(UUID uuid, TestResultUpdateV2Request model) throws ApiException {
        HtmlEscapeUtils.escapeHtmlInObject(model);
        this.testResultsApi.apiV2TestResultsIdPut(uuid, model);
    }
}

