/*
 * Decompiled with CFR 0.152.
 */
package software.sava.solana.programs.clients;

import java.util.List;
import java.util.SequencedCollection;
import java.util.concurrent.CompletableFuture;
import software.sava.core.accounts.AccountWithSeed;
import software.sava.core.accounts.ProgramDerivedAddress;
import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.SolanaAccounts;
import software.sava.core.accounts.lookup.AddressLookupTable;
import software.sava.core.accounts.meta.AccountMeta;
import software.sava.core.accounts.meta.LookupTableAccountMeta;
import software.sava.core.accounts.token.TokenAccount;
import software.sava.core.tx.Instruction;
import software.sava.core.tx.Transaction;
import software.sava.rpc.json.http.client.SolanaRpcClient;
import software.sava.rpc.json.http.response.AccountInfo;
import software.sava.solana.programs.address_lookup_table.AddressLookupTableProgram;
import software.sava.solana.programs.clients.NativeProgramAccountClient;
import software.sava.solana.programs.clients.NativeProgramClient;
import software.sava.solana.programs.compute_budget.ComputeBudgetProgram;
import software.sava.solana.programs.stake.StakeAccount;
import software.sava.solana.programs.stake.StakeAuthorize;
import software.sava.solana.programs.stake.StakeState;
import software.sava.solana.programs.system.SystemProgram;
import software.sava.solana.programs.token.AssociatedTokenProgram;
import software.sava.solana.programs.token.TokenProgram;

final class NativeProgramAccountClientImpl
implements NativeProgramAccountClient {
    private final SolanaAccounts solanaAccounts;
    private final NativeProgramClient nativeProgramClient;
    private final PublicKey owner;
    private final AccountMeta feePayer;
    private final PublicKey feePayerPublicKey;
    private final ProgramDerivedAddress wrappedSolPDA;

    NativeProgramAccountClientImpl(NativeProgramClient nativeProgramClient, PublicKey owner, AccountMeta feePayer) {
        this.solanaAccounts = nativeProgramClient.accounts();
        this.nativeProgramClient = nativeProgramClient;
        this.owner = owner;
        this.feePayer = feePayer;
        this.feePayerPublicKey = feePayer.publicKey();
        this.wrappedSolPDA = this.findATA(this.solanaAccounts.wrappedSolTokenMint());
    }

    @Override
    public PublicKey ownerPublicKey() {
        return this.owner;
    }

    @Override
    public AccountMeta feePayer() {
        return this.feePayer;
    }

    @Override
    public SolanaAccounts solanaAccounts() {
        return this.solanaAccounts;
    }

    @Override
    public ProgramDerivedAddress wrappedSolPDA() {
        return this.wrappedSolPDA;
    }

    @Override
    public NativeProgramClient nativeProgramClient() {
        return this.nativeProgramClient;
    }

    @Override
    public Transaction createTransaction(PublicKey feePayer, int computeUnitLimit, long microLamportComputeUnitPrice, Instruction instruction) {
        return Transaction.createTx((PublicKey)feePayer, List.of(this.nativeProgramClient.computeUnitLimit(computeUnitLimit + ComputeBudgetProgram.COMPUTE_UNITS_CONSUMED), this.nativeProgramClient.computeUnitPrice(microLamportComputeUnitPrice), instruction));
    }

    @Override
    public Transaction createTransaction(AccountMeta feePayer, int computeUnitLimit, long microLamportComputeUnitPrice, Instruction instruction) {
        return Transaction.createTx((AccountMeta)feePayer, List.of(this.nativeProgramClient.computeUnitLimit(computeUnitLimit + ComputeBudgetProgram.COMPUTE_UNITS_CONSUMED), this.nativeProgramClient.computeUnitPrice(microLamportComputeUnitPrice), instruction));
    }

    @Override
    public Transaction createTransaction(Instruction instruction) {
        return Transaction.createTx((AccountMeta)this.feePayer, (Instruction)instruction);
    }

    @Override
    public Transaction createTransaction(List<Instruction> instructions) {
        return Transaction.createTx((AccountMeta)this.feePayer, instructions);
    }

    @Override
    public Transaction createTransaction(int computeUnitLimit, long microLamportComputeUnitPrice, Instruction instruction) {
        return this.createTransaction(this.feePayer, computeUnitLimit, microLamportComputeUnitPrice, instruction);
    }

    @Override
    public Transaction createTransaction(int computeUnitLimit, long microLamportComputeUnitPrice, List<Instruction> instructions) {
        return this.createTransaction(computeUnitLimit, microLamportComputeUnitPrice, Transaction.createTx((AccountMeta)this.feePayer, instructions));
    }

    @Override
    public Transaction createTransaction(int computeUnitLimit, long microLamportComputeUnitPrice, Transaction transaction) {
        return transaction.prependInstructions(this.nativeProgramClient.computeUnitLimit(computeUnitLimit + ComputeBudgetProgram.COMPUTE_UNITS_CONSUMED), this.nativeProgramClient.computeUnitPrice(microLamportComputeUnitPrice));
    }

    @Override
    public Transaction createTransaction(PublicKey feePayer, int computeUnitLimit, long microLamportComputeUnitPrice, Instruction instruction, AddressLookupTable lookupTable) {
        return Transaction.createTx((PublicKey)feePayer, List.of(this.nativeProgramClient.computeUnitLimit(computeUnitLimit + ComputeBudgetProgram.COMPUTE_UNITS_CONSUMED), this.nativeProgramClient.computeUnitPrice(microLamportComputeUnitPrice), instruction), (AddressLookupTable)lookupTable);
    }

    @Override
    public Transaction createTransaction(AccountMeta feePayer, int computeUnitLimit, long microLamportComputeUnitPrice, Instruction instruction, AddressLookupTable lookupTable) {
        return Transaction.createTx((AccountMeta)feePayer, List.of(this.nativeProgramClient.computeUnitLimit(computeUnitLimit + ComputeBudgetProgram.COMPUTE_UNITS_CONSUMED), this.nativeProgramClient.computeUnitPrice(microLamportComputeUnitPrice), instruction), (AddressLookupTable)lookupTable);
    }

    @Override
    public Transaction createTransaction(Instruction instruction, AddressLookupTable lookupTable) {
        return Transaction.createTx((AccountMeta)this.feePayer, List.of(instruction), (AddressLookupTable)lookupTable);
    }

    @Override
    public Transaction createTransaction(List<Instruction> instructions, AddressLookupTable lookupTable) {
        return Transaction.createTx((AccountMeta)this.feePayer, instructions, (AddressLookupTable)lookupTable);
    }

    @Override
    public Transaction createTransaction(int computeUnitLimit, long microLamportComputeUnitPrice, Instruction instruction, AddressLookupTable lookupTable) {
        return this.createTransaction(this.feePayer, computeUnitLimit, microLamportComputeUnitPrice, instruction, lookupTable);
    }

    @Override
    public Transaction createTransaction(int computeUnitLimit, long microLamportComputeUnitPrice, List<Instruction> instructions, AddressLookupTable lookupTable) {
        return this.createTransaction(computeUnitLimit, microLamportComputeUnitPrice, Transaction.createTx((AccountMeta)this.feePayer, instructions, (AddressLookupTable)lookupTable));
    }

    @Override
    public Transaction createTransaction(PublicKey feePayer, int computeUnitLimit, long microLamportComputeUnitPrice, Instruction instruction, LookupTableAccountMeta[] tableAccountMetas) {
        return Transaction.createTx((PublicKey)feePayer, List.of(this.nativeProgramClient.computeUnitLimit(computeUnitLimit + ComputeBudgetProgram.COMPUTE_UNITS_CONSUMED), this.nativeProgramClient.computeUnitPrice(microLamportComputeUnitPrice), instruction), (LookupTableAccountMeta[])tableAccountMetas);
    }

    @Override
    public Transaction createTransaction(AccountMeta feePayer, int computeUnitLimit, long microLamportComputeUnitPrice, Instruction instruction, LookupTableAccountMeta[] tableAccountMetas) {
        return Transaction.createTx((AccountMeta)feePayer, List.of(this.nativeProgramClient.computeUnitLimit(computeUnitLimit + ComputeBudgetProgram.COMPUTE_UNITS_CONSUMED), this.nativeProgramClient.computeUnitPrice(microLamportComputeUnitPrice), instruction), (LookupTableAccountMeta[])tableAccountMetas);
    }

    @Override
    public Transaction createTransaction(Instruction instruction, LookupTableAccountMeta[] tableAccountMetas) {
        return Transaction.createTx((AccountMeta)this.feePayer, List.of(instruction), (LookupTableAccountMeta[])tableAccountMetas);
    }

    @Override
    public Transaction createTransaction(List<Instruction> instructions, LookupTableAccountMeta[] tableAccountMetas) {
        return Transaction.createTx((AccountMeta)this.feePayer, instructions, (LookupTableAccountMeta[])tableAccountMetas);
    }

    @Override
    public Transaction createTransaction(int computeUnitLimit, long microLamportComputeUnitPrice, Instruction instruction, LookupTableAccountMeta[] tableAccountMetas) {
        return this.createTransaction(this.feePayer, computeUnitLimit, microLamportComputeUnitPrice, instruction, tableAccountMetas);
    }

    @Override
    public Transaction createTransaction(int computeUnitLimit, long microLamportComputeUnitPrice, List<Instruction> instructions, LookupTableAccountMeta[] tableAccountMetas) {
        return this.createTransaction(computeUnitLimit, microLamportComputeUnitPrice, Transaction.createTx((AccountMeta)this.feePayer, instructions, (LookupTableAccountMeta[])tableAccountMetas));
    }

    @Override
    public ProgramDerivedAddress findATA(PublicKey mint) {
        return AssociatedTokenProgram.findATA(this.solanaAccounts, this.owner, mint);
    }

    @Override
    public ProgramDerivedAddress findATA(PublicKey tokenProgram, PublicKey mint) {
        return AssociatedTokenProgram.findATA(this.solanaAccounts, this.owner, tokenProgram, mint);
    }

    @Override
    public ProgramDerivedAddress findATAForFeePayer(PublicKey mint) {
        return AssociatedTokenProgram.findATA(this.solanaAccounts, this.feePayerPublicKey, mint);
    }

    @Override
    public ProgramDerivedAddress findATAForFeePayer(PublicKey tokenProgram, PublicKey mint) {
        return AssociatedTokenProgram.findATA(this.solanaAccounts, this.feePayerPublicKey, tokenProgram, mint);
    }

    @Override
    public CompletableFuture<List<AccountInfo<TokenAccount>>> fetchTokenAccounts(SolanaRpcClient rpcClient, PublicKey tokenMintAddress) {
        return rpcClient.getTokenAccountsForTokenMintByOwner(this.owner, tokenMintAddress);
    }

    @Override
    public CompletableFuture<List<AccountInfo<TokenAccount>>> fetchTokenAccounts(SolanaRpcClient rpcClient) {
        return rpcClient.getTokenAccountsForProgramByOwner(this.owner, this.solanaAccounts.tokenProgram());
    }

    @Override
    public CompletableFuture<List<AccountInfo<TokenAccount>>> fetchToken2022Accounts(SolanaRpcClient rpcClient) {
        return rpcClient.getTokenAccountsForProgramByOwner(this.owner, this.solanaAccounts.token2022Program());
    }

    @Override
    public Instruction syncNative() {
        return this.nativeProgramClient.syncNative(this.wrappedSolPDA.publicKey());
    }

    @Override
    public List<Instruction> wrapSOL(long lamports) {
        Instruction transferIx = this.transferSolLamports(this.wrappedSolPDA.publicKey(), lamports);
        return List.of(transferIx, this.syncNative());
    }

    @Override
    public Instruction unwrapSOL() {
        return this.closeTokenAccount(this.wrappedSolPDA.publicKey());
    }

    @Override
    public Instruction createAccount(PublicKey newAccountPublicKey, long lamports, long space, PublicKey programOwner) {
        return SystemProgram.createAccount(this.solanaAccounts.invokedSystemProgram(), this.owner, newAccountPublicKey, lamports, space, programOwner);
    }

    @Override
    public Instruction createAccountWithSeed(AccountWithSeed accountWithSeed, long lamports, long space, PublicKey programOwner) {
        return SystemProgram.createAccountWithSeed(this.solanaAccounts.invokedSystemProgram(), this.feePayerPublicKey, accountWithSeed, lamports, space, programOwner);
    }

    @Override
    public Instruction allocateAccountSpaceWithSeed(AccountWithSeed accountWithSeed, long space, PublicKey programOwner) {
        return SystemProgram.allocateWithSeed(this.solanaAccounts.invokedSystemProgram(), accountWithSeed, space, programOwner);
    }

    @Override
    public AccountWithSeed createOffCurveAccountWithSeed(String asciiSeed, PublicKey programId) {
        return PublicKey.createOffCurveAccountWithAsciiSeed((PublicKey)this.feePayerPublicKey, (String)asciiSeed, (PublicKey)programId);
    }

    @Override
    public AccountWithSeed createOffCurveStakeAccountWithSeed(String asciiSeed) {
        return this.createOffCurveAccountWithSeed(asciiSeed, this.solanaAccounts.stakeProgram());
    }

    @Override
    public CompletableFuture<List<AccountInfo<StakeAccount>>> fetchStakeAccountsByStakeAuthority(SolanaRpcClient rpcClient, StakeState stakeState) {
        return this.nativeProgramClient.fetchStakeAccountsByStakeAuthority(rpcClient, stakeState, this.ownerPublicKey());
    }

    @Override
    public CompletableFuture<List<AccountInfo<StakeAccount>>> fetchStakeAccountsByWithdrawAuthority(SolanaRpcClient rpcClient, StakeState stakeState) {
        return this.nativeProgramClient.fetchStakeAccountsByWithdrawAuthority(rpcClient, stakeState, this.ownerPublicKey());
    }

    @Override
    public CompletableFuture<List<AccountInfo<AddressLookupTable>>> fetchLookupTableAccountsByAuthority(SolanaRpcClient rpcClient) {
        return this.nativeProgramClient.fetchLookupTableAccountsByAuthority(rpcClient, this.ownerPublicKey());
    }

    @Override
    public Instruction createStakeAccount(PublicKey newAccountPublicKey, long lamports) {
        return this.createAccount(newAccountPublicKey, lamports, 200L, this.solanaAccounts.stakeProgram());
    }

    @Override
    public Instruction createStakeAccountWithSeed(AccountWithSeed accountWithSeed, long lamports) {
        return this.createAccountWithSeed(accountWithSeed, lamports, 200L, this.solanaAccounts.stakeProgram());
    }

    @Override
    public Instruction allocateStakeAccountWithSeed(AccountWithSeed accountWithSeed) {
        return this.allocateAccountSpaceWithSeed(accountWithSeed, 200L, this.solanaAccounts.stakeProgram());
    }

    @Override
    public Instruction transferSolLamportsWithSeed(AccountWithSeed accountWithSeed, PublicKey recipientAccount, long lamports, PublicKey programOwner) {
        return SystemProgram.transferWithSeed(this.solanaAccounts.invokedSystemProgram(), accountWithSeed, recipientAccount, lamports, programOwner);
    }

    @Override
    public Instruction transferSolLamports(PublicKey toPublicKey, long lamports) {
        return SystemProgram.transfer(this.solanaAccounts.invokedSystemProgram(), this.owner, toPublicKey, lamports);
    }

    @Override
    public Instruction transferToken(AccountMeta invokedTokenProgram, PublicKey fromTokenAccount, PublicKey toTokenAccount, long scaledAmount) {
        return TokenProgram.transfer(invokedTokenProgram, fromTokenAccount, toTokenAccount, scaledAmount, this.owner);
    }

    @Override
    public Instruction transferTokenChecked(AccountMeta invokedTokenProgram, PublicKey fromTokenAccount, PublicKey toTokenAccount, long scaledAmount, int decimals, PublicKey tokenMint) {
        return TokenProgram.transferChecked(invokedTokenProgram, fromTokenAccount, toTokenAccount, scaledAmount, decimals, this.owner, tokenMint);
    }

    @Override
    public Instruction closeTokenAccount(AccountMeta invokedTokenProgram, PublicKey tokenAccount) {
        return TokenProgram.closeAccount(invokedTokenProgram, tokenAccount, this.owner, this.owner);
    }

    @Override
    public Instruction initializeStakeAccount(PublicKey unInitializedStakeAccount, PublicKey staker) {
        return this.nativeProgramClient.initializeStakeAccount(unInitializedStakeAccount, staker, this.owner);
    }

    @Override
    public Instruction initializeStakeAccount(PublicKey unInitializedStakeAccount) {
        return this.initializeStakeAccount(unInitializedStakeAccount, this.owner);
    }

    @Override
    public Instruction initializeStakeAccountChecked(PublicKey unInitializedStakeAccount, PublicKey staker) {
        return this.nativeProgramClient.initializeStakeAccountChecked(unInitializedStakeAccount, staker, this.owner);
    }

    @Override
    public Instruction initializeStakeAccountChecked(PublicKey unInitializedStakeAccount) {
        return this.nativeProgramClient.initializeStakeAccountChecked(unInitializedStakeAccount, this.owner, this.owner);
    }

    @Override
    public Instruction authorizeStakeAccount(PublicKey stakeAccount, PublicKey stakeOrWithdrawAuthority, PublicKey lockupAuthority, StakeAuthorize stakeAuthorize) {
        return this.nativeProgramClient.authorizeStakeAccount(stakeAccount, stakeOrWithdrawAuthority, this.owner, lockupAuthority, stakeAuthorize);
    }

    @Override
    public Instruction authorizeStakeAccount(PublicKey stakeAccount, PublicKey stakeOrWithdrawAuthority, StakeAuthorize stakeAuthorize) {
        return this.nativeProgramClient.authorizeStakeAccount(stakeAccount, stakeOrWithdrawAuthority, this.owner, stakeAuthorize);
    }

    @Override
    public Instruction authorizeStakeAccountChecked(PublicKey stakeAccount, PublicKey stakeOrWithdrawAuthority, PublicKey newStakeOrWithdrawAuthority, StakeAuthorize stakeAuthorize) {
        return this.nativeProgramClient.authorizeStakeAccountChecked(stakeAccount, stakeOrWithdrawAuthority, this.owner, stakeAuthorize);
    }

    @Override
    public Instruction authorizeStakeAccountChecked(PublicKey stakeAccount, PublicKey stakeOrWithdrawAuthority, StakeAuthorize stakeAuthorize) {
        return this.nativeProgramClient.authorizeStakeAccountChecked(stakeAccount, stakeOrWithdrawAuthority, this.owner, stakeAuthorize);
    }

    @Override
    public Instruction delegateStakeAccount(PublicKey initializedStakeAccount, PublicKey validatorVoteAccount) {
        return this.nativeProgramClient.delegateStakeAccount(initializedStakeAccount, validatorVoteAccount, this.owner);
    }

    @Override
    public Instruction deactivateStakeAccount(PublicKey delegatedStakeAccount) {
        return this.nativeProgramClient.deactivateStakeAccount(delegatedStakeAccount, this.owner);
    }

    @Override
    public Instruction withdrawStakeAccount(StakeAccount stakeAccount, long lamports) {
        return this.nativeProgramClient.withdrawStakeAccount(stakeAccount, this.owner, lamports);
    }

    @Override
    public ProgramDerivedAddress findLookupTableAddress(long recentSlot) {
        return AddressLookupTableProgram.findLookupTableAddress(this.solanaAccounts, this.feePayerPublicKey, recentSlot);
    }

    @Override
    public Instruction createLookupTable(ProgramDerivedAddress uninitializedTableAccount, long recentSlot) {
        return AddressLookupTableProgram.createLookupTable(this.solanaAccounts, uninitializedTableAccount.publicKey(), this.feePayerPublicKey, this.feePayerPublicKey, recentSlot, uninitializedTableAccount.nonce());
    }

    @Override
    public Instruction freezeLookupTable(PublicKey tableAccount) {
        return AddressLookupTableProgram.freezeLookupTable(this.solanaAccounts, tableAccount, this.feePayerPublicKey);
    }

    @Override
    public Instruction extendLookupTable(PublicKey tableAccount, SequencedCollection<PublicKey> newAddresses) {
        return AddressLookupTableProgram.extendLookupTable(this.solanaAccounts, tableAccount, this.feePayerPublicKey, this.feePayerPublicKey, newAddresses);
    }

    @Override
    public Instruction deactivateLookupTable(PublicKey tableAccount) {
        return AddressLookupTableProgram.deactivateLookupTable(this.solanaAccounts, tableAccount, this.feePayerPublicKey);
    }

    @Override
    public Instruction closeLookupTable(PublicKey tableAccount) {
        return AddressLookupTableProgram.closeLookupTable(this.solanaAccounts, tableAccount, this.feePayerPublicKey, this.feePayerPublicKey);
    }
}

