/*
 * Decompiled with CFR 0.152.
 */
package software.sava.solana.programs.ed25519;

import software.sava.core.encoding.ByteUtil;

public record Ed25519SignatureOffsets(int signatureOffset, int signatureInstructionIndex, int publicKeyOffset, int publicKeyInstructionIndex, int messageDataOffset, int messageDataSize, int messageInstructionIndex) {
    public static final int BYTES = 14;

    public static Ed25519SignatureOffsets read(byte[] data, int offset) {
        if (data == null || data.length == 0) {
            return null;
        }
        int i = offset;
        short signatureOffset = ByteUtil.getInt16LE((byte[])data, (int)i);
        short signatureInstructionIndex = ByteUtil.getInt16LE((byte[])data, (int)(i += 2));
        short publicKeyOffset = ByteUtil.getInt16LE((byte[])data, (int)(i += 2));
        short publicKeyInstructionIndex = ByteUtil.getInt16LE((byte[])data, (int)(i += 2));
        short messageDataOffset = ByteUtil.getInt16LE((byte[])data, (int)(i += 2));
        short messageDataSize = ByteUtil.getInt16LE((byte[])data, (int)(i += 2));
        short messageInstructionIndex = ByteUtil.getInt16LE((byte[])data, (int)(i += 2));
        return new Ed25519SignatureOffsets(signatureOffset, signatureInstructionIndex, publicKeyOffset, publicKeyInstructionIndex, messageDataOffset, messageDataSize, messageInstructionIndex);
    }

    public static Ed25519SignatureOffsets[] readVector(byte[] data, int offset) {
        if (data == null || data.length == 0) {
            return null;
        }
        int numSignatures = ByteUtil.getInt16LE((byte[])data, (int)offset);
        int i = offset + 2;
        Ed25519SignatureOffsets[] signatures = new Ed25519SignatureOffsets[numSignatures];
        for (int s = 0; s < numSignatures; ++s) {
            signatures[s] = Ed25519SignatureOffsets.read(data, i);
            i += 14;
        }
        return signatures;
    }
}

