/*
 * Decompiled with CFR 0.152.
 */
package software.sava.solana.programs.stakepool;

import java.util.concurrent.CompletableFuture;
import software.sava.core.accounts.ProgramDerivedAddress;
import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.SolanaAccounts;
import software.sava.core.accounts.meta.AccountMeta;
import software.sava.core.tx.Instruction;
import software.sava.rpc.json.http.client.SolanaRpcClient;
import software.sava.rpc.json.http.response.AccountInfo;
import software.sava.solana.programs.clients.NativeProgramAccountClient;
import software.sava.solana.programs.stakepool.StakePoolAccounts;
import software.sava.solana.programs.stakepool.StakePoolProgram;
import software.sava.solana.programs.stakepool.StakePoolProgramClientImpl;
import software.sava.solana.programs.stakepool.StakePoolState;
import software.sava.solana.programs.stakepool.ValidatorList;

public interface StakePoolProgramClient {
    public static StakePoolProgramClient createClient(NativeProgramAccountClient nativeProgramClient, StakePoolAccounts stakePoolAccounts) {
        return new StakePoolProgramClientImpl(nativeProgramClient, stakePoolAccounts);
    }

    public static StakePoolProgramClient createClient(NativeProgramAccountClient nativeProgramClient) {
        return StakePoolProgramClient.createClient(nativeProgramClient, StakePoolAccounts.MAIN_NET);
    }

    public NativeProgramAccountClient nativeProgramAccountClient();

    public SolanaAccounts solanaAccounts();

    public StakePoolAccounts stakePoolAccounts();

    public static CompletableFuture<AccountInfo<StakePoolState>> fetchProgramState(SolanaRpcClient rpcClient, PublicKey stakePoolPublicKey) {
        return rpcClient.getAccountInfo(stakePoolPublicKey, StakePoolState.FACTORY);
    }

    public static CompletableFuture<AccountInfo<ValidatorList>> fetchValidatorList(SolanaRpcClient rpcClient, StakePoolState programState) {
        PublicKey destinationValidatorList = programState.validatorList();
        return rpcClient.getAccountInfo(destinationValidatorList, ValidatorList.FACTORY);
    }

    public static ProgramDerivedAddress findStakePoolWithdrawAuthority(AccountInfo<StakePoolState> stakePoolStateAccountInfo) {
        return StakePoolProgram.findStakePoolWithdrawAuthority(stakePoolStateAccountInfo.pubKey(), stakePoolStateAccountInfo.owner());
    }

    public PublicKey ownerPublicKey();

    public Instruction depositSol(PublicKey var1, StakePoolState var2, PublicKey var3, long var4);

    default public Instruction depositSol(AccountInfo<StakePoolState> stakePoolStateAccountInfo, PublicKey poolTokenATA, long lamportsIn) {
        return this.depositSol(stakePoolStateAccountInfo.owner(), (StakePoolState)stakePoolStateAccountInfo.data(), poolTokenATA, lamportsIn);
    }

    public Instruction depositSolWithSlippage(PublicKey var1, StakePoolState var2, PublicKey var3, long var4, long var6);

    default public Instruction depositSolWithSlippage(AccountInfo<StakePoolState> stakePoolStateAccountInfo, PublicKey poolTokenATA, long lamportsIn, long minimumPoolTokensOut) {
        return this.depositSolWithSlippage(stakePoolStateAccountInfo.owner(), (StakePoolState)stakePoolStateAccountInfo.data(), poolTokenATA, lamportsIn, minimumPoolTokensOut);
    }

    public Instruction depositStake(PublicKey var1, StakePoolState var2, PublicKey var3, PublicKey var4, PublicKey var5);

    default public Instruction depositStake(AccountInfo<StakePoolState> stakePoolStateAccountInfo, PublicKey depositStakeAccount, PublicKey validatorStakeAccount, PublicKey poolTokenATA) {
        return this.depositStake(stakePoolStateAccountInfo.owner(), (StakePoolState)stakePoolStateAccountInfo.data(), depositStakeAccount, validatorStakeAccount, poolTokenATA);
    }

    public Instruction depositStakeWithSlippage(PublicKey var1, StakePoolState var2, PublicKey var3, PublicKey var4, PublicKey var5, long var6);

    default public Instruction depositStakeWithSlippage(AccountInfo<StakePoolState> stakePoolStateAccountInfo, PublicKey depositStakeAccount, PublicKey validatorStakeAccount, PublicKey poolTokenATA, long minimumPoolTokensOut) {
        return this.depositStakeWithSlippage(stakePoolStateAccountInfo.owner(), (StakePoolState)stakePoolStateAccountInfo.data(), depositStakeAccount, validatorStakeAccount, poolTokenATA, minimumPoolTokensOut);
    }

    public Instruction withdrawSol(PublicKey var1, StakePoolState var2, PublicKey var3, long var4);

    default public Instruction withdrawSol(AccountInfo<StakePoolState> stakePoolStateAccountInfo, PublicKey poolTokenATA, long poolTokenAmount) {
        return this.withdrawSol(stakePoolStateAccountInfo.owner(), (StakePoolState)stakePoolStateAccountInfo.data(), poolTokenATA, poolTokenAmount);
    }

    public Instruction withdrawSolWithSlippage(PublicKey var1, StakePoolState var2, PublicKey var3, long var4, long var6);

    default public Instruction withdrawSolWithSlippage(AccountInfo<StakePoolState> stakePoolStateAccountInfo, PublicKey poolTokenATA, long poolTokenAmount, long lamportsOut) {
        return this.withdrawSolWithSlippage(stakePoolStateAccountInfo.owner(), (StakePoolState)stakePoolStateAccountInfo.data(), poolTokenATA, poolTokenAmount, lamportsOut);
    }

    public Instruction withdrawStake(PublicKey var1, StakePoolState var2, PublicKey var3, PublicKey var4, PublicKey var5, PublicKey var6, long var7);

    default public Instruction withdrawStake(AccountInfo<StakePoolState> stakePoolStateAccountInfo, PublicKey validatorOrReserveStakeAccount, PublicKey uninitializedStakeAccount, PublicKey stakeAccountWithdrawalAuthority, PublicKey poolTokenATA, long poolTokenAmount) {
        return this.withdrawStake(stakePoolStateAccountInfo.owner(), (StakePoolState)stakePoolStateAccountInfo.data(), validatorOrReserveStakeAccount, uninitializedStakeAccount, stakeAccountWithdrawalAuthority, poolTokenATA, poolTokenAmount);
    }

    public Instruction withdrawStakeWithSlippage(PublicKey var1, StakePoolState var2, PublicKey var3, PublicKey var4, PublicKey var5, PublicKey var6, long var7, long var9);

    default public Instruction withdrawStakeWithSlippage(AccountInfo<StakePoolState> stakePoolStateAccountInfo, PublicKey validatorOrReserveStakeAccount, PublicKey uninitializedStakeAccount, PublicKey stakeAccountWithdrawalAuthority, PublicKey poolTokenATA, long poolTokenAmount, long lamportsOut) {
        return this.withdrawStakeWithSlippage(stakePoolStateAccountInfo.owner(), (StakePoolState)stakePoolStateAccountInfo.data(), validatorOrReserveStakeAccount, uninitializedStakeAccount, stakeAccountWithdrawalAuthority, poolTokenATA, poolTokenAmount, lamportsOut);
    }

    default public Instruction withdrawStakeWithSlippage(AccountInfo<StakePoolState> stakePoolStateAccountInfo, PublicKey validatorOrReserveStakeAccount, PublicKey uninitializedStakeAccount, PublicKey poolTokenATA, long poolTokenAmount, long lamportsOut) {
        return this.withdrawStakeWithSlippage(stakePoolStateAccountInfo, validatorOrReserveStakeAccount, uninitializedStakeAccount, this.ownerPublicKey(), poolTokenATA, poolTokenAmount, lamportsOut);
    }

    default public Instruction updateStakePoolBalance(PublicKey poolProgram, StakePoolState stakePoolState) {
        return StakePoolProgram.updateStakePoolBalance(AccountMeta.createInvoked((PublicKey)poolProgram), stakePoolState.address(), stakePoolState.validatorList(), stakePoolState.reserveStake(), stakePoolState.managerFeeAccount(), stakePoolState.poolMint(), stakePoolState.tokenProgramId());
    }

    default public Instruction updateStakePoolBalance(AccountInfo<StakePoolState> stakePoolStateAccountInfo) {
        return this.updateStakePoolBalance(stakePoolStateAccountInfo.owner(), (StakePoolState)stakePoolStateAccountInfo.data());
    }
}

