/*
 * Decompiled with CFR 0.152.
 */
package software.sava.solana.programs.stakepool;

import java.util.function.BiFunction;
import software.sava.core.accounts.PublicKey;
import software.sava.core.borsh.Borsh;
import software.sava.core.encoding.ByteUtil;
import software.sava.solana.programs.stake.ValidatorStakeInfo;
import software.sava.solana.programs.stakepool.AccountType;

public record ValidatorList(PublicKey address, AccountType accountType, int maxValidators, ValidatorStakeInfo[] validators) implements Borsh
{
    public static final BiFunction<PublicKey, byte[], ValidatorList> FACTORY = ValidatorList::read;

    public static ValidatorList read(byte[] data, int offset) {
        return ValidatorList.read(null, data, offset);
    }

    public static ValidatorList read(PublicKey publicKey, byte[] data) {
        return ValidatorList.read(publicKey, data, 0);
    }

    public static ValidatorList read(PublicKey publicKey, byte[] data, int offset) {
        AccountType accountType = AccountType.values()[data[offset] & 0xFF];
        int maxValidators = ByteUtil.getInt32LE((byte[])data, (int)(++offset));
        int numValidators = ByteUtil.getInt32LE((byte[])data, (int)(offset += 4));
        offset += 4;
        ValidatorStakeInfo[] validators = new ValidatorStakeInfo[numValidators];
        for (int i = 0; i < numValidators; ++i) {
            validators[i] = ValidatorStakeInfo.read(data, offset);
            offset += ValidatorStakeInfo.BYTES;
        }
        return new ValidatorList(publicKey, accountType, maxValidators, validators);
    }

    public int write(byte[] data, int offset) {
        data[offset] = (byte)this.accountType.ordinal();
        ByteUtil.putInt32LE((byte[])data, (int)(offset + 1), (int)this.maxValidators);
        return Borsh.writeArray((Borsh[])this.validators, (byte[])data, (int)(offset + 1 + 4));
    }

    public int l() {
        return 5 + ValidatorStakeInfo.BYTES * this.validators.length;
    }
}

