/*
 * Decompiled with CFR 0.152.
 */
package software.sava.solana.programs.token;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.SolanaAccounts;
import software.sava.core.accounts.meta.AccountMeta;
import software.sava.core.accounts.token.extensions.ExtensionType;
import software.sava.core.encoding.ByteUtil;
import software.sava.core.programs.Discriminator;
import software.sava.core.tx.Instruction;
import software.sava.solana.programs.token.TokenProgram;

public final class Token2022Program {
    public static Instruction initializeMint(SolanaAccounts solanaAccounts, PublicKey mint, int decimals, PublicKey mintAuthority, PublicKey freezeAuthority) {
        return TokenProgram.initializeMint(solanaAccounts.invokedToken2022Program(), solanaAccounts, mint, decimals, mintAuthority, freezeAuthority);
    }

    public static Instruction initializeMint2(SolanaAccounts solanaAccounts, PublicKey mint, int decimals, PublicKey mintAuthority, PublicKey freezeAuthority) {
        return TokenProgram.initializeMint2(solanaAccounts.invokedToken2022Program(), mint, decimals, mintAuthority, freezeAuthority);
    }

    public static Instruction initializeAccount(SolanaAccounts solanaAccounts, PublicKey account, PublicKey mint, PublicKey owner) {
        return TokenProgram.initializeAccount(solanaAccounts.invokedToken2022Program(), solanaAccounts, account, mint, owner);
    }

    public static Instruction initializeAccount2(SolanaAccounts solanaAccounts, PublicKey account, PublicKey mint, PublicKey owner) {
        return TokenProgram.initializeAccount2(solanaAccounts.invokedToken2022Program(), solanaAccounts, account, mint, owner);
    }

    public static Instruction initializeAccount3(SolanaAccounts solanaAccounts, PublicKey account, PublicKey mint, PublicKey owner) {
        return TokenProgram.initializeAccount3(solanaAccounts.invokedToken2022Program(), account, mint, owner);
    }

    public static Instruction initializeMultisig(SolanaAccounts solanaAccounts, PublicKey multisigAccount, List<PublicKey> signerAccounts, int requiredSignatures) {
        return TokenProgram.initializeMultisig(solanaAccounts.invokedToken2022Program(), solanaAccounts, multisigAccount, signerAccounts, requiredSignatures);
    }

    public static Instruction initializeMultisig2(SolanaAccounts solanaAccounts, PublicKey multisigAccount, List<PublicKey> signerAccounts, int requiredSignatures) {
        return TokenProgram.initializeMultisig2(solanaAccounts.invokedToken2022Program(), multisigAccount, signerAccounts, requiredSignatures);
    }

    public static Instruction transfer(SolanaAccounts solanaAccounts, PublicKey source, PublicKey destination, PublicKey owner, long amount) {
        return TokenProgram.transfer(solanaAccounts.invokedToken2022Program(), source, destination, amount, owner);
    }

    public static Instruction transferMultisig(SolanaAccounts solanaAccounts, PublicKey source, PublicKey destination, PublicKey owner, List<PublicKey> signerAccounts, long amount) {
        return TokenProgram.transferMultisig(solanaAccounts.invokedToken2022Program(), source, destination, amount, owner, signerAccounts);
    }

    public static Instruction transferChecked(SolanaAccounts solanaAccounts, PublicKey source, PublicKey destination, long amount, int decimals, PublicKey owner, PublicKey tokenMint) {
        return TokenProgram.transferChecked(solanaAccounts.invokedToken2022Program(), source, destination, amount, decimals, owner, tokenMint);
    }

    public static Instruction transferCheckedMultisig(SolanaAccounts solanaAccounts, PublicKey source, PublicKey destination, long amount, int decimals, PublicKey owner, PublicKey tokenMint, List<PublicKey> signerAccounts) {
        return TokenProgram.transferCheckedMultisig(solanaAccounts.invokedToken2022Program(), source, destination, amount, decimals, owner, tokenMint, signerAccounts);
    }

    public static Instruction approve(SolanaAccounts solanaAccounts, PublicKey sourceAccount, PublicKey delegate, PublicKey owner, long amount) {
        return TokenProgram.approve(solanaAccounts.invokedToken2022Program(), sourceAccount, delegate, owner, amount);
    }

    public static Instruction approveMultisig(SolanaAccounts solanaAccounts, PublicKey sourceAccount, PublicKey delegate, PublicKey owner, List<PublicKey> signerAccounts, long amount) {
        return TokenProgram.approveMultisig(solanaAccounts.invokedToken2022Program(), sourceAccount, delegate, owner, signerAccounts, amount);
    }

    public static Instruction approveChecked(SolanaAccounts solanaAccounts, PublicKey sourceAccount, PublicKey tokenMint, int decimals, PublicKey delegate, PublicKey owner, long amount) {
        return TokenProgram.approveChecked(solanaAccounts.invokedToken2022Program(), sourceAccount, tokenMint, decimals, delegate, owner, amount);
    }

    public static Instruction approveCheckedMultisig(SolanaAccounts solanaAccounts, PublicKey sourceAccount, PublicKey tokenMint, int decimals, PublicKey delegate, PublicKey owner, List<PublicKey> signerAccounts, long amount) {
        return TokenProgram.approveCheckedMultisig(solanaAccounts.invokedToken2022Program(), sourceAccount, tokenMint, decimals, delegate, owner, signerAccounts, amount);
    }

    public static Instruction revoke(SolanaAccounts solanaAccounts, PublicKey sourceAccount, PublicKey owner) {
        return TokenProgram.revoke(solanaAccounts.invokedToken2022Program(), sourceAccount, owner);
    }

    public static Instruction revokeMultisig(SolanaAccounts solanaAccounts, PublicKey sourceAccount, PublicKey owner, List<PublicKey> signerAccounts) {
        return TokenProgram.revokeMultisig(solanaAccounts.invokedToken2022Program(), sourceAccount, owner, signerAccounts);
    }

    public static Instruction setAuthority(SolanaAccounts solanaAccounts, PublicKey account, PublicKey authority, TokenProgram.AuthorityType authorityType, PublicKey newAuthority) {
        return TokenProgram.setAuthority(solanaAccounts.invokedToken2022Program(), account, authority, authorityType, newAuthority);
    }

    public static Instruction setAuthorityMultisig(SolanaAccounts solanaAccounts, PublicKey account, PublicKey owner, List<PublicKey> signerAccounts, TokenProgram.AuthorityType authorityType, PublicKey newAuthority) {
        return TokenProgram.setAuthorityMultisig(solanaAccounts.invokedToken2022Program(), account, owner, signerAccounts, authorityType, newAuthority);
    }

    public static Instruction mintTo(SolanaAccounts solanaAccounts, PublicKey mint, PublicKey account, PublicKey authority, long amount) {
        return TokenProgram.mintTo(solanaAccounts.invokedToken2022Program(), mint, account, authority, amount);
    }

    public static Instruction mintToMultisig(SolanaAccounts solanaAccounts, PublicKey mint, PublicKey account, PublicKey authority, List<PublicKey> signerAccounts, long amount) {
        return TokenProgram.mintToMultisig(solanaAccounts.invokedToken2022Program(), mint, account, authority, signerAccounts, amount);
    }

    public static Instruction mintToChecked(SolanaAccounts solanaAccounts, PublicKey mint, int decimals, PublicKey account, PublicKey authority, long amount) {
        return TokenProgram.mintToChecked(solanaAccounts.invokedToken2022Program(), mint, decimals, account, authority, amount);
    }

    public static Instruction mintToCheckedMultisig(SolanaAccounts solanaAccounts, PublicKey mint, int decimals, PublicKey account, PublicKey authority, List<PublicKey> signerAccounts, long amount) {
        return TokenProgram.mintToCheckedMultisig(solanaAccounts.invokedToken2022Program(), mint, decimals, account, authority, signerAccounts, amount);
    }

    public static Instruction burn(SolanaAccounts solanaAccounts, PublicKey mint, PublicKey account, PublicKey authority, long amount) {
        return TokenProgram.burn(solanaAccounts.invokedToken2022Program(), mint, account, authority, amount);
    }

    public static Instruction burnMultisig(SolanaAccounts solanaAccounts, PublicKey mint, PublicKey account, PublicKey authority, List<PublicKey> signerAccounts, long amount) {
        return TokenProgram.burnMultisig(solanaAccounts.invokedToken2022Program(), mint, account, authority, signerAccounts, amount);
    }

    public static Instruction burnChecked(SolanaAccounts solanaAccounts, PublicKey mint, int decimals, PublicKey account, PublicKey authority, long amount) {
        return TokenProgram.burnChecked(solanaAccounts.invokedToken2022Program(), mint, decimals, account, authority, amount);
    }

    public static Instruction burnCheckedMultisig(SolanaAccounts solanaAccounts, PublicKey mint, int decimals, PublicKey account, PublicKey authority, List<PublicKey> signerAccounts, long amount) {
        return TokenProgram.burnCheckedMultisig(solanaAccounts.invokedToken2022Program(), mint, decimals, account, authority, signerAccounts, amount);
    }

    public static Instruction closeAccount(SolanaAccounts solanaAccounts, PublicKey tokenAccount, PublicKey lamportDestination, PublicKey owner) {
        return TokenProgram.closeAccount(solanaAccounts.invokedToken2022Program(), tokenAccount, lamportDestination, owner);
    }

    public static Instruction closeAccountMultisig(SolanaAccounts solanaAccounts, PublicKey tokenAccount, PublicKey lamportDestination, PublicKey owner, List<PublicKey> signerAccounts) {
        return TokenProgram.closeAccountMultisig(solanaAccounts.invokedToken2022Program(), tokenAccount, lamportDestination, owner, signerAccounts);
    }

    public static Instruction freezeAccount(SolanaAccounts solanaAccounts, PublicKey account, PublicKey mint, PublicKey freezeAuthority) {
        return TokenProgram.freezeAccount(solanaAccounts.invokedToken2022Program(), account, mint, freezeAuthority);
    }

    public static Instruction freezeAccountMultisig(SolanaAccounts solanaAccounts, PublicKey account, PublicKey mint, PublicKey freezeAuthority, List<PublicKey> signerAccounts) {
        return TokenProgram.freezeAccountMultisig(solanaAccounts.invokedToken2022Program(), account, mint, freezeAuthority, signerAccounts);
    }

    public static Instruction thawAccount(SolanaAccounts solanaAccounts, PublicKey account, PublicKey mint, PublicKey authority) {
        return TokenProgram.thawAccount(solanaAccounts.invokedToken2022Program(), account, mint, authority);
    }

    public static Instruction thawAccountMultisig(SolanaAccounts solanaAccounts, PublicKey account, PublicKey mint, PublicKey authority, List<PublicKey> signerAccounts) {
        return TokenProgram.thawAccountMultisig(solanaAccounts.invokedToken2022Program(), account, mint, authority, signerAccounts);
    }

    public static Instruction initializeMintCloseAuthority(AccountMeta invokedTokenProgram, PublicKey mint, PublicKey closeAuthority) {
        byte[] data;
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)mint));
        if (closeAuthority == null) {
            data = new byte[2];
        } else {
            data = new byte[34];
            data[1] = 1;
            closeAuthority.write(data, 2);
        }
        data[0] = TokenInstruction.InitializeMintCloseAuthority.discriminator;
        return Instruction.createInstruction((AccountMeta)invokedTokenProgram, keys, (byte[])data);
    }

    public static Instruction initializeMintCloseAuthority(SolanaAccounts solanaAccounts, PublicKey mint, PublicKey closeAuthority) {
        return Token2022Program.initializeMintCloseAuthority(solanaAccounts.invokedToken2022Program(), mint, closeAuthority);
    }

    private static byte[] reallocateData(Collection<ExtensionType> newExtensionTypes) {
        byte[] data = new byte[1 + 2 * newExtensionTypes.size()];
        data[0] = TokenInstruction.Reallocate.discriminator;
        int i = 1;
        for (ExtensionType extensionType : newExtensionTypes) {
            ByteUtil.putInt16LE((byte[])data, (int)i, (int)extensionType.ordinal());
            i += 2;
        }
        return data;
    }

    public static Instruction reallocate(AccountMeta invokedTokenProgram, SolanaAccounts solanaAccounts, PublicKey account, PublicKey payer, PublicKey owner, Collection<ExtensionType> newExtensionTypes) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)account), AccountMeta.createWritableSigner((PublicKey)payer), solanaAccounts.readSystemProgram(), AccountMeta.createReadOnlySigner((PublicKey)owner));
        byte[] data = Token2022Program.reallocateData(newExtensionTypes);
        return Instruction.createInstruction((AccountMeta)invokedTokenProgram, keys, (byte[])data);
    }

    public static Instruction reallocate(SolanaAccounts solanaAccounts, PublicKey account, PublicKey payer, PublicKey owner, Collection<ExtensionType> newExtensionTypes) {
        return Token2022Program.reallocate(solanaAccounts.invokedToken2022Program(), solanaAccounts, account, payer, owner, newExtensionTypes);
    }

    public static Instruction reallocateMultisig(AccountMeta invokedTokenProgram, SolanaAccounts solanaAccounts, PublicKey account, PublicKey payer, PublicKey owner, List<PublicKey> signerAccounts, Collection<ExtensionType> newExtensionTypes) {
        AccountMeta[] keys = TokenProgram.initSigners(4, signerAccounts);
        keys[0] = AccountMeta.createWrite((PublicKey)account);
        keys[1] = AccountMeta.createWritableSigner((PublicKey)payer);
        keys[2] = solanaAccounts.readSystemProgram();
        keys[3] = AccountMeta.createReadOnlySigner((PublicKey)owner);
        byte[] data = Token2022Program.reallocateData(newExtensionTypes);
        return Instruction.createInstruction((AccountMeta)invokedTokenProgram, Arrays.asList(keys), (byte[])data);
    }

    public static Instruction reallocateMultisig(SolanaAccounts solanaAccounts, PublicKey account, PublicKey payer, PublicKey owner, List<PublicKey> signerAccounts, Collection<ExtensionType> newExtensionTypes) {
        return Token2022Program.reallocateMultisig(solanaAccounts.invokedToken2022Program(), solanaAccounts, account, payer, owner, signerAccounts, newExtensionTypes);
    }

    public static Instruction createNativeMint(AccountMeta invokedTokenProgram, SolanaAccounts solanaAccounts, PublicKey fundingAccount, PublicKey nativeMintAddress) {
        List<AccountMeta> keys = List.of(AccountMeta.createWritableSigner((PublicKey)fundingAccount), AccountMeta.createWrite((PublicKey)nativeMintAddress), solanaAccounts.readSystemProgram());
        return Instruction.createInstruction((AccountMeta)invokedTokenProgram, keys, (byte[])TokenInstruction.CreateNativeMint.discriminatorBytes);
    }

    public static Instruction createNativeMint(SolanaAccounts solanaAccounts, PublicKey fundingAccount, PublicKey nativeMintAddress) {
        return Token2022Program.createNativeMint(solanaAccounts.invokedToken2022Program(), solanaAccounts, fundingAccount, nativeMintAddress);
    }

    public static Instruction initializeNonTransferableMint(AccountMeta invokedTokenProgram, PublicKey mintAccount) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)mintAccount));
        return Instruction.createInstruction((AccountMeta)invokedTokenProgram, keys, (byte[])TokenInstruction.InitializeNonTransferableMint.discriminatorBytes);
    }

    public static Instruction initializeNonTransferableMint(SolanaAccounts solanaAccounts, PublicKey mintAccount) {
        return Token2022Program.initializeNonTransferableMint(solanaAccounts.invokedToken2022Program(), mintAccount);
    }

    public static Instruction initializePermanentDelegate(AccountMeta invokedTokenProgram, PublicKey mintAccount, PublicKey delegate) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)mintAccount));
        byte[] data = new byte[33];
        data[0] = TokenInstruction.InitializePermanentDelegate.discriminator;
        delegate.write(data, 1);
        return Instruction.createInstruction((AccountMeta)invokedTokenProgram, keys, (byte[])data);
    }

    public static Instruction initializePermanentDelegate(SolanaAccounts solanaAccounts, PublicKey mintAccount, PublicKey delegate) {
        return Token2022Program.initializePermanentDelegate(solanaAccounts.invokedToken2022Program(), mintAccount, delegate);
    }

    public static Instruction withdrawExcessLamports(AccountMeta invokedTokenProgram, PublicKey sourceAccount, PublicKey destinationAccount, PublicKey authority, List<PublicKey> signerAccounts) {
        AccountMeta[] keys = TokenProgram.initSigners(3, signerAccounts);
        keys[0] = AccountMeta.createWrite((PublicKey)sourceAccount);
        keys[1] = AccountMeta.createWrite((PublicKey)destinationAccount);
        keys[2] = AccountMeta.createReadOnlySigner((PublicKey)authority);
        return Instruction.createInstruction((AccountMeta)invokedTokenProgram, Arrays.asList(keys), (byte[])TokenInstruction.WithdrawExcessLamports.discriminatorBytes);
    }

    public static Instruction withdrawExcessLamports(SolanaAccounts solanaAccounts, PublicKey sourceAccount, PublicKey destinationAccount, PublicKey authority, List<PublicKey> signerAccounts) {
        return Token2022Program.withdrawExcessLamports(solanaAccounts.invokedToken2022Program(), sourceAccount, destinationAccount, authority, signerAccounts);
    }

    private Token2022Program() {
    }

    public static enum TokenInstruction implements Discriminator
    {
        InitializeMint{}
        ,
        InitializeAccount,
        InitializeMultisig{}
        ,
        Transfer{}
        ,
        Approve{}
        ,
        Revoke,
        SetAuthority{}
        ,
        MintTo{}
        ,
        Burn{}
        ,
        CloseAccount,
        FreezeAccount,
        ThawAccount,
        TransferChecked{}
        ,
        ApproveChecked{}
        ,
        MintToChecked{}
        ,
        BurnChecked{}
        ,
        InitializeAccount2{}
        ,
        SyncNative,
        InitializeAccount3{}
        ,
        InitializeMultisig2{}
        ,
        InitializeMint2{}
        ,
        GetAccountDataSize{}
        ,
        InitializeImmutableOwner,
        AmountToUiAmount{}
        ,
        UiAmountToAmount{}
        ,
        InitializeMintCloseAuthority{}
        ,
        TransferFeeExtension,
        ConfidentialTransferExtension,
        DefaultAccountStateExtension,
        Reallocate{}
        ,
        MemoTransferExtension,
        CreateNativeMint,
        InitializeNonTransferableMint,
        InterestBearingMintExtension,
        CpiGuardExtension,
        InitializePermanentDelegate{}
        ,
        TransferHookExtension,
        ConfidentialTransferFeeExtension,
        WithdrawExcessLamports,
        MetadataPointerExtension,
        GroupPointerExtension,
        GroupMemberPointerExtension,
        ConfidentialMintBurnExtension,
        ScaledUiAmountExtension,
        PausableExtension;

        private final byte discriminator = (byte)this.ordinal();
        private final byte[] discriminatorBytes = new byte[]{this.discriminator};

        public byte[] data() {
            return this.discriminatorBytes;
        }

        public int write(byte[] bytes, int i) {
            bytes[i] = (byte)this.ordinal();
            return 1;
        }

        public int length() {
            return 1;
        }
    }
}

