/*
 * Decompiled with CFR 0.152.
 */
package software.sava.solana.programs.vote;

import software.sava.core.accounts.PublicKey;
import software.sava.core.serial.Serializable;
import software.sava.solana.programs.serde.SerdeUtil;
import software.sava.solana.programs.vote.VoteAuthorize;

public record VoteAuthorizeWithSeedArgs(VoteAuthorize authorizationType, PublicKey currentAuthorityDerivedKeyOwner, byte[] currentAuthorityDerivedKeySeed, PublicKey newAuthority) implements Serializable
{
    public static VoteAuthorizeWithSeedArgs read(byte[] data, int offset) {
        if (data == null || data.length == 0) {
            return null;
        }
        int i = offset;
        VoteAuthorize authorizationType = VoteAuthorize.read(data, i);
        PublicKey currentAuthorityDerivedKeyOwner = PublicKey.readPubKey((byte[])data, (int)(i += authorizationType.l()));
        byte[] currentAuthorityDerivedKeySeed = SerdeUtil.readString(data, i += 32);
        PublicKey newAuthority = PublicKey.readPubKey((byte[])data, (int)(i += 8 + currentAuthorityDerivedKeySeed.length));
        return new VoteAuthorizeWithSeedArgs(authorizationType, currentAuthorityDerivedKeyOwner, currentAuthorityDerivedKeySeed, newAuthority);
    }

    public int write(byte[] data, int offset) {
        int i = this.authorizationType.write(data, offset);
        i += this.currentAuthorityDerivedKeyOwner.write(data, i);
        i += SerdeUtil.writeString(this.currentAuthorityDerivedKeySeed, data, i);
        i += this.newAuthority.write(data, i);
        return i - offset;
    }

    public int l() {
        return this.authorizationType.l() + 32 + 8 + this.currentAuthorityDerivedKeySeed.length + 32;
    }
}

