/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex;

import java.io.File;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.api.armor.ArmorListener;
import studio.magemonkey.codex.bungee.BungeeListener;
import studio.magemonkey.codex.commands.UnstuckCommand;
import studio.magemonkey.codex.commands.api.IGeneralCommand;
import studio.magemonkey.codex.commands.list.Base64Command;
import studio.magemonkey.codex.config.legacy.LegacyConfigManager;
import studio.magemonkey.codex.core.Version;
import studio.magemonkey.codex.core.config.CoreConfig;
import studio.magemonkey.codex.core.config.CoreLang;
import studio.magemonkey.codex.hooks.HookManager;
import studio.magemonkey.codex.hooks.external.IMythicHook;
import studio.magemonkey.codex.hooks.external.MythicMobsHK;
import studio.magemonkey.codex.hooks.external.MythicMobsHKv5;
import studio.magemonkey.codex.hooks.external.VaultHK;
import studio.magemonkey.codex.hooks.external.WorldGuardHK;
import studio.magemonkey.codex.hooks.external.citizens.CitizensHK;
import studio.magemonkey.codex.items.CodexItemManager;
import studio.magemonkey.codex.legacy.item.BookDataBuilder;
import studio.magemonkey.codex.legacy.item.EnchantmentStorageBuilder;
import studio.magemonkey.codex.legacy.item.FireworkBuilder;
import studio.magemonkey.codex.legacy.item.FireworkEffectBuilder;
import studio.magemonkey.codex.legacy.item.ItemBuilder;
import studio.magemonkey.codex.legacy.item.LeatherArmorBuilder;
import studio.magemonkey.codex.legacy.item.MapBuilder;
import studio.magemonkey.codex.legacy.item.PotionDataBuilder;
import studio.magemonkey.codex.legacy.item.SkullBuilder;
import studio.magemonkey.codex.legacy.placeholder.PlaceholderRegistry;
import studio.magemonkey.codex.legacy.riseitem.DarkRiseItemImpl;
import studio.magemonkey.codex.listeners.BoatListener;
import studio.magemonkey.codex.listeners.InteractListener;
import studio.magemonkey.codex.listeners.JoinListener;
import studio.magemonkey.codex.manager.api.menu.MenuManager;
import studio.magemonkey.codex.manager.editor.EditorManager;
import studio.magemonkey.codex.mccore.chat.ChatCommander;
import studio.magemonkey.codex.mccore.chat.ChatListener;
import studio.magemonkey.codex.mccore.config.Config;
import studio.magemonkey.codex.mccore.scoreboard.BoardListener;
import studio.magemonkey.codex.mccore.scoreboard.CycleTask;
import studio.magemonkey.codex.mccore.scoreboard.ScoreboardCommander;
import studio.magemonkey.codex.mccore.scoreboard.UpdateTask;
import studio.magemonkey.codex.migration.MigrationUtil;
import studio.magemonkey.codex.nms.NMS;
import studio.magemonkey.codex.nms.packets.PacketManager;
import studio.magemonkey.codex.util.Debugger;
import studio.magemonkey.codex.util.ItemUT;
import studio.magemonkey.codex.util.Reflex;
import studio.magemonkey.codex.util.actions.ActionsManager;
import studio.magemonkey.codex.util.craft.CraftManager;
import studio.magemonkey.codex.util.messages.MessageUtil;

public class CodexEngine
extends CodexPlugin<CodexEngine>
implements Listener {
    private static final Hashtable<String, Config> configs = new Hashtable();
    private static CodexEngine instance;
    private final Set<CodexPlugin<?>> plugins;
    private NMS NMS;
    private PluginManager pluginManager;
    private PacketManager packetManager;
    private ActionsManager actionsManager;
    private CraftManager craftManager;
    private MenuManager menuManager;
    private VaultHK vault;
    private CitizensHK citizens;
    private WorldGuardHK worldGuard;
    private IMythicHook mythicMobs;
    private CoreConfig cfg;
    private CoreLang lang;
    private HookManager hooksManager;
    private CodexItemManager itemManager;
    private boolean chatEnabled;
    private String commandMessage = "&4Please wait &6{time} seconds &4before using the command again.";
    private boolean scoreboardsEnabled;
    private UnstuckCommand unstuck;
    private CycleTask cTask;
    private UpdateTask uTask;

    public CodexEngine() {
        this.setInstance();
        this.plugins = new HashSet();
    }

    public CodexEngine(JavaPluginLoader loader, PluginDescriptionFile description, File dataFolder, File file) {
        super(loader, description, dataFolder, file);
        this.setInstance();
        this.plugins = new HashSet();
    }

    private void setInstance() {
        instance = this;
        this.pluginManager = this.getServer().getPluginManager();
        try {
            if (new File("plugins/ProMCCore").exists()) {
                this.getLogger().info("Migrating ProMCCore to Codex");
                MigrationUtil.renameDirectory("plugins/ProMCCore", "plugins/Codex");
                MigrationUtil.replace("plugins/Codex/lang/messages_en.yml", "Core:", "Codex:");
            }
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to migrate ProMCCore to Codex. " + e.getMessage());
        }
        ItemUT.setEngine(this);
        Reflex.setEngine(this);
    }

    @NotNull
    public static CodexEngine get() {
        return instance;
    }

    final boolean loadCore() {
        this.unstuck = new UnstuckCommand();
        ConfigurationSerialization.registerClass(ItemBuilder.class);
        ConfigurationSerialization.registerClass(EnchantmentStorageBuilder.class, (String)"Codex_EnchantmentStorageMeta");
        ConfigurationSerialization.registerClass(FireworkEffectBuilder.class, (String)"Codex_FireworkEffectMeta");
        ConfigurationSerialization.registerClass(LeatherArmorBuilder.class, (String)"Codex_LeatherArmorMeta");
        ConfigurationSerialization.registerClass(PotionDataBuilder.class, (String)"Codex_PotionMeta");
        ConfigurationSerialization.registerClass(FireworkBuilder.class, (String)"Codex_FireworkMeta");
        ConfigurationSerialization.registerClass(BookDataBuilder.class, (String)"Codex_BookMeta");
        ConfigurationSerialization.registerClass(SkullBuilder.class, (String)"Codex_SkullMeta");
        ConfigurationSerialization.registerClass(MapBuilder.class, (String)"Codex_MapMeta");
        ConfigurationSerialization.registerClass(ItemBuilder.class, (String)"Codex_Item");
        ConfigurationSerialization.registerClass(DarkRiseItemImpl.class, (String)"DarkRiseItemImpl");
        ConfigurationSerialization.registerClass(DarkRiseItemImpl.DivineItemsMeta.class, (String)"DarkRiseItemImpl_Divine");
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "promcteam:codex");
        this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, "promcteam:codex", (PluginMessageListener)new BungeeListener());
        if (!this.setupNMS()) {
            this.error("Could not setup NMS version. Plugin will be disabled.");
            return false;
        }
        MessageUtil.load(LegacyConfigManager.loadConfigFile(new File(String.valueOf(this.getDataFolder()) + File.separator + "lang", "messages_en.yml"), this.getResource("lang/messages_en.yml")), (Plugin)this);
        PlaceholderRegistry.load();
        this.setupManagers();
        return true;
    }

    protected void registerEvents() {
        this.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getPluginManager().registerEvents((Listener)new ArmorListener(), (Plugin)this);
        this.getPluginManager().registerEvents((Listener)this.unstuck, (Plugin)this);
        this.getPluginManager().registerEvents((Listener)new BoatListener(), (Plugin)this);
        this.getPluginManager().registerEvents((Listener)new InteractListener(this.cfg().getJYML()), (Plugin)this);
        this.getPluginManager().registerEvents((Listener)new JoinListener(this, this.cfg().getJYML()), (Plugin)this);
    }

    private void setupManagers() {
        this.hooksManager = new HookManager(this);
        this.hooksManager.setup();
        this.itemManager = new CodexItemManager(this);
        this.itemManager.init();
        this.packetManager = new PacketManager(this);
        this.packetManager.setup();
        this.actionsManager = new ActionsManager(this);
        this.actionsManager.setup();
        this.craftManager = new CraftManager(this);
        this.craftManager.setup();
        this.menuManager = new MenuManager(this);
        this.menuManager.setup();
    }

    private boolean setupNMS() {
        Version current = Version.CURRENT;
        String[] split = Bukkit.getServer().getClass().getPackage().getName().split("\\.");
        String rawVersion = split[split.length - 1];
        this.info("You are running MC version " + String.valueOf((Object)current) + " (RAW: " + rawVersion + ")");
        if (current == null) {
            this.error("===== Codex Initialization Failure =====");
            this.error(rawVersion + " is not currently supported. Is this a new version of Spigot?");
            this.error("If this is a new version, please be patient and wait for a new build supporting the new version");
            this.error("If this is a version older than 1.16.5, sorry. We don't support <1.16.5");
            this.error("============================================");
            return false;
        }
        this.setNMS(new NMS());
        return true;
    }

    @Override
    public void enable() {
        EditorManager.setup();
        this.getLogger().info("Codex has been enabled!");
    }

    @Override
    public void disable() {
        if (this.actionsManager != null) {
            this.actionsManager.shutdown();
            this.actionsManager = null;
        }
        if (this.packetManager != null) {
            this.packetManager.shutdown();
        }
        if (this.hooksManager != null) {
            this.hooksManager.shutdown();
        }
        if (this.craftManager != null) {
            this.craftManager.shutdown();
            this.craftManager = null;
        }
        if (this.isScoreboardsEnabled()) {
            this.cTask.cancel();
            this.uTask.cancel();
        }
        EditorManager.shutdown();
    }

    @Override
    public void setConfig() {
        this.cfg = new CoreConfig(this);
        this.cfg.setup();
        this.commandMessage = this.cfg.getJYML().getString("Settings.command-cooldown-message", "&4Please wait &6{time} seconds &4before using the command again.");
        this.chatEnabled = this.cfg.getJYML().getBoolean("Features.chat-enabled", true);
        this.scoreboardsEnabled = this.cfg.getJYML().getBoolean("Features.scoreboards-enabled", true);
        BUNGEE_ID = this.cfg().getJYML().getString("bungee_id", "server");
        IS_BUNGEE = this.cfg().getJYML().getBoolean("bungee", false);
        boolean debug = this.cfg().getJYML().getBoolean("debug", false);
        Debugger.setDebug(debug);
        if (this.chatEnabled) {
            new ChatCommander((Plugin)this);
            new ChatListener(this);
        }
        if (this.scoreboardsEnabled) {
            new ScoreboardCommander((Plugin)this);
            new BoardListener((Plugin)this);
            this.cTask = new CycleTask((Plugin)this);
            this.uTask = new UpdateTask((Plugin)this);
        }
        this.lang = new CoreLang(this);
        this.lang.setup();
    }

    @Override
    public void registerHooks() {
        try {
            this.vault = this.registerHook("Vault", VaultHK.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void registerCommands(@NotNull IGeneralCommand<CodexEngine> mainCommand) {
        mainCommand.addSubCommand(new Base64Command(this));
        PluginCommand unstuckCommand = this.getCommand("stuck");
        if (unstuckCommand != null) {
            unstuckCommand.setExecutor((CommandExecutor)this.unstuck);
        }
    }

    @Override
    public void registerEditor() {
    }

    @Override
    @NotNull
    public CoreConfig cfg() {
        return this.cfg;
    }

    @Override
    @NotNull
    public CoreLang lang() {
        return this.lang;
    }

    void hookChild(@NotNull CodexPlugin<?> child) {
        this.plugins.add(child);
    }

    @NotNull
    public Set<CodexPlugin<?>> getChildPlugins() {
        return this.plugins;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onHookLate(PluginEnableEvent e) {
        String name = e.getPlugin().getName();
        try {
            if (this.mythicMobs == null && name.equalsIgnoreCase("MythicMobs")) {
                boolean mythic4 = true;
                try {
                    Class.forName("io.lumine.xikage.mythicmobs.MythicMobs");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    mythic4 = false;
                }
                this.mythicMobs = mythic4 ? (IMythicHook)this.registerHook("MythicMobs", MythicMobsHK.class) : (IMythicHook)this.registerHook("MythicMobs", MythicMobsHKv5.class);
                return;
            }
            if (this.worldGuard == null && name.equalsIgnoreCase("WorldGuard")) {
                this.worldGuard = this.registerHook("WorldGuard", WorldGuardHK.class);
                return;
            }
            if (this.citizens == null && name.equalsIgnoreCase("Citizens")) {
                this.citizens = this.registerHook("Citizens", CitizensHK.class);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Config getConfigFile(JavaPlugin plugin, String file) {
        if (!configs.containsKey(file.toLowerCase() + plugin.getName())) {
            Config config = new Config(plugin, file);
            this.registerConfig(config);
            return config;
        }
        return configs.get(file.toLowerCase() + plugin.getName());
    }

    public void registerConfig(Config config) {
        configs.put(config.getFile().toLowerCase() + config.getPlugin().getName(), config);
    }

    @Override
    @Generated
    public NMS getNMS() {
        return this.NMS;
    }

    @Generated
    public void setNMS(NMS NMS2) {
        this.NMS = NMS2;
    }

    @Override
    @Generated
    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    @Override
    @Generated
    public PacketManager getPacketManager() {
        return this.packetManager;
    }

    @Override
    @Generated
    public ActionsManager getActionsManager() {
        return this.actionsManager;
    }

    @Override
    @Generated
    public CraftManager getCraftManager() {
        return this.craftManager;
    }

    @Generated
    public MenuManager getMenuManager() {
        return this.menuManager;
    }

    @Override
    @Generated
    public VaultHK getVault() {
        return this.vault;
    }

    @Override
    @Generated
    public CitizensHK getCitizens() {
        return this.citizens;
    }

    @Override
    @Generated
    public WorldGuardHK getWorldGuard() {
        return this.worldGuard;
    }

    @Override
    @Generated
    public IMythicHook getMythicMobs() {
        return this.mythicMobs;
    }

    @Generated
    public HookManager getHooksManager() {
        return this.hooksManager;
    }

    @Generated
    public CodexItemManager getItemManager() {
        return this.itemManager;
    }

    @Generated
    public boolean isChatEnabled() {
        return this.chatEnabled;
    }

    @Generated
    public String getCommandMessage() {
        return this.commandMessage;
    }

    @Generated
    public boolean isScoreboardsEnabled() {
        return this.scoreboardsEnabled;
    }
}

