/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.api.CommandType;
import studio.magemonkey.codex.api.DelayedCommand;
import studio.magemonkey.codex.api.Replacer;
import studio.magemonkey.codex.util.SerializationBuilder;
import studio.magemonkey.risecore.legacy.util.DeserializationWorker;

public class CommandBlock
implements ConfigurationSerializable {
    private Material material;
    private int type = -1;
    private String permission;
    private boolean cancelAction = true;
    private List<DelayedCommand> delayedCommands = Collections.singletonList(new DelayedCommand(CommandType.CONSOLE, "say {player}", 0));

    public CommandBlock(Map<String, Object> map) {
        DeserializationWorker w = DeserializationWorker.start(map);
        this.material = w.getEnum("material", Material.AIR);
        this.type = w.getInt("type", -1);
        this.cancelAction = w.getBoolean("cancelAction", true);
        this.delayedCommands = DelayedCommand.deserializeMapList((List)w.getTypedObject("delayedCommands"));
        Validate.notEmpty(this.delayedCommands, (String)("Commands can't be empty! " + String.valueOf(this)), (Object[])new Object[0]);
    }

    public CommandBlock(Material material, int type, String permission, boolean cancelAction, DelayedCommand ... delayedCommands) {
        this.material = material;
        this.type = type;
        this.permission = permission;
        this.cancelAction = cancelAction;
        this.delayedCommands = new ArrayList<DelayedCommand>(Arrays.asList(delayedCommands));
    }

    public void invoke(PlayerEvent event, Replacer ... reps) {
        Player player = event.getPlayer();
        if (this.delayedCommands == null || this.delayedCommands.isEmpty()) {
            return;
        }
        if (player.hasPermission("general.oninteract.bypass")) {
            return;
        }
        if (this.permission != null && !player.hasPermission(this.permission)) {
            return;
        }
        if (this.cancelAction && event instanceof Cancellable) {
            ((Cancellable)event).setCancelled(true);
        }
        DelayedCommand.invoke((Plugin)CodexEngine.get(), (CommandSender)player, this.delayedCommands, reps);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CommandBlock)) {
            return false;
        }
        CommandBlock block = (CommandBlock)o;
        return new EqualsBuilder().append(this.type, block.type).append((Object)this.material, (Object)block.material).append(this.delayedCommands, block.delayedCommands).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.material).append(this.type).append(this.delayedCommands).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("material", (Object)this.material).append("type", this.type).append("delayedCommands", this.delayedCommands).toString();
    }

    @NotNull
    public Map<String, Object> serialize() {
        return SerializationBuilder.start(3).append("material", (Enum<?>)this.material).append("type", (Object)this.type).append("cancelAction", (Object)this.cancelAction).append("delayedCommands", this.delayedCommands).build();
    }

    @Generated
    public void setMaterial(Material material) {
        this.material = material;
    }

    @Generated
    public void setType(int type) {
        this.type = type;
    }

    @Generated
    public void setPermission(String permission) {
        this.permission = permission;
    }

    @Generated
    public void setCancelAction(boolean cancelAction) {
        this.cancelAction = cancelAction;
    }

    @Generated
    public void setDelayedCommands(List<DelayedCommand> delayedCommands) {
        this.delayedCommands = delayedCommands;
    }

    @Generated
    public Material getMaterial() {
        return this.material;
    }

    @Generated
    public int getType() {
        return this.type;
    }

    @Generated
    public String getPermission() {
        return this.permission;
    }

    @Generated
    public boolean isCancelAction() {
        return this.cancelAction;
    }

    @Generated
    public List<DelayedCommand> getDelayedCommands() {
        return this.delayedCommands;
    }

    @Generated
    public CommandBlock() {
    }

    @Generated
    public CommandBlock(Material material, int type, String permission, boolean cancelAction, List<DelayedCommand> delayedCommands) {
        this.material = material;
        this.type = type;
        this.permission = permission;
        this.cancelAction = cancelAction;
        this.delayedCommands = delayedCommands;
    }
}

