/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.api;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.api.CommandType;
import studio.magemonkey.codex.api.Replacer;
import studio.magemonkey.codex.util.Debugger;
import studio.magemonkey.codex.util.SerializationBuilder;
import studio.magemonkey.risecore.legacy.util.DeserializationWorker;

public class DelayedCommand
implements ConfigurationSerializable {
    private CommandType as;
    private String cmd;
    private int delay;

    public DelayedCommand() {
        this.as = CommandType.CONSOLE;
        this.cmd = "";
        this.delay = 0;
        Debugger.log("Created DelayedCommand with empty constructor");
    }

    public DelayedCommand(Map<String, Object> map) {
        DeserializationWorker w = DeserializationWorker.start(map);
        this.delay = w.getInt("delay", 0);
        this.as = w.getEnum("as", CommandType.CONSOLE);
        this.cmd = w.getString("cmd");
        Validate.notEmpty((CharSequence)this.cmd, (String)("Command can't be empty! " + String.valueOf(this)), (Object[])new Object[0]);
    }

    public static void invoke(Plugin plugin, CommandSender target, Iterable<DelayedCommand> commands, Replacer ... reps) {
        DelayedCommand.invoke(plugin, target, commands, null, reps);
    }

    public static void invoke(Plugin plugin, CommandSender target, Iterable<DelayedCommand> commands, Runnable onEnd, Replacer ... reps) {
        Iterator<DelayedCommand> it = commands.iterator();
        if (!it.hasNext()) {
            return;
        }
        it.next().invoke(plugin, target, it, onEnd, reps);
    }

    public static List<DelayedCommand> deserializeMapList(List<Map<String, Object>> list) {
        return list.stream().map(DelayedCommand::new).collect(Collectors.toList());
    }

    public void invoke(Plugin plugin, CommandSender target, Iterator<DelayedCommand> next, Runnable onEnd, Replacer ... reps) {
        Runnable action = () -> {
            this.as.invoke(target, this.cmd, reps);
            if (next != null && next.hasNext()) {
                ((DelayedCommand)next.next()).invoke(plugin, target, next, onEnd, reps);
            } else if (onEnd != null) {
                onEnd.run();
            }
        };
        if (this.delay == 0) {
            action.run();
            return;
        }
        Bukkit.getScheduler().runTaskLater(plugin, action, (long)this.delay);
    }

    @NotNull
    public Map<String, Object> serialize() {
        return SerializationBuilder.start(3).append("delay", (Object)this.delay).append("as", this.as).append("cmd", (Object)this.cmd).build();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("as", (Object)this.as).append("cmd", (Object)this.cmd).append("delay", this.delay).toString();
    }

    @Generated
    public CommandType getAs() {
        return this.as;
    }

    @Generated
    public String getCmd() {
        return this.cmd;
    }

    @Generated
    public int getDelay() {
        return this.delay;
    }

    @Generated
    public void setAs(CommandType as) {
        this.as = as;
    }

    @Generated
    public void setCmd(String cmd) {
        this.cmd = cmd;
    }

    @Generated
    public void setDelay(int delay) {
        this.delay = delay;
    }

    @Generated
    public DelayedCommand(CommandType as, String cmd, int delay) {
        this.as = as;
        this.cmd = cmd;
        this.delay = delay;
    }
}

