/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.config.api;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.manager.api.gui.ContentType;
import studio.magemonkey.codex.manager.api.gui.GuiItem;
import studio.magemonkey.codex.manager.types.ClickType;
import studio.magemonkey.codex.util.CollectionsUT;
import studio.magemonkey.codex.util.FileUT;
import studio.magemonkey.codex.util.ItemUT;
import studio.magemonkey.codex.util.LocUT;
import studio.magemonkey.codex.util.NamespaceResolver;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.codex.util.actions.ActionManipulator;
import studio.magemonkey.codex.util.craft.api.ICraftRecipe;
import studio.magemonkey.codex.util.craft.api.IFurnaceRecipe;
import studio.magemonkey.codex.util.random.Rnd;

public class JYML
extends YamlConfiguration {
    private final File file;
    private boolean isChanged = false;

    public JYML(@NotNull String path, @NotNull String file) throws InvalidConfigurationException {
        this(new File(path, file));
    }

    public JYML(@NotNull File file) throws InvalidConfigurationException {
        FileUT.create(file);
        this.file = file;
        this.reload();
    }

    @NotNull
    public File getFile() {
        return this.file;
    }

    public void save() {
        try {
            this.save(this.file);
        }
        catch (IOException e) {
            CodexEngine.get().error("Could not save config: " + this.file.getName());
            e.printStackTrace();
        }
    }

    public boolean saveChanges() {
        if (this.isChanged) {
            this.save();
            this.isChanged = false;
            return true;
        }
        return false;
    }

    public boolean reload() throws InvalidConfigurationException {
        if (!this.file.exists()) {
            return false;
        }
        try {
            this.load(this.file);
            this.isChanged = false;
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @NotNull
    public static JYML loadOrExtract(@NotNull CodexPlugin<?> plugin, @NotNull String filePath) throws InvalidConfigurationException {
        File file;
        if (!plugin.getDataFolder().exists()) {
            FileUT.mkdir(plugin.getDataFolder());
        }
        if (!((String)filePath).startsWith("/")) {
            filePath = "/" + (String)filePath;
        }
        if (!(file = new File(String.valueOf(plugin.getDataFolder()) + (String)filePath)).exists()) {
            FileUT.create(file);
            try {
                InputStream input = plugin.getClass().getResourceAsStream((String)filePath);
                FileUT.copy(input, file);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return new JYML(file);
    }

    @NotNull
    public static List<JYML> loadAll(@NotNull String path, boolean deep) {
        ArrayList<JYML> configs = new ArrayList<JYML>();
        for (File file : FileUT.getFiles(path, deep)) {
            try {
                configs.add(new JYML(file));
            }
            catch (InvalidConfigurationException e) {
                CodexEngine.get().error("Could not load " + file.getAbsolutePath() + ": Configuration error");
                e.printStackTrace();
            }
        }
        return configs;
    }

    public boolean addMissing(@NotNull String path, @Nullable Object val) {
        if (this.contains(path)) {
            return false;
        }
        this.set(path, val);
        return true;
    }

    public void set(String path, @Nullable Object o) {
        if (o instanceof Set) {
            o = new ArrayList((Set)o);
        } else if (o instanceof Location) {
            o = LocUT.serialize((Location)o);
        }
        super.set(path, o);
        this.isChanged = true;
    }

    public boolean remove(@NotNull String path) {
        if (!this.contains(path)) {
            return false;
        }
        this.set(path, null);
        return true;
    }

    @NotNull
    public Set<String> getSection(@NotNull String path) {
        ConfigurationSection section = this.getConfigurationSection(path);
        return section == null ? Collections.emptySet() : section.getKeys(false);
    }

    @Nullable
    public String getString(String path) {
        String str = super.getString(path);
        return str == null || str.isEmpty() ? null : str;
    }

    @NotNull
    public String getString(String path, @Nullable String def) {
        String str = super.getString(path, def);
        if (str == null) {
            return def != null ? def : "";
        }
        return str;
    }

    @NotNull
    public Set<String> getStringSet(@NotNull String path) {
        return new HashSet<String>(this.getStringList(path));
    }

    @Nullable
    public Location getLocation(String path) {
        String raw = this.getString(path);
        return raw == null ? null : LocUT.deserialize(raw);
    }

    @Deprecated
    public void setLocation(@NotNull String path, @Nullable Location loc) {
        this.set(path, loc == null ? null : LocUT.serialize(loc));
    }

    public int[] getIntArray(@NotNull String path) {
        int[] slots = new int[]{};
        String str = this.getString(path);
        if (str == null) {
            return slots;
        }
        String[] raw = str.replaceAll("\\s", "").split(",");
        slots = new int[raw.length];
        for (int i = 0; i < raw.length; ++i) {
            try {
                slots[i] = Integer.parseInt(raw[i].trim());
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return slots;
    }

    public void setIntArray(@NotNull String path, int[] arr) {
        if (arr == null) {
            this.set(path, null);
            return;
        }
        StringBuilder str = new StringBuilder();
        for (int num : arr) {
            if (str.length() > 0) {
                str.append(",");
            }
            str.append(num);
        }
        this.set(path, str.toString());
    }

    @NotNull
    public ItemStack getItem(@NotNull String path) {
        return this.getItem(path, false);
    }

    @NotNull
    public ItemStack getItem(@NotNull String path, boolean id) {
        int model;
        String name;
        int durability;
        Material material;
        if (!((String)path).isEmpty() && !((String)path).endsWith(".")) {
            path = (String)path + ".";
        }
        if ((material = Material.getMaterial((String)this.getString((String)path + "material", "").toUpperCase())) == null || material == Material.AIR) {
            return new ItemStack(Material.AIR);
        }
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        item.setAmount(this.getInt((String)path + "amount", 1));
        String hash = this.getString((String)path + "skull-hash", this.getString((String)path + "head-texture"));
        if (!hash.isEmpty()) {
            if (id) {
                String idz = this.getFile().getName().replace(".yml", "");
                ItemUT.addSkullTexture(item, hash, idz);
            } else {
                ItemUT.addSkullTexture(item, hash);
            }
        }
        if ((durability = this.getInt((String)path + "durability")) > 0 && meta instanceof Damageable) {
            Damageable d = (Damageable)meta;
            d.setDamage(durability);
        }
        meta.setDisplayName((name = this.getString((String)path + "name")) != null ? StringUT.color(name) : null);
        meta.setLore(StringUT.color(this.getStringList((String)path + "lore")));
        if (this.getBoolean((String)path + "enchanted")) {
            meta.addEnchant(NamespaceResolver.getEnchantment("UNBREAKING", "DURABILITY"), 1, true);
        }
        meta.setCustomModelData((model = this.getInt((String)path + "model-data", this.getInt((String)path + "custom-model-data"))) != 0 ? Integer.valueOf(model) : null);
        List flags = this.getStringList((String)path + "item-flags");
        if (flags.contains("*")) {
            meta.addItemFlags(ItemFlag.values());
        } else {
            for (String flag : flags) {
                ItemFlag itemFlag = CollectionsUT.getEnum(flag, ItemFlag.class);
                if (itemFlag == null) continue;
                meta.addItemFlags(new ItemFlag[]{itemFlag});
            }
        }
        String color = this.getString((String)path + "color");
        if (color != null && !color.isEmpty()) {
            int b;
            String[] rgb = color.split(",");
            int r = StringUT.getInteger(rgb[0], Rnd.get(255));
            int g = rgb.length >= 2 ? StringUT.getInteger(rgb[1], Rnd.get(255)) : Rnd.get(255);
            int n = b = rgb.length >= 3 ? StringUT.getInteger(rgb[2], Rnd.get(255)) : Rnd.get(255);
            if (meta instanceof LeatherArmorMeta) {
                LeatherArmorMeta lm = (LeatherArmorMeta)meta;
                lm.setColor(Color.fromRGB((int)r, (int)g, (int)b));
            } else if (meta instanceof PotionMeta) {
                PotionMeta pm = (PotionMeta)meta;
                pm.setColor(Color.fromRGB((int)r, (int)g, (int)b));
            }
        }
        meta.setUnbreakable(this.getBoolean((String)path + "unbreakable"));
        item.setItemMeta(meta);
        return item;
    }

    @Nullable
    public GuiItem getGuiItem(@NotNull String path) {
        return this.getGuiItem(path, null);
    }

    @Nullable
    public <T extends Enum<T>> GuiItem getGuiItem(@NotNull String path, @Nullable Class<T> clazzEnum) {
        String[] ss;
        Object id;
        Object frameItem;
        int frame;
        ItemStack item;
        if (!((String)path).endsWith(".")) {
            path = (String)path + ".";
        }
        if ((item = this.getItem((String)path)).getType() == Material.AIR) {
            return null;
        }
        int[] slots = this.getIntArray((String)path + "slots");
        ContentType type = ContentType.NONE;
        if (clazzEnum != null) {
            String typeRaw = this.getString((String)path + "type", "");
            T eConfig = CollectionsUT.getEnum(typeRaw, clazzEnum);
            type = eConfig == null ? CollectionsUT.getEnum(typeRaw, ContentType.class) : eConfig;
        }
        boolean animAutoPlay = this.getBoolean((String)path + "animation.auto-play");
        int animStartFrame = this.getInt((String)path + "animation.start-frame");
        TreeMap<Integer, ItemStack> animFrames = new TreeMap<Integer, ItemStack>();
        for (String sFrame : this.getSection((String)path + "animation-frames")) {
            frame = StringUT.getInteger(sFrame, -1);
            if (frame < 0) continue;
            frameItem = this.getItem((String)path + "animation-frames." + sFrame);
            animFrames.put(frame, (ItemStack)frameItem);
        }
        if (animFrames.isEmpty()) {
            for (String sFrame : this.getSection((String)path + "animation.frames")) {
                frame = StringUT.getInteger(sFrame, -1);
                if (frame < 0) continue;
                frameItem = this.getItem((String)path + "animation.frames." + sFrame);
                animFrames.put(frame, (ItemStack)frameItem);
            }
        }
        if ((id = (ss = ((String)path).split("\\."))[ss.length - 1]) == null || ((String)id).isEmpty()) {
            id = this.file.getName().replace(".yml", "") + "-icon-" + Rnd.get(3000);
        }
        HashMap<ClickType, ActionManipulator> customClicks = new HashMap<ClickType, ActionManipulator>();
        for (String sType : this.getSection((String)path + "custom-actions")) {
            ClickType clickType = CollectionsUT.getEnum(sType, ClickType.class);
            if (clickType == null) continue;
            ActionManipulator actions = new ActionManipulator(CodexEngine.get(), this, (String)path + "custom-actions." + sType);
            customClicks.put(clickType, actions);
        }
        String permission = this.getString((String)path + "permission");
        GuiItem guiItem = new GuiItem((String)id, type, item, animAutoPlay, animStartFrame, animFrames, customClicks, permission, slots);
        return guiItem;
    }

    public void setItem(@NotNull String path, @Nullable ItemStack item) {
        List lore;
        if (item == null) {
            this.set((String)path, null);
            return;
        }
        if (!((String)path).endsWith(".")) {
            path = (String)path + ".";
        }
        this.set(((String)path).substring(0, ((String)path).length() - 1), null);
        Material material = item.getType();
        this.set((String)path + "material", material.name());
        this.set((String)path + "amount", item.getAmount());
        this.set((String)path + "head-texture", ItemUT.getSkullTexture(item));
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        if (meta instanceof Damageable) {
            int durability = ((Damageable)meta).getDamage();
            this.set((String)path + "durability", durability);
        }
        if (meta.hasDisplayName()) {
            this.set((String)path + "name", StringUT.colorRaw(meta.getDisplayName()));
        }
        if ((lore = meta.getLore()) != null) {
            ArrayList loreRaw = new ArrayList();
            lore.forEach(line -> loreRaw.add(StringUT.colorRaw(line)));
            this.set((String)path + "lore", loreRaw);
        }
        this.set((String)path + "enchanted", meta.hasEnchants());
        this.set((String)path + "custom-model-data", meta.hasCustomModelData() ? Integer.valueOf(meta.getCustomModelData()) : null);
        Color color = null;
        String colorRaw = null;
        if (meta instanceof PotionMeta) {
            PotionMeta pm = (PotionMeta)meta;
            color = pm.getColor();
        } else if (meta instanceof LeatherArmorMeta) {
            LeatherArmorMeta lm = (LeatherArmorMeta)meta;
            color = lm.getColor();
        }
        if (color != null) {
            colorRaw = color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ",";
        }
        this.set((String)path + "color", colorRaw);
        List itemFlags = meta.getItemFlags().stream().map(Enum::name).collect(Collectors.toList());
        this.set((String)path + "item-flags", itemFlags);
        this.set((String)path + "unbreakable", meta.isUnbreakable());
    }

    @Nullable
    public ItemStack getItem64(@NotNull String path) {
        String code = this.getString(path);
        if (code == null) {
            return null;
        }
        return ItemUT.fromBase64(code);
    }

    public void setItem64(@NotNull String path, @Nullable ItemStack item) {
        if (item == null) {
            this.set(path, null);
        } else {
            try {
                String code = ItemUT.toBase64(item);
                this.set(path, code);
            }
            catch (Exception e) {
                CodexEngine.get().getLogger().warning("Could not set Item64");
                e.printStackTrace();
            }
        }
    }

    @NotNull
    public ItemStack[] getItemList64(@NotNull String path) {
        List list = this.getStringList(path);
        return ItemUT.fromBase64(list);
    }

    public void setItemList64(@NotNull String path, @NotNull List<ItemStack> item) {
        List<String> code = ItemUT.toBase64(item);
        this.set(path, code);
    }

    @Nullable
    public ICraftRecipe getCraftRecipe(@NotNull CodexPlugin<?> plugin, @NotNull String path) {
        if (!((String)path).endsWith(".")) {
            path = (String)path + ".";
        }
        String id = this.getString((String)path + "id", this.file.getName().replace(".yml", ""));
        boolean shape = this.getBoolean((String)path + "shaped");
        ItemStack result = this.getItem64((String)path + "result");
        if (result == null) {
            return null;
        }
        ICraftRecipe recipe = new ICraftRecipe(plugin, id, result, shape);
        int ingCount = 0;
        for (String s : this.getSection((String)path + "ingredients")) {
            String path2 = (String)path + "ingredients." + s;
            ItemStack ing = this.getItem64(path2);
            recipe.addIngredient(ingCount, ing);
            ++ingCount;
        }
        return recipe;
    }

    public void setRecipe(@NotNull String path, @Nullable ICraftRecipe recipe) {
        if (!((String)path).endsWith(".")) {
            path = (String)path + ".";
        }
        if (recipe == null) {
            if (((String)path).endsWith(".")) {
                path = ((String)path).substring(0, ((String)path).length() - 1);
            }
            this.set((String)path, null);
            return;
        }
        this.set((String)path + "shaped", recipe.isShaped());
        this.setItem64((String)path + "result", recipe.getResult());
        char[] ziga = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I'};
        ItemStack[] ings = recipe.getIngredients();
        for (int i = 0; i < ings.length; ++i) {
            char c = ziga[i];
            this.setItem64((String)path + "ingredients." + c, ings[i]);
        }
    }

    @Nullable
    public IFurnaceRecipe getFurnaceRecipe(@NotNull CodexPlugin<?> plugin, @NotNull String path) {
        if (!((String)path).endsWith(".")) {
            path = (String)path + ".";
        }
        String id = this.getString((String)path + "id", this.file.getName().replace(".yml", ""));
        ItemStack input = this.getItem64((String)path + "input");
        ItemStack result = this.getItem64((String)path + "result");
        if (result == null || input == null) {
            return null;
        }
        float exp = (float)this.getDouble((String)path + "exp");
        double time = this.getDouble((String)path + "time");
        IFurnaceRecipe recipe = new IFurnaceRecipe(plugin, id, result, exp, time);
        recipe.addIngredient(input);
        return recipe;
    }

    public void setRecipe(@NotNull String path, @Nullable IFurnaceRecipe recipe) {
        if (!((String)path).endsWith(".")) {
            path = (String)path + ".";
        }
        if (recipe == null) {
            if (((String)path).endsWith(".")) {
                path = ((String)path).substring(0, ((String)path).length() - 1);
            }
            this.set((String)path, null);
            return;
        }
        this.setItem64((String)path + "input", recipe.getInput());
        this.setItem64((String)path + "result", recipe.getResult());
        this.set((String)path + "exp", Float.valueOf(recipe.getExp()));
        this.set((String)path + "time", (double)recipe.getTime() / 20.0);
    }
}

